/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.gui.options.control;

import me.jellysquid.mods.sodium.client.gui.options.Option;
import me.jellysquid.mods.sodium.client.gui.options.control.Control;
import me.jellysquid.mods.sodium.client.gui.options.control.ControlElement;
import me.jellysquid.mods.sodium.client.gui.options.control.ControlValueFormatter;
import me.jellysquid.mods.sodium.client.util.Dim2i;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_768;
import org.apache.commons.lang3.Validate;

public class SliderControl
implements Control<Integer> {
    private final Option<Integer> option;
    private final int min;
    private final int max;
    private final int interval;
    private final ControlValueFormatter mode;

    public SliderControl(Option<Integer> option, int min, int max, int interval, ControlValueFormatter mode) {
        Validate.isTrue((max > min ? 1 : 0) != 0, (String)"The maximum value must be greater than the minimum value", (Object[])new Object[0]);
        Validate.isTrue((interval > 0 ? 1 : 0) != 0, (String)"The slider interval must be greater than zero", (Object[])new Object[0]);
        Validate.isTrue(((max - min) % interval == 0 ? 1 : 0) != 0, (String)"The maximum value must be divisable by the interval", (Object[])new Object[0]);
        Validate.notNull((Object)mode, (String)"The slider mode must not be null", (Object[])new Object[0]);
        this.option = option;
        this.min = min;
        this.max = max;
        this.interval = interval;
        this.mode = mode;
    }

    @Override
    public ControlElement<Integer> createElement(Dim2i dim) {
        return new Button(this.option, dim, this.min, this.max, this.interval, this.mode);
    }

    @Override
    public Option<Integer> getOption() {
        return this.option;
    }

    @Override
    public int getMaxWidth() {
        return 130;
    }

    private static class Button
    extends ControlElement<Integer> {
        private static final int THUMB_WIDTH = 2;
        private static final int TRACK_HEIGHT = 1;
        private final class_768 sliderBounds;
        private final ControlValueFormatter formatter;
        private final int min;
        private final int range;
        private final int interval;
        private double thumbPosition;

        public Button(Option<Integer> option, Dim2i dim, int min, int max, int interval, ControlValueFormatter formatter) {
            super(option, dim);
            this.min = min;
            this.range = max - min;
            this.interval = interval;
            this.thumbPosition = this.getThumbPositionForValue(option.getValue());
            this.formatter = formatter;
            this.sliderBounds = new class_768(dim.getLimitX() - 96, dim.getCenterY() - 5, 90, 10);
        }

        @Override
        public void method_25394(class_4587 matrixStack, int mouseX, int mouseY, float delta) {
            super.method_25394(matrixStack, mouseX, mouseY, delta);
            if (this.option.isAvailable() && this.hovered) {
                this.renderSlider(matrixStack);
            } else {
                this.renderStandaloneValue(matrixStack);
            }
        }

        private void renderStandaloneValue(class_4587 matrixStack) {
            int sliderX = this.sliderBounds.method_3321();
            int sliderY = this.sliderBounds.method_3322();
            int sliderWidth = this.sliderBounds.method_3319();
            int sliderHeight = this.sliderBounds.method_3320();
            String label = this.formatter.format((Integer)this.option.getValue());
            int labelWidth = this.font.method_1727(label);
            this.drawString(matrixStack, label, sliderX + sliderWidth - labelWidth, sliderY + sliderHeight / 2 - 4, -1);
        }

        private void renderSlider(class_4587 matrixStack) {
            int sliderX = this.sliderBounds.method_3321();
            int sliderY = this.sliderBounds.method_3322();
            int sliderWidth = this.sliderBounds.method_3319();
            int sliderHeight = this.sliderBounds.method_3320();
            int thumbOffset = (int)Math.floor((double)(this.getIntValue() - this.min) / (double)this.range * (double)sliderWidth);
            int thumbX = sliderX + thumbOffset - 2;
            int trackY = sliderY + sliderHeight / 2 - 1;
            this.drawRect(thumbX, sliderY, thumbX + 4, sliderY + sliderHeight, -1);
            this.drawRect(sliderX, trackY, sliderX + sliderWidth, trackY + 1, -1);
            String label = String.valueOf(this.getIntValue());
            int labelWidth = this.font.method_1727(label);
            this.drawString(matrixStack, label, sliderX - labelWidth - 6, sliderY + sliderHeight / 2 - 4, -1);
        }

        public int getIntValue() {
            return this.min + this.interval * (int)Math.round(this.getSnappedThumbPosition() / (double)this.interval);
        }

        public double getSnappedThumbPosition() {
            return this.thumbPosition / (1.0 / (double)this.range);
        }

        public double getThumbPositionForValue(int value) {
            return (double)(value - this.min) * (1.0 / (double)this.range);
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (this.option.isAvailable() && button == 0 && this.sliderBounds.method_3318((int)mouseX, (int)mouseY)) {
                this.setValueFromMouse(mouseX);
                return true;
            }
            return false;
        }

        private void setValueFromMouse(double d) {
            this.setValue((d - (double)(this.sliderBounds.method_3321() + 4)) / (double)(this.sliderBounds.method_3319() - 8));
        }

        private void setValue(double d) {
            this.thumbPosition = class_3532.method_15350((double)d, (double)0.0, (double)1.0);
            int value = this.getIntValue();
            if ((Integer)this.option.getValue() != value) {
                this.option.setValue(value);
            }
        }

        public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
            if (this.option.isAvailable() && button == 0) {
                this.setValueFromMouse(mouseX);
                return true;
            }
            return false;
        }
    }
}

