/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.ObjectArrayFIFOQueue;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.ArrayDeque;
import java.util.Collection;
import me.jellysquid.mods.sodium.client.SodiumClientMod;
import me.jellysquid.mods.sodium.client.gl.util.GlFogHelper;
import me.jellysquid.mods.sodium.client.render.SodiumWorldRenderer;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkCameraContext;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkGraphicsState;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderBackend;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderColumn;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderContainer;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuilder;
import me.jellysquid.mods.sodium.client.render.chunk.cull.ChunkCuller;
import me.jellysquid.mods.sodium.client.render.chunk.cull.ChunkFaceFlags;
import me.jellysquid.mods.sodium.client.render.chunk.cull.graph.ChunkGraphCuller;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkRenderBounds;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkRenderData;
import me.jellysquid.mods.sodium.client.render.chunk.lists.ChunkRenderList;
import me.jellysquid.mods.sodium.client.render.chunk.lists.ChunkRenderListIterator;
import me.jellysquid.mods.sodium.client.render.chunk.passes.BlockRenderPass;
import me.jellysquid.mods.sodium.client.render.chunk.passes.BlockRenderPassManager;
import me.jellysquid.mods.sodium.client.util.math.FrustumExtended;
import me.jellysquid.mods.sodium.client.world.ChunkStatusListener;
import me.jellysquid.mods.sodium.common.util.DirectionUtil;
import me.jellysquid.mods.sodium.common.util.IdTable;
import me.jellysquid.mods.sodium.common.util.collections.FutureDequeDrain;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2826;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_638;

public class ChunkRenderManager<T extends ChunkGraphicsState>
implements ChunkStatusListener {
    private static final double NEARBY_CHUNK_DISTANCE = Math.pow(48.0, 2.0);
    private static final float FOG_PLANE_MIN_DISTANCE = (float)Math.pow(8.0, 2.0);
    private static final float FOG_PLANE_OFFSET = 12.0f;
    private final ChunkBuilder<T> builder;
    private final ChunkRenderBackend<T> backend;
    private final Long2ObjectOpenHashMap<ChunkRenderColumn<T>> columns = new Long2ObjectOpenHashMap();
    private final IdTable<ChunkRenderContainer<T>> renders = new IdTable(16384);
    private final ObjectArrayFIFOQueue<ChunkRenderContainer<T>> importantRebuildQueue = new ObjectArrayFIFOQueue();
    private final ObjectArrayFIFOQueue<ChunkRenderContainer<T>> rebuildQueue = new ObjectArrayFIFOQueue();
    public RenderContext<T> renderContext;
    private final SodiumWorldRenderer renderer;
    private final class_638 world;
    private final ChunkCuller culler;
    private final boolean useChunkFaceCulling;
    private float cameraX;
    private float cameraY;
    private float cameraZ;
    private boolean dirty;
    private int visibleChunkCount;
    private boolean useFogCulling;
    private double fogRenderCutoff;

    public ChunkRenderManager(SodiumWorldRenderer renderer, ChunkRenderBackend<T> backend, BlockRenderPassManager renderPassManager, class_638 world, int renderDistance) {
        this.backend = backend;
        this.renderer = renderer;
        this.world = world;
        this.builder = new ChunkBuilder<T>(backend.getVertexType(), this.backend);
        this.builder.init(world, renderPassManager);
        this.dirty = true;
        this.renderContext = new RenderContext();
        this.culler = new ChunkGraphCuller((class_1937)world, renderDistance);
        this.useChunkFaceCulling = SodiumClientMod.options().advanced.useChunkFaceCulling;
    }

    public void update(class_4184 camera, FrustumExtended frustum, int frame, boolean spectator) {
        this.reset();
        this.setup(camera);
        this.iterateChunks(camera, frustum, frame, spectator);
        this.dirty = false;
    }

    private void setup(class_4184 camera) {
        float dist;
        class_243 cameraPos = camera.method_19326();
        this.cameraX = (float)cameraPos.field_1352;
        this.cameraY = (float)cameraPos.field_1351;
        this.cameraZ = (float)cameraPos.field_1350;
        this.useFogCulling = false;
        if (SodiumClientMod.options().advanced.useFogOcclusion && (dist = GlFogHelper.getFogCutoff() + 12.0f) != 0.0f) {
            this.useFogCulling = true;
            this.fogRenderCutoff = Math.max(FOG_PLANE_MIN_DISTANCE, dist * dist);
        }
    }

    private void iterateChunks(class_4184 camera, FrustumExtended frustum, int frame, boolean spectator) {
        IntArrayList list = this.culler.computeVisible(camera, frustum, frame, spectator);
        IntListIterator it = list.iterator();
        while (it.hasNext()) {
            ChunkRenderContainer<T> render = this.renders.get(it.nextInt());
            this.addChunk(render);
        }
    }

    private void addChunk(ChunkRenderContainer<T> render) {
        if (render.needsRebuild() && render.canRebuild()) {
            if (render.needsImportantRebuild()) {
                this.importantRebuildQueue.enqueue(render);
            } else {
                this.rebuildQueue.enqueue(render);
            }
        }
        if (this.useFogCulling && render.getSquaredDistanceXZ(this.cameraX, this.cameraZ) >= this.fogRenderCutoff) {
            return;
        }
        if (!render.isEmpty()) {
            this.addChunkToRenderLists(render);
            this.addEntitiesToRenderLists(render);
        }
    }

    private void addChunkToRenderLists(ChunkRenderContainer<T> render) {
        int visibleFaces = this.computeVisibleFaces(render) & render.getFacesWithData();
        if (visibleFaces == 0) {
            return;
        }
        boolean added = false;
        ChunkGraphicsState[] states = render.getGraphicsStates();
        RenderContext<T> context = this.renderContext;
        for (int i = 0; i < states.length; ++i) {
            ChunkGraphicsState state = states[i];
            if (state == null) continue;
            ChunkRenderList list = context.chunkRenderLists[i];
            list.add(state, visibleFaces);
            added = true;
        }
        if (added) {
            if (render.isTickable()) {
                context.tickableChunks.add(render);
            }
            ++this.visibleChunkCount;
        }
    }

    private int computeVisibleFaces(ChunkRenderContainer<T> render) {
        if (!this.useChunkFaceCulling) {
            return ChunkFaceFlags.ALL;
        }
        ChunkRenderBounds bounds = render.getBounds();
        int visibleFaces = ChunkFaceFlags.UNASSIGNED;
        if (this.cameraY > bounds.y1) {
            visibleFaces |= ChunkFaceFlags.UP;
        }
        if (this.cameraY < bounds.y2) {
            visibleFaces |= ChunkFaceFlags.DOWN;
        }
        if (this.cameraX > bounds.x1) {
            visibleFaces |= ChunkFaceFlags.EAST;
        }
        if (this.cameraX < bounds.x2) {
            visibleFaces |= ChunkFaceFlags.WEST;
        }
        if (this.cameraZ > bounds.z1) {
            visibleFaces |= ChunkFaceFlags.SOUTH;
        }
        if (this.cameraZ < bounds.z2) {
            visibleFaces |= ChunkFaceFlags.NORTH;
        }
        return visibleFaces;
    }

    private void addEntitiesToRenderLists(ChunkRenderContainer<T> render) {
        Collection<class_2586> blockEntities = render.getData().getBlockEntities();
        if (!blockEntities.isEmpty()) {
            this.renderContext.visibleBlockEntities.addAll(blockEntities);
        }
    }

    public ChunkRenderContainer<T> getRender(int x, int y, int z) {
        ChunkRenderColumn column = (ChunkRenderColumn)this.columns.get(class_1923.method_8331((int)x, (int)z));
        if (column == null) {
            return null;
        }
        return column.getRender(y);
    }

    private void reset() {
        this.rebuildQueue.clear();
        this.importantRebuildQueue.clear();
        this.renderContext.visibleBlockEntities.clear();
        for (ChunkRenderList list : this.renderContext.chunkRenderLists) {
            list.reset();
        }
        this.renderContext.tickableChunks.clear();
        this.visibleChunkCount = 0;
    }

    public Collection<class_2586> getVisibleBlockEntities() {
        return this.renderContext.visibleBlockEntities;
    }

    @Override
    public void onChunkAdded(int x, int z) {
        this.builder.onChunkStatusChanged(x, z);
        this.loadChunk(x, z);
    }

    @Override
    public void onChunkRemoved(int x, int z) {
        this.builder.onChunkStatusChanged(x, z);
        this.unloadChunk(x, z);
    }

    private void loadChunk(int x, int z) {
        ChunkRenderColumn column = new ChunkRenderColumn(x, z);
        ChunkRenderColumn prev = (ChunkRenderColumn)this.columns.put(class_1923.method_8331((int)x, (int)z), column);
        if (prev != null) {
            this.unloadSections(prev);
        }
        this.connectNeighborColumns(column);
        this.loadSections(column);
        this.dirty = true;
    }

    private void unloadChunk(int x, int z) {
        ChunkRenderColumn column = (ChunkRenderColumn)this.columns.remove(class_1923.method_8331((int)x, (int)z));
        if (column == null) {
            return;
        }
        this.disconnectNeighborColumns(column);
        this.unloadSections(column);
        this.dirty = true;
    }

    private void loadSections(ChunkRenderColumn<T> column) {
        int x = column.getX();
        int z = column.getZ();
        for (int y = 0; y < 16; ++y) {
            ChunkRenderContainer<T> render = this.createChunkRender(column, x, y, z);
            column.setRender(y, render);
            this.culler.onSectionLoaded(x, y, z, render.getId());
        }
    }

    private void unloadSections(ChunkRenderColumn<T> column) {
        int x = column.getX();
        int z = column.getZ();
        for (int y = 0; y < 16; ++y) {
            ChunkRenderContainer<T> render = column.getRender(y);
            if (render != null) {
                render.delete();
                this.renders.remove(render.getId());
            }
            this.culler.onSectionUnloaded(x, y, z);
        }
    }

    private void connectNeighborColumns(ChunkRenderColumn<T> column) {
        for (class_2350 dir : DirectionUtil.ALL_DIRECTIONS) {
            ChunkRenderColumn<T> adj = this.getAdjacentColumn(column, dir);
            if (adj != null) {
                adj.setAdjacentColumn(dir.method_10153(), column);
            }
            column.setAdjacentColumn(dir, adj);
        }
    }

    private void disconnectNeighborColumns(ChunkRenderColumn<T> column) {
        for (class_2350 dir : DirectionUtil.ALL_DIRECTIONS) {
            ChunkRenderColumn adj = column.getAdjacentColumn(dir);
            if (adj != null) {
                adj.setAdjacentColumn(dir.method_10153(), null);
            }
            column.setAdjacentColumn(dir, null);
        }
    }

    private ChunkRenderColumn<T> getAdjacentColumn(ChunkRenderColumn<T> column, class_2350 dir) {
        return this.getColumn(column.getX() + dir.method_10148(), column.getZ() + dir.method_10165());
    }

    private ChunkRenderColumn<T> getColumn(int x, int z) {
        return (ChunkRenderColumn)this.columns.get(class_1923.method_8331((int)x, (int)z));
    }

    private ChunkRenderContainer<T> createChunkRender(ChunkRenderColumn<T> column, int x, int y, int z) {
        ChunkRenderContainer<T> render = new ChunkRenderContainer<T>(this.backend, this.renderer, x, y, z, column);
        if (class_2826.method_18090((class_2826)this.world.method_8497(x, z).method_12006()[y])) {
            render.setData(ChunkRenderData.EMPTY);
        } else {
            render.scheduleRebuild(false);
        }
        render.setId(this.renders.add(render));
        return render;
    }

    public void renderLayer(class_4587 matrixStack, BlockRenderPass pass, double x, double y, double z) {
        ChunkRenderList chunkRenderList = this.renderContext.chunkRenderLists[pass.ordinal()];
        ChunkRenderListIterator iterator = chunkRenderList.iterator(pass.isTranslucent());
        this.backend.begin(matrixStack);
        this.backend.render(iterator, new ChunkCameraContext(x, y, z));
        this.backend.end(matrixStack);
    }

    public void tickVisibleRenders() {
        for (ChunkRenderContainer render : this.renderContext.tickableChunks) {
            render.tick();
        }
    }

    public boolean isChunkVisible(int x, int y, int z) {
        return this.culler.isSectionVisible(x, y, z);
    }

    public void updateChunks() {
        ChunkRenderContainer render;
        ArrayDeque futures = new ArrayDeque();
        int budget = this.builder.getSchedulingBudget();
        int submitted = 0;
        while (!this.importantRebuildQueue.isEmpty()) {
            render = (ChunkRenderContainer)this.importantRebuildQueue.dequeue();
            if (!this.isChunkPrioritized(render)) {
                this.builder.deferRebuild(render);
            } else {
                futures.add(this.builder.scheduleRebuildTaskAsync(render));
            }
            this.dirty = true;
            ++submitted;
        }
        while (submitted < budget && !this.rebuildQueue.isEmpty()) {
            render = (ChunkRenderContainer)this.rebuildQueue.dequeue();
            this.builder.deferRebuild(render);
            ++submitted;
        }
        this.dirty |= submitted > 0;
        this.dirty |= this.builder.performPendingUploads();
        if (!futures.isEmpty()) {
            this.backend.upload(new FutureDequeDrain(futures));
        }
    }

    public void markDirty() {
        this.dirty = true;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void restoreChunks(LongCollection chunks) {
        LongIterator it = chunks.iterator();
        while (it.hasNext()) {
            long pos = it.nextLong();
            this.loadChunk(class_1923.method_8325((long)pos), class_1923.method_8332((long)pos));
        }
    }

    public boolean isBuildComplete() {
        return this.builder.isBuildQueueEmpty();
    }

    public void setCameraPosition(double x, double y, double z) {
        this.builder.setCameraPosition(x, y, z);
    }

    public void destroy() {
        this.reset();
        for (ChunkRenderColumn column : this.columns.values()) {
            this.unloadSections(column);
        }
        this.columns.clear();
        this.builder.stopWorkers();
    }

    public int getTotalSections() {
        return this.columns.size() * 16;
    }

    public void scheduleRebuild(int x, int y, int z, boolean important) {
        if (y < 0 || y >= 16) {
            return;
        }
        ChunkRenderContainer<T> render = this.getRender(x, y, z);
        if (render != null) {
            boolean bl = important = important || this.isChunkPrioritized(render);
            if (render.scheduleRebuild(important) && this.culler.isSectionVisible(x, y, z)) {
                (render.needsImportantRebuild() ? this.importantRebuildQueue : this.rebuildQueue).enqueue(render);
            }
            this.dirty = true;
        }
    }

    public boolean isChunkPrioritized(ChunkRenderContainer<T> render) {
        return render.getSquaredDistance(this.cameraX, this.cameraY, this.cameraZ) <= NEARBY_CHUNK_DISTANCE;
    }

    public int getVisibleChunkCount() {
        return this.visibleChunkCount;
    }

    public void onChunkRenderUpdates(int x, int y, int z, ChunkRenderData data) {
        this.culler.onSectionStateChanged(x, y, z, data.getOcclusionData());
    }

    public static class RenderContext<T1 extends ChunkGraphicsState> {
        public final ObjectArrayFIFOQueue<ChunkRenderContainer<T1>> iterationQueue = new ObjectArrayFIFOQueue();
        public final ChunkRenderList<T1>[] chunkRenderLists = new ChunkRenderList[BlockRenderPass.COUNT];
        public final ObjectList<ChunkRenderContainer<T1>> tickableChunks = new ObjectArrayList();
        public final ObjectList<class_2586> visibleBlockEntities = new ObjectArrayList();

        public RenderContext() {
            for (int i = 0; i < this.chunkRenderLists.length; ++i) {
                this.chunkRenderLists[i] = new ChunkRenderList();
            }
        }
    }
}

