/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.backends.gl30;

import me.jellysquid.mods.sodium.client.gl.array.GlVertexArray;
import me.jellysquid.mods.sodium.client.gl.attribute.GlVertexFormat;
import me.jellysquid.mods.sodium.client.gl.buffer.GlBuffer;
import me.jellysquid.mods.sodium.client.gl.buffer.GlMutableBuffer;
import me.jellysquid.mods.sodium.client.gl.buffer.VertexData;
import me.jellysquid.mods.sodium.client.gl.util.MemoryTracker;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderContainer;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkMeshData;
import me.jellysquid.mods.sodium.client.render.chunk.oneshot.ChunkOneshotGraphicsState;

public class VAOGraphicsState
extends ChunkOneshotGraphicsState {
    private final GlVertexArray vertexArray;
    private final GlBuffer vertexBuffer = new GlMutableBuffer(35044);

    public VAOGraphicsState(MemoryTracker memoryTracker, ChunkRenderContainer<?> container) {
        super(memoryTracker, container);
        this.vertexArray = new GlVertexArray();
    }

    @Override
    public void upload(ChunkMeshData meshData) {
        VertexData vertexData = meshData.takeVertexData();
        this.vertexArray.bind();
        this.vertexBuffer.bind(34962);
        this.memoryTracker.onMemoryFreeAndRelease(this.vertexBuffer.getSize());
        this.vertexBuffer.upload(34962, vertexData);
        this.memoryTracker.onMemoryAllocateAndUse(this.vertexBuffer.getSize());
        GlVertexFormat<?> vertexFormat = vertexData.format;
        vertexFormat.bindVertexAttributes();
        vertexFormat.enableVertexAttributes();
        this.setupModelParts(meshData, vertexFormat);
        this.vertexBuffer.unbind(34962);
        this.vertexArray.unbind();
    }

    @Override
    public void bind() {
        this.vertexArray.bind();
    }

    @Override
    public void delete() {
        this.memoryTracker.onMemoryFreeAndRelease(this.vertexBuffer.getSize());
        this.vertexBuffer.delete();
        this.vertexArray.delete();
    }
}

