/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.backends.gl43;

import it.unimi.dsi.fastutil.objects.ObjectArrayFIFOQueue;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.jellysquid.mods.sodium.client.SodiumClientMod;
import me.jellysquid.mods.sodium.client.gl.arena.GlBufferArena;
import me.jellysquid.mods.sodium.client.gl.arena.GlBufferRegion;
import me.jellysquid.mods.sodium.client.gl.array.GlVertexArray;
import me.jellysquid.mods.sodium.client.gl.buffer.GlBuffer;
import me.jellysquid.mods.sodium.client.gl.buffer.GlMutableBuffer;
import me.jellysquid.mods.sodium.client.gl.buffer.VertexData;
import me.jellysquid.mods.sodium.client.gl.func.GlFunctions;
import me.jellysquid.mods.sodium.client.gl.util.BufferSlice;
import me.jellysquid.mods.sodium.client.gl.util.MemoryTracker;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import me.jellysquid.mods.sodium.client.model.vertex.type.ChunkVertexType;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkCameraContext;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderContainer;
import me.jellysquid.mods.sodium.client.render.chunk.backends.gl43.IndirectCommandBufferVector;
import me.jellysquid.mods.sodium.client.render.chunk.backends.gl43.LCBGraphicsState;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildResult;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkMeshData;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkRenderData;
import me.jellysquid.mods.sodium.client.render.chunk.lists.ChunkRenderListIterator;
import me.jellysquid.mods.sodium.client.render.chunk.multidraw.ChunkDrawCallBatcher;
import me.jellysquid.mods.sodium.client.render.chunk.multidraw.ChunkDrawParamsVector;
import me.jellysquid.mods.sodium.client.render.chunk.multidraw.ChunkProgramMultiDraw;
import me.jellysquid.mods.sodium.client.render.chunk.multidraw.ChunkRenderBackendMultiDraw;
import me.jellysquid.mods.sodium.client.render.chunk.passes.BlockRenderPass;
import me.jellysquid.mods.sodium.client.render.chunk.region.ChunkRegion;
import me.jellysquid.mods.sodium.client.render.chunk.region.ChunkRegionManager;
import net.minecraft.class_156;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;

public class GL43ChunkRenderBackend
extends ChunkRenderBackendMultiDraw<LCBGraphicsState> {
    private final ChunkRegionManager<LCBGraphicsState> bufferManager;
    private final ObjectArrayList<ChunkRegion<LCBGraphicsState>> pendingBatches = new ObjectArrayList();
    private final ObjectArrayFIFOQueue<ChunkRegion<LCBGraphicsState>> pendingUploads = new ObjectArrayFIFOQueue();
    private final GlMutableBuffer uploadBuffer;
    private final GlMutableBuffer uniformBuffer;
    private final GlMutableBuffer commandBuffer;
    private final ChunkDrawParamsVector uniformBufferBuilder;
    private final IndirectCommandBufferVector commandBufferBuilder;
    private final MemoryTracker memoryTracker = new MemoryTracker();

    public GL43ChunkRenderBackend(ChunkVertexType vertexType) {
        super(vertexType);
        this.bufferManager = new ChunkRegionManager(this.memoryTracker);
        this.uploadBuffer = new GlMutableBuffer(35042);
        this.uniformBuffer = new GlMutableBuffer(35044);
        this.commandBuffer = new GlMutableBuffer(35044);
        this.uniformBufferBuilder = ChunkDrawParamsVector.create(2048);
        this.commandBufferBuilder = IndirectCommandBufferVector.create(2048);
    }

    @Override
    public void upload(Iterator<ChunkBuildResult<LCBGraphicsState>> queue) {
        this.setupUploadBatches(queue);
        GlMutableBuffer uploadBuffer = this.uploadBuffer;
        uploadBuffer.bind(34962);
        while (!this.pendingUploads.isEmpty()) {
            ChunkRegion region = (ChunkRegion)this.pendingUploads.dequeue();
            GlBufferArena arena = region.getBufferArena();
            arena.bind();
            ObjectArrayList uploadQueue = region.getUploadQueue();
            arena.ensureCapacity(GL43ChunkRenderBackend.getUploadQueuePayloadSize(uploadQueue));
            for (ChunkBuildResult result : uploadQueue) {
                ChunkRenderContainer<LCBGraphicsState> render = result.render;
                ChunkRenderData data = result.data;
                for (BlockRenderPass pass : BlockRenderPass.VALUES) {
                    ChunkMeshData meshData;
                    LCBGraphicsState graphics = (LCBGraphicsState)render.getGraphicsState(pass);
                    if (graphics != null) {
                        graphics.delete();
                    }
                    if ((meshData = data.getMesh(pass)).hasVertexData()) {
                        VertexData upload = meshData.takeVertexData();
                        uploadBuffer.upload(34962, upload);
                        GlBufferRegion segment = arena.upload(34962, 0, upload.buffer.capacity());
                        render.setGraphicsState(pass, new LCBGraphicsState(render, region, segment, meshData, this.vertexFormat));
                        continue;
                    }
                    render.setGraphicsState(pass, null);
                }
                render.setData(data);
            }
            arena.unbind();
            uploadQueue.clear();
        }
        uploadBuffer.invalidate(34962);
        uploadBuffer.unbind(34962);
    }

    @Override
    public void render(ChunkRenderListIterator<LCBGraphicsState> renders, ChunkCameraContext camera) {
        this.bufferManager.cleanup();
        this.setupDrawBatches(renders, camera);
        this.setupCommandBuffers();
        GlVertexArray prevVao = null;
        int commandStart = 0;
        for (ChunkRegion region : this.pendingBatches) {
            GlVertexArray vao = region.getVertexArray();
            vao.bind();
            if (region.isDirty()) {
                this.setupArrayBufferState(region.getBufferArena());
                this.setupUniformBufferState();
                region.markClean();
            }
            ChunkDrawCallBatcher batch = region.getDrawBatcher();
            GlFunctions.INDIRECT_DRAW.glMultiDrawArraysIndirect(7, commandStart, batch.getCount(), 0);
            prevVao = vao;
            commandStart += batch.getArrayLength();
        }
        this.pendingBatches.clear();
        if (prevVao != null) {
            prevVao.unbind();
        }
        this.uniformBuffer.unbind(34962);
        this.commandBuffer.unbind(36671);
    }

    private void setupCommandBuffers() {
        this.commandBufferBuilder.begin();
        for (ChunkRegion region : this.pendingBatches) {
            ChunkDrawCallBatcher batcher = region.getDrawBatcher();
            batcher.end();
            this.commandBufferBuilder.pushCommandBuffer(batcher);
        }
        this.commandBufferBuilder.end();
        this.commandBuffer.bind(36671);
        this.commandBuffer.upload(36671, this.commandBufferBuilder.getBuffer());
    }

    private void setupArrayBufferState(GlBufferArena arena) {
        GlBuffer vbo = arena.getBuffer();
        vbo.bind(34962);
        this.vertexFormat.bindVertexAttributes();
        this.vertexFormat.enableVertexAttributes();
    }

    private void setupUniformBufferState() {
        this.uniformBuffer.bind(34962);
        int index = ((ChunkProgramMultiDraw)this.activeProgram).getModelOffsetAttributeLocation();
        GL20.glVertexAttribPointer((int)index, (int)4, (int)5126, (boolean)false, (int)0, (long)0L);
        GlFunctions.INSTANCED_ARRAY.glVertexAttribDivisor(index, 1);
        GL20.glEnableVertexAttribArray((int)index);
    }

    private void setupUploadBatches(Iterator<ChunkBuildResult<LCBGraphicsState>> renders) {
        while (renders.hasNext()) {
            ObjectArrayList<ChunkBuildResult<LCBGraphicsState>> uploadQueue;
            ChunkBuildResult<LCBGraphicsState> result = renders.next();
            ChunkRenderContainer render = result.render;
            ChunkRegion<LCBGraphicsState> region = this.bufferManager.getRegion(render.getChunkX(), render.getChunkY(), render.getChunkZ());
            if (region == null) {
                if (result.data.getMeshSize() <= 0) {
                    render.setData(result.data);
                    continue;
                }
                region = this.bufferManager.getOrCreateRegion(render.getChunkX(), render.getChunkY(), render.getChunkZ());
            }
            if ((uploadQueue = region.getUploadQueue()).isEmpty()) {
                this.pendingUploads.enqueue(region);
            }
            uploadQueue.add(result);
        }
    }

    private void setupDrawBatches(ChunkRenderListIterator<LCBGraphicsState> it, ChunkCameraContext camera) {
        this.uniformBufferBuilder.reset();
        int drawCount = 0;
        while (it.hasNext()) {
            LCBGraphicsState state = it.getGraphicsState();
            int visible = it.getVisibleFaces();
            int index = drawCount++;
            float x = camera.getChunkModelOffset(state.getX(), camera.blockOriginX, camera.originX);
            float y = camera.getChunkModelOffset(state.getY(), camera.blockOriginY, camera.originY);
            float z = camera.getChunkModelOffset(state.getZ(), camera.blockOriginZ, camera.originZ);
            this.uniformBufferBuilder.pushChunkDrawParams(x, y, z);
            ChunkRegion<LCBGraphicsState> region = state.getRegion();
            ChunkDrawCallBatcher batch = region.getDrawBatcher();
            if (!batch.isBuilding()) {
                batch.begin();
                this.pendingBatches.add(region);
            }
            int mask = 1;
            for (int i = 0; i < ModelQuadFacing.COUNT; ++i) {
                if ((visible & mask) != 0) {
                    long part = state.getModelPart(i);
                    batch.addIndirectDrawCall(BufferSlice.unpackStart(part), BufferSlice.unpackLength(part), index, 1);
                }
                mask <<= 1;
            }
            it.advance();
        }
        this.uniformBuffer.bind(34962);
        this.uniformBuffer.upload(34962, this.uniformBufferBuilder.getBuffer());
    }

    private static int getUploadQueuePayloadSize(List<ChunkBuildResult<LCBGraphicsState>> queue) {
        int size = 0;
        for (ChunkBuildResult<LCBGraphicsState> result : queue) {
            size += result.data.getMeshSize();
        }
        return size;
    }

    @Override
    public void delete() {
        super.delete();
        this.bufferManager.delete();
        this.uploadBuffer.delete();
        this.uniformBuffer.delete();
        this.commandBuffer.delete();
        this.uniformBufferBuilder.delete();
        this.commandBufferBuilder.delete();
    }

    @Override
    public Class<LCBGraphicsState> getGraphicsStateType() {
        return LCBGraphicsState.class;
    }

    public static boolean isSupported(boolean disableBlacklist) {
        if (!disableBlacklist) {
            try {
                if (GL43ChunkRenderBackend.isOldIntelGpu()) {
                    return false;
                }
            }
            catch (Exception e) {
                SodiumClientMod.logger().warn("An unexpected exception was thrown while trying to parse the current OpenGL renderer's strings", (Throwable)e);
            }
        }
        return GlFunctions.isVertexArraySupported() && GlFunctions.isBufferCopySupported() && GlFunctions.isIndirectMultiDrawSupported() && GlFunctions.isInstancedArraySupported();
    }

    private static boolean isOldIntelGpu() {
        if (class_156.method_668() != class_156.class_158.field_1133) {
            return false;
        }
        String renderer = Objects.requireNonNull(GL11.glGetString((int)7937));
        String version = Objects.requireNonNull(GL11.glGetString((int)7938));
        if (!renderer.matches("^Intel\\(R\\) (U?HD|Iris( Pro)?) Graphics (\\d+)?$")) {
            return false;
        }
        Matcher matcher = Pattern.compile("(\\d.\\d.\\d) - Build (\\d+).(\\d+).(\\d+).(\\d+)").matcher(version);
        if (!matcher.matches()) {
            return false;
        }
        String majorBuildString = matcher.group(4);
        int majorBuildNumber = Integer.parseInt(majorBuildString);
        return majorBuildNumber < 100;
    }

    @Override
    public String getRendererName() {
        return "Multidraw (GL 4.3)";
    }

    @Override
    public List<String> getDebugStrings() {
        long allocated = this.memoryTracker.getAllocatedMemory();
        long used = this.memoryTracker.getUsedMemory();
        int ratio = (int)Math.floor((double)used / (double)allocated * 100.0);
        ArrayList<String> list = new ArrayList<String>();
        list.add(String.format("VRAM Pool: %d/%d MB (%d%%)", MemoryTracker.toMiB(used), MemoryTracker.toMiB(allocated), ratio));
        list.add(String.format("Allocated Buffers: %s", this.bufferManager.getAllocatedRegionCount()));
        return list;
    }
}

