/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.tasks;

import me.jellysquid.mods.sodium.client.render.chunk.ChunkGraphicsState;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderContainer;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildBuffers;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildResult;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuilder;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkMeshData;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkRenderBounds;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkRenderData;
import me.jellysquid.mods.sodium.client.render.chunk.passes.BlockRenderPass;
import me.jellysquid.mods.sodium.client.render.chunk.tasks.ChunkRenderBuildTask;
import me.jellysquid.mods.sodium.client.render.pipeline.context.ChunkRenderContext;
import me.jellysquid.mods.sodium.client.util.task.CancellationSource;
import me.jellysquid.mods.sodium.client.world.WorldSlice;
import net.minecraft.class_1161;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_3610;
import net.minecraft.class_4696;
import net.minecraft.class_824;
import net.minecraft.class_827;
import net.minecraft.class_852;

public class ChunkRenderRebuildTask<T extends ChunkGraphicsState>
extends ChunkRenderBuildTask<T> {
    private final ChunkRenderContainer<T> render;
    private final ChunkBuilder<T> chunkBuilder;
    private final class_1161 camera;
    private final WorldSlice slice;
    private final class_2338 offset;

    public ChunkRenderRebuildTask(ChunkBuilder<T> chunkBuilder, ChunkRenderContainer<T> render, WorldSlice slice, class_2338 offset) {
        this.chunkBuilder = chunkBuilder;
        this.render = render;
        this.camera = chunkBuilder.getCameraPosition();
        this.slice = slice;
        this.offset = offset;
    }

    @Override
    public ChunkBuildResult<T> performBuild(ChunkRenderContext pipeline, ChunkBuildBuffers buffers, CancellationSource cancellationSource) {
        ChunkRenderData.Builder renderData = new ChunkRenderData.Builder();
        class_852 occluder = new class_852();
        ChunkRenderBounds.Builder bounds = new ChunkRenderBounds.Builder();
        buffers.init();
        pipeline.init(this.slice, this.slice.getOrigin());
        int baseX = this.render.getOriginX();
        int baseY = this.render.getOriginY();
        int baseZ = this.render.getOriginZ();
        class_2338.class_2339 pos = new class_2338.class_2339();
        class_2338 offset = this.offset;
        for (int relY = 0; relY < 16; ++relY) {
            if (cancellationSource.isCancelled()) {
                return null;
            }
            for (int relZ = 0; relZ < 16; ++relZ) {
                for (int relX = 0; relX < 16; ++relX) {
                    class_827 renderer;
                    class_2586 entity;
                    class_3610 fluidState;
                    class_2680 blockState = this.slice.getOriginBlockState(relX, relY, relZ);
                    if (blockState.method_26215()) continue;
                    class_2248 block = blockState.method_26204();
                    int x = baseX + relX;
                    int y = baseY + relY;
                    int z = baseZ + relZ;
                    if (block.method_9604(blockState) == class_2464.field_11458) {
                        buffers.setRenderOffset(x - offset.method_10263(), y - offset.method_10264(), z - offset.method_10260());
                        class_1921 layer = class_4696.method_23679((class_2680)blockState);
                        if (pipeline.renderBlock(this.slice, blockState, (class_2338)pos.method_10103(x, y, z), buffers.get(layer), true)) {
                            bounds.addBlock(relX, relY, relZ);
                        }
                    }
                    if (!(fluidState = block.method_9545(blockState)).method_15769()) {
                        buffers.setRenderOffset(x - offset.method_10263(), y - offset.method_10264(), z - offset.method_10260());
                        class_1921 layer = class_4696.method_23680((class_3610)fluidState);
                        if (pipeline.renderFluid(this.slice, fluidState, pos.method_10103(x, y, z), buffers.get(layer))) {
                            bounds.addBlock(relX, relY, relZ);
                        }
                    }
                    if (block.method_26161() && (entity = this.slice.getBlockEntity((class_2338)pos.method_10103(x, y, z), class_2818.class_2819.field_12859)) != null && (renderer = class_824.field_4346.method_3550(entity)) != null) {
                        renderData.addBlockEntity(entity, !renderer.method_3563(entity));
                        bounds.addBlock(relX, relY, relZ);
                    }
                    if (!blockState.method_26216((class_1922)this.slice, (class_2338)pos)) continue;
                    occluder.method_3682((class_2338)pos);
                }
            }
        }
        for (BlockRenderPass pass : BlockRenderPass.VALUES) {
            ChunkMeshData mesh = buffers.createMesh(pass);
            if (mesh == null) continue;
            renderData.setMesh(pass, mesh);
        }
        renderData.setOcclusionData(occluder.method_3679());
        renderData.setBounds(bounds.build(this.render.getChunkPos()));
        return new ChunkBuildResult<T>(this.render, renderData.build());
    }

    @Override
    public void releaseResources() {
        this.chunkBuilder.releaseWorldSlice(this.slice);
    }
}

