/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.util;

import java.nio.ByteBuffer;
import me.jellysquid.mods.sodium.client.util.UnsafeUtil;
import org.lwjgl.system.MemoryUtil;

public class BufferUtil {
    public static void copyIntArray(int[] data, int limit, int offset, ByteBuffer buffer) {
        if (limit > data.length) {
            throw new IllegalArgumentException("Source array is too small");
        }
        int bytes = limit * 4;
        if (buffer.capacity() - offset < bytes) {
            throw new IllegalArgumentException("Destination buffer is too small");
        }
        if (UnsafeUtil.isAvailable() && buffer.isDirect()) {
            BufferUtil.copyIntArrayUnsafe(data, limit, offset, MemoryUtil.memAddress((ByteBuffer)buffer));
        } else {
            BufferUtil.copyIntArrayDefault(data, limit, offset, buffer);
        }
    }

    private static void copyIntArrayUnsafe(int[] data, int limit, int offset, long addr) {
        UnsafeUtil.instance().copyMemory(data, UnsafeUtil.INT_ARRAY_OFFSET, null, addr + (long)offset, limit * 4);
    }

    private static void copyIntArrayDefault(int[] data, int limit, int offset, ByteBuffer buffer) {
        for (int i = 0; i < limit; ++i) {
            buffer.putInt(offset + i * 4, data[i]);
        }
    }
}

