/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common;

import com.mojang.brigadier.CommandDispatcher;
import java.util.Map;
import java.util.Set;
import nerdhub.cardinal.components.api.component.Component;
import nerdhub.cardinal.components.api.event.EntityComponentCallback;
import nerdhub.cardinal.components.api.util.EntityComponents;
import nerdhub.cardinal.components.api.util.RespawnCopyStrategy;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v1.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2314;
import net.minecraft.class_2316;
import net.minecraft.class_2319;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosComponent;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;
import top.theillusivec4.curios.common.CuriosHelper;
import top.theillusivec4.curios.common.CuriosNetwork;
import top.theillusivec4.curios.common.CuriosRegistry;
import top.theillusivec4.curios.common.PlayerCuriosComponent;
import top.theillusivec4.curios.common.slottype.SlotTypeManager;
import top.theillusivec4.curios.server.CurioArgumentType;
import top.theillusivec4.curios.server.CuriosCommand;
import top.theillusivec4.curios.server.CuriosConfig;
import top.theillusivec4.curios.server.SlotHelper;

public class CuriosCommon
implements ModInitializer {
    public static final String MODID = "curios";
    public static final Logger LOGGER = LogManager.getLogger();
    private static final boolean DEBUG = false;
    public static boolean isOriginsLoaded = false;

    public void onInitialize() {
        isOriginsLoaded = FabricLoader.getInstance().isModLoaded("origins");
        CuriosApi.setCuriosHelper(new CuriosHelper());
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            CuriosApi.setSlotHelper(new SlotHelper());
            SlotTypeManager.buildQueuedSlotTypes();
            CuriosConfig.init();
            SlotTypeManager.buildConfigSlotTypes();
            SlotTypeManager.buildSlotTypes();
        });
        ServerLifecycleEvents.SERVER_STOPPED.register(server -> CuriosApi.setSlotHelper(null));
        UseItemCallback.EVENT.register((player, world, hand) -> {
            class_1799 stack = player.method_5998(hand);
            return CuriosApi.getCuriosHelper().getCurio(stack).map(curio -> {
                if (curio.canRightClickEquip()) {
                    return CuriosApi.getCuriosHelper().getCuriosHandler((class_1309)player).map(handler -> {
                        if (!player.field_6002.method_8608()) {
                            Map<String, ICurioStacksHandler> curios = handler.getCurios();
                            for (Map.Entry<String, ICurioStacksHandler> entry : curios.entrySet()) {
                                IDynamicStackHandler stackHandler = entry.getValue().getStacks();
                                for (int i = 0; i < stackHandler.method_5439(); ++i) {
                                    class_1799 present = stackHandler.method_5438(i);
                                    Set<String> tags = CuriosApi.getCuriosHelper().getCurioTags(stack.method_7909());
                                    String id = entry.getKey();
                                    if (!present.method_7960() || !tags.contains(id) && !tags.contains("curio") || !curio.canEquip(id, (class_1309)player)) continue;
                                    stackHandler.method_5447(i, stack.method_7972());
                                    curio.playRightClickEquipSound((class_1309)player);
                                    if (!player.method_7337()) {
                                        int count = stack.method_7947();
                                        stack.method_7934(count);
                                    }
                                    return class_1271.method_22427((Object)stack);
                                }
                            }
                        }
                        return class_1271.method_22427((Object)stack);
                    }).orElse(class_1271.method_22430((Object)stack));
                }
                return class_1271.method_22430((Object)stack);
            }).orElse(class_1271.method_22430((Object)stack));
        });
        EntityComponentCallback.event(class_1657.class).register((playerEntity, componentContainer) -> componentContainer.put(CuriosComponent.INVENTORY, (Component)new PlayerCuriosComponent((class_1657)playerEntity)));
        EntityComponents.setRespawnCopyStrategy(CuriosComponent.INVENTORY, (RespawnCopyStrategy)RespawnCopyStrategy.ALWAYS_COPY);
        CuriosRegistry.registerItems();
        CuriosRegistry.registerComponents();
        CuriosNetwork.registerPackets();
        CommandRegistrationCallback.EVENT.register((commandDispatcher, b) -> CuriosCommand.register((CommandDispatcher<class_2168>)commandDispatcher));
        class_2316.method_10017((String)"curios:slot_type", CurioArgumentType.class, (class_2314)new class_2319(CurioArgumentType::slot));
    }
}

