/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import net.minecraft.class_3494;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.logging.log4j.util.TriConsumer;
import top.theillusivec4.curios.api.CuriosComponent;
import top.theillusivec4.curios.api.type.component.ICurio;
import top.theillusivec4.curios.api.type.component.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.component.IRenderableCurio;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;
import top.theillusivec4.curios.api.type.util.ICuriosHelper;

public class CuriosHelper
implements ICuriosHelper {
    private static TriConsumer<String, Integer, class_1309> brokenCurioConsumer;

    @Override
    public Optional<ICurio> getCurio(class_1799 stack) {
        return CuriosComponent.ITEM.maybeGet((Object)stack);
    }

    @Override
    public Optional<IRenderableCurio> getRenderableCurio(class_1799 stack) {
        return CuriosComponent.ITEM_RENDER.maybeGet((Object)stack);
    }

    @Override
    public Optional<ICuriosItemHandler> getCuriosHandler(class_1309 livingEntity) {
        return CuriosComponent.INVENTORY.maybeGet((Object)livingEntity);
    }

    @Override
    public Set<String> getCurioTags(class_1792 item) {
        ArrayList list = Lists.newArrayList();
        for (Map.Entry identifierTagEntry : class_3489.method_15106().method_30204().entrySet()) {
            if (!((class_3494)identifierTagEntry.getValue()).method_15141((Object)item)) continue;
            list.add(identifierTagEntry.getKey());
        }
        return list.stream().filter(tag -> tag.method_12836().equals("curios")).map(class_2960::method_12832).collect(Collectors.toSet());
    }

    @Override
    public Optional<ImmutableTriple<String, Integer, class_1799>> findEquippedCurio(class_1792 item, class_1309 livingEntity) {
        return this.findEquippedCurio((class_1799 stack) -> stack.method_7909() == item, livingEntity);
    }

    @Override
    public Optional<ImmutableTriple<String, Integer, class_1799>> findEquippedCurio(Predicate<class_1799> filter, class_1309 livingEntity) {
        ImmutableTriple result = this.getCuriosHandler(livingEntity).map(handler -> {
            Map<String, ICurioStacksHandler> curios = handler.getCurios();
            for (String id : curios.keySet()) {
                ICurioStacksHandler stacksHandler = curios.get(id);
                IDynamicStackHandler stackHandler = stacksHandler.getStacks();
                for (int i = 0; i < stackHandler.method_5439(); ++i) {
                    class_1799 stack = stackHandler.method_5438(i);
                    if (stack.method_7960() || !filter.test(stack)) continue;
                    return new ImmutableTriple((Object)id, (Object)i, (Object)stack);
                }
            }
            return new ImmutableTriple((Object)"", (Object)0, (Object)class_1799.field_8037);
        }).orElse(new ImmutableTriple((Object)"", (Object)0, (Object)class_1799.field_8037));
        return ((String)result.getLeft()).isEmpty() ? Optional.empty() : Optional.of(result);
    }

    @Override
    public Multimap<class_1320, class_1322> getAttributeModifiers(String identifier, class_1799 stack) {
        if (stack.method_7969() != null && stack.method_7969().method_10573("CurioAttributeModifiers", 9)) {
            HashMultimap multimap = HashMultimap.create();
            class_2499 listnbt = stack.method_7969().method_10554("CurioAttributeModifiers", 10);
            for (int i = 0; i < listnbt.size(); ++i) {
                class_1322 attributemodifier;
                class_1320 attribute;
                class_2487 compoundnbt = listnbt.method_10602(i);
                if (compoundnbt.method_10573("Slot", 8) && !compoundnbt.method_10558("Slot").equals(identifier) || (attribute = (class_1320)class_2378.field_23781.method_10223(class_2960.method_12829((String)compoundnbt.method_10558("AttributeName")))) == null || (attributemodifier = class_1322.method_26859((class_2487)compoundnbt)) == null || attributemodifier.method_6189().getLeastSignificantBits() == 0L || attributemodifier.method_6189().getMostSignificantBits() == 0L) continue;
                multimap.put((Object)attribute, (Object)attributemodifier);
            }
            return multimap;
        }
        return this.getCurio(stack).map(curio -> curio.getAttributeModifiers(identifier)).orElse((Multimap)HashMultimap.create());
    }

    @Override
    public void onBrokenCurio(String id, int index, class_1309 damager) {
        brokenCurioConsumer.accept((Object)id, (Object)index, (Object)damager);
    }

    @Override
    public void setBrokenCurioConsumer(TriConsumer<String, Integer, class_1309> consumer) {
        if (brokenCurioConsumer == null) {
            brokenCurioConsumer = consumer;
        }
    }
}

