/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosComponent;
import top.theillusivec4.curios.api.type.ISlotType;
import top.theillusivec4.curios.api.type.component.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;
import top.theillusivec4.curios.common.inventory.CurioStacksHandler;

public class PlayerCuriosComponent
implements ICuriosItemHandler {
    Map<String, ICurioStacksHandler> curios = new LinkedHashMap<String, ICurioStacksHandler>();
    Set<String> locked = new HashSet<String>();
    class_2371<class_1799> invalidStacks = class_2371.method_10211();
    class_1657 wearer;

    public PlayerCuriosComponent(class_1657 playerEntity) {
        this.wearer = playerEntity;
        this.reset();
    }

    @Override
    public Map<String, ICurioStacksHandler> getCurios() {
        return Collections.unmodifiableMap(this.curios);
    }

    @Override
    public void setCurios(Map<String, ICurioStacksHandler> map) {
        this.curios = map;
    }

    @Override
    public int getSlots() {
        int totalSlots = 0;
        for (ICurioStacksHandler stacks : this.curios.values()) {
            totalSlots += stacks.getSlots();
        }
        return totalSlots;
    }

    @Override
    public int getVisibleSlots() {
        int totalSlots = 0;
        for (ICurioStacksHandler stacks : this.curios.values()) {
            if (!stacks.isVisible()) continue;
            totalSlots += stacks.getSlots();
        }
        return totalSlots;
    }

    @Override
    public Set<String> getLockedSlots() {
        return Collections.unmodifiableSet(this.locked);
    }

    @Override
    public void reset() {
        if (!this.wearer.method_5770().method_8608() && this.wearer instanceof class_3222) {
            this.locked.clear();
            this.curios.clear();
            this.invalidStacks.clear();
            CuriosApi.getSlotHelper().createSlots().forEach((slotType, stacksHandler) -> this.curios.put(slotType.getIdentifier(), (ICurioStacksHandler)stacksHandler));
        }
    }

    @Override
    public Optional<ICurioStacksHandler> getStacksHandler(String identifier) {
        return Optional.ofNullable(this.curios.get(identifier));
    }

    @Override
    public void unlockSlotType(String identifier, int amount, boolean visible, boolean cosmetic) {
        this.curios.putIfAbsent(identifier, new CurioStacksHandler(amount, 0, visible, cosmetic));
        this.locked.remove(identifier);
    }

    @Override
    public void lockSlotType(String identifier) {
        this.getStacksHandler(identifier).ifPresent(stackHandler -> {
            this.curios.remove(identifier);
            this.locked.add(identifier);
            this.loseStacks(stackHandler.getStacks(), identifier, stackHandler.getSlots());
        });
    }

    @Override
    public void growSlotType(String identifier, int amount) {
        if (amount > 0) {
            this.getStacksHandler(identifier).ifPresent(stackHandler -> stackHandler.grow(amount));
        }
    }

    @Override
    public void shrinkSlotType(String identifier, int amount) {
        if (amount > 0) {
            this.getStacksHandler(identifier).ifPresent(stackHandler -> {
                int toShrink = Math.min(stackHandler.getSlots() - 1, amount);
                this.loseStacks(stackHandler.getStacks(), identifier, toShrink);
                stackHandler.shrink(amount);
            });
        }
    }

    @Override
    public class_1309 getWearer() {
        return this.wearer;
    }

    @Override
    public void loseInvalidStack(class_1799 stack) {
        this.invalidStacks.add((Object)stack);
    }

    @Override
    public void handleInvalidStacks() {
        if (this.wearer != null && !this.invalidStacks.isEmpty()) {
            this.invalidStacks.forEach(drop -> PlayerCuriosComponent.giveItemToPlayer(this.wearer, drop));
            this.invalidStacks = class_2371.method_10211();
        }
    }

    @Override
    public void sync() {
        CuriosComponent.INVENTORY.sync((Object)this.getWearer());
    }

    private void loseStacks(IDynamicStackHandler stackHandler, String identifier, int amount) {
        if (this.wearer != null && !this.wearer.method_5770().method_8608()) {
            ArrayList<class_1799> drops = new ArrayList<class_1799>();
            for (int i = stackHandler.method_5439() - amount; i < stackHandler.method_5439(); ++i) {
                class_1799 stack = stackHandler.method_5438(i);
                drops.add(stackHandler.method_5438(i));
                if (!stack.method_7960()) {
                    this.wearer.method_6127().method_26847(CuriosApi.getCuriosHelper().getAttributeModifiers(identifier, stack));
                    int index = i;
                    CuriosApi.getCuriosHelper().getCurio(stack).ifPresent(curio -> curio.onUnequip(identifier, index, (class_1309)this.wearer));
                }
                stackHandler.method_5447(i, class_1799.field_8037);
            }
            drops.forEach(drop -> PlayerCuriosComponent.giveItemToPlayer(this.wearer, drop));
        }
    }

    private static void giveItemToPlayer(class_1657 playerEntity, class_1799 stack) {
        boolean bl = playerEntity.field_7514.method_7394(stack);
        if (bl && stack.method_7960()) {
            stack.method_7939(1);
            class_1542 itemEntity = playerEntity.method_7328(stack, false);
            if (itemEntity != null) {
                itemEntity.method_6987();
            }
            playerEntity.field_6002.method_8465(null, playerEntity.method_23317(), playerEntity.method_23318(), playerEntity.method_23321(), class_3417.field_15197, class_3419.field_15248, 0.2f, ((playerEntity.method_6051().nextFloat() - playerEntity.method_6051().nextFloat()) * 0.7f + 1.0f) * 2.0f);
            playerEntity.field_7498.method_7623();
        } else {
            class_1542 itemEntity = playerEntity.method_7328(stack, false);
            if (itemEntity != null) {
                itemEntity.method_6975();
                itemEntity.method_6984(playerEntity.method_5667());
            }
        }
    }

    public void writeSyncPacket(class_2540 buf, class_3222 recipient) {
        buf.writeInt(this.curios.size());
        for (Map.Entry<String, ICurioStacksHandler> entry : this.curios.entrySet()) {
            buf.method_10814(entry.getKey());
            buf.method_10794(entry.getValue().serializeTag());
        }
    }

    public void applySyncPacket(class_2540 buf) {
        int entrySize = buf.readInt();
        LinkedHashMap<String, ICurioStacksHandler> map = new LinkedHashMap<String, ICurioStacksHandler>();
        for (int i = 0; i < entrySize; ++i) {
            String key = buf.method_10800(25);
            CurioStacksHandler stacksHandler = new CurioStacksHandler();
            class_2487 compound = buf.method_10798();
            if (compound != null) {
                stacksHandler.deserializeTag(compound);
            }
            map.put(key, stacksHandler);
        }
        this.setCurios(map);
    }

    public void readFromNbt(class_2487 compoundTag) {
        class_2499 tagList = compoundTag.method_10554("Curios", 10);
        class_2499 lockedList = compoundTag.method_10554("Locked", 8);
        if (!tagList.isEmpty()) {
            LinkedHashMap<String, ICurioStacksHandler> curios = new LinkedHashMap<String, ICurioStacksHandler>();
            SortedMap<ISlotType, ICurioStacksHandler> sortedCurios = CuriosApi.getSlotHelper().createSlots();
            for (int i = 0; i < tagList.size(); ++i) {
                class_2487 tag = tagList.method_10602(i);
                String identifier = tag.method_10558("Identifier");
                CurioStacksHandler prevStacksHandler = new CurioStacksHandler();
                prevStacksHandler.deserializeTag(tag.method_10562("StacksHandler"));
                Optional<ISlotType> optionalType = CuriosApi.getSlotHelper().getSlotType(identifier);
                optionalType.ifPresent(type -> {
                    int index;
                    CurioStacksHandler newStacksHandler = new CurioStacksHandler(type.getSize(), prevStacksHandler.getSizeShift(), type.isVisible(), type.hasCosmetic());
                    for (index = 0; index < newStacksHandler.getSlots() && index < prevStacksHandler.getSlots(); ++index) {
                        newStacksHandler.getStacks().method_5447(index, prevStacksHandler.getStacks().method_5438(index));
                        newStacksHandler.getCosmeticStacks().method_5447(index, prevStacksHandler.getCosmeticStacks().method_5438(index));
                    }
                    while (index < prevStacksHandler.getSlots()) {
                        this.loseInvalidStack(prevStacksHandler.getStacks().method_5438(index));
                        this.loseInvalidStack(prevStacksHandler.getCosmeticStacks().method_5438(index));
                        ++index;
                    }
                    sortedCurios.put((ISlotType)type, newStacksHandler);
                    for (int j = 0; j < newStacksHandler.getRenders().size() && j < prevStacksHandler.getRenders().size(); ++j) {
                        newStacksHandler.getRenders().set(j, prevStacksHandler.getRenders().get(j));
                    }
                });
                if (optionalType.isPresent()) continue;
                IDynamicStackHandler stackHandler = prevStacksHandler.getStacks();
                IDynamicStackHandler cosmeticStackHandler = prevStacksHandler.getCosmeticStacks();
                for (int j = 0; j < stackHandler.method_5439(); ++j) {
                    class_1799 cosmeticStack;
                    class_1799 stack = stackHandler.method_5438(j);
                    if (!stack.method_7960()) {
                        this.loseInvalidStack(stack);
                    }
                    if ((cosmeticStack = cosmeticStackHandler.method_5438(j)).method_7960()) continue;
                    this.loseInvalidStack(cosmeticStack);
                }
            }
            sortedCurios.forEach((slotType, stacksHandler) -> curios.put(slotType.getIdentifier(), (ICurioStacksHandler)stacksHandler));
            this.setCurios(curios);
            for (int k = 0; k < lockedList.size(); ++k) {
                this.lockSlotType(lockedList.method_10608(k));
            }
        }
    }

    public void writeToNbt(class_2487 compoundTag) {
        class_2499 taglist = new class_2499();
        this.getCurios().forEach((key, stacksHandler) -> {
            class_2487 tag = new class_2487();
            tag.method_10566("StacksHandler", (class_2520)stacksHandler.serializeTag());
            tag.method_10582("Identifier", key);
            taglist.add((Object)tag);
        });
        compoundTag.method_10566("Curios", (class_2520)taglist);
        class_2499 taglist1 = new class_2499();
        for (String identifier : this.getLockedSlots()) {
            taglist1.add((Object)class_2519.method_23256((String)identifier));
        }
        compoundTag.method_10566("Locked", (class_2520)taglist1);
    }
}

