/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.inventory;

import net.minecraft.class_1277;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;
import top.theillusivec4.curios.mixin.ISimpleInventoryAccessor;

public class DynamicStackHandler
extends class_1277
implements IDynamicStackHandler {
    protected class_2371<class_1799> previousStacks;

    public DynamicStackHandler(int size) {
        super(size);
        this.previousStacks = class_2371.method_10213((int)size, (Object)class_1799.field_8037);
    }

    @Override
    public void setPreviousStack(int slot, class_1799 stack) {
        this.previousStacks.set(slot, (Object)stack);
    }

    @Override
    public class_1799 getPreviousStack(int slot) {
        return (class_1799)this.previousStacks.get(slot);
    }

    @Override
    public void grow(int amount) {
        ((ISimpleInventoryAccessor)((Object)this)).setStacks(DynamicStackHandler.getResizedList(this.method_5439() + amount, ((ISimpleInventoryAccessor)((Object)this)).getStacks()));
        this.previousStacks = DynamicStackHandler.getResizedList(this.previousStacks.size() + amount, this.previousStacks);
        ((ISimpleInventoryAccessor)((Object)this)).setSize(this.method_5439() + amount);
    }

    @Override
    public void shrink(int amount) {
        ((ISimpleInventoryAccessor)((Object)this)).setStacks(DynamicStackHandler.getResizedList(this.method_5439() - amount, ((ISimpleInventoryAccessor)((Object)this)).getStacks()));
        this.previousStacks = DynamicStackHandler.getResizedList(this.previousStacks.size() - amount, this.previousStacks);
        ((ISimpleInventoryAccessor)((Object)this)).setSize(this.method_5439() - amount);
    }

    @Override
    public class_2487 serializeTag() {
        class_2499 listTag = new class_2499();
        for (int i = 0; i < this.method_5439(); ++i) {
            class_1799 itemStack = this.method_5438(i);
            if (itemStack.method_7960()) continue;
            class_2487 compoundTag = new class_2487();
            compoundTag.method_10567("Slot", (byte)i);
            itemStack.method_7953(compoundTag);
            listTag.add((Object)compoundTag);
        }
        class_2487 tag = new class_2487();
        tag.method_10566("Items", (class_2520)listTag);
        tag.method_10569("Size", ((ISimpleInventoryAccessor)((Object)this)).getStacks().size());
        return tag;
    }

    @Override
    public void deserializeTag(class_2487 tag) {
        int size = tag.method_10573("Size", 3) ? tag.method_10550("Size") : ((ISimpleInventoryAccessor)((Object)this)).getStacks().size();
        ((ISimpleInventoryAccessor)((Object)this)).setStacks((class_2371<class_1799>)class_2371.method_10213((int)size, (Object)class_1799.field_8037));
        this.previousStacks = class_2371.method_10213((int)size, (Object)class_1799.field_8037);
        ((ISimpleInventoryAccessor)((Object)this)).setSize(size);
        if (tag.method_10545("Items")) {
            int j;
            class_2499 items = tag.method_10554("Items", 10);
            for (j = 0; j < this.method_5439(); ++j) {
                this.method_5447(j, class_1799.field_8037);
            }
            for (j = 0; j < items.size(); ++j) {
                class_2487 compoundTag = items.method_10602(j);
                int k = compoundTag.method_10571("Slot") & 0xFF;
                if (k >= this.method_5439()) continue;
                this.method_5447(k, class_1799.method_7915((class_2487)compoundTag));
            }
        }
    }

    private static class_2371<class_1799> getResizedList(int size, class_2371<class_1799> stacks) {
        class_2371 newList = class_2371.method_10213((int)size, (Object)class_1799.field_8037);
        for (int i = 0; i < newList.size() && i < stacks.size(); ++i) {
            newList.set(i, stacks.get(i));
        }
        return newList;
    }
}

