/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.server;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Map;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_3222;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.server.CurioArgumentType;

public class CuriosCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        LiteralArgumentBuilder curiosCommand = (LiteralArgumentBuilder)class_2170.method_9247((String)"curios").requires(player -> player.method_9259(2));
        curiosCommand.then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"slot", (ArgumentType)CurioArgumentType.slot()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> CuriosCommand.setSlotsForPlayer((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player"), CurioArgumentType.getSlot((CommandContext<class_2168>)context, "slot"), 1))).then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> CuriosCommand.setSlotsForPlayer((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player"), CurioArgumentType.getSlot((CommandContext<class_2168>)context, "slot"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount")))))));
        curiosCommand.then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"slot", (ArgumentType)CurioArgumentType.slot()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> CuriosCommand.growSlotForPlayer((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player"), CurioArgumentType.getSlot((CommandContext<class_2168>)context, "slot"), 1))).then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> CuriosCommand.growSlotForPlayer((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player"), CurioArgumentType.getSlot((CommandContext<class_2168>)context, "slot"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount")))))));
        curiosCommand.then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"slot", (ArgumentType)CurioArgumentType.slot()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> CuriosCommand.shrinkSlotForPlayer((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player"), CurioArgumentType.getSlot((CommandContext<class_2168>)context, "slot"), 1))).then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> CuriosCommand.shrinkSlotForPlayer((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player"), CurioArgumentType.getSlot((CommandContext<class_2168>)context, "slot"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount")))))));
        curiosCommand.then(class_2170.method_9247((String)"unlock").then(class_2170.method_9244((String)"slot", (ArgumentType)CurioArgumentType.slot()).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> CuriosCommand.unlockSlotForPlayer((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player"), CurioArgumentType.getSlot((CommandContext<class_2168>)context, "slot"))))));
        curiosCommand.then(class_2170.method_9247((String)"lock").then(class_2170.method_9244((String)"slot", (ArgumentType)CurioArgumentType.slot()).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> CuriosCommand.lockSlotForPlayer((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player"), CurioArgumentType.getSlot((CommandContext<class_2168>)context, "slot"))))));
        curiosCommand.then(class_2170.method_9247((String)"clear").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> CuriosCommand.clearSlotsForPlayer((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player"), ""))).then(class_2170.method_9244((String)"slot", (ArgumentType)CurioArgumentType.slot()).executes(context -> CuriosCommand.clearSlotsForPlayer((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player"), CurioArgumentType.getSlot((CommandContext<class_2168>)context, "slot"))))));
        curiosCommand.then(class_2170.method_9247((String)"reset").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> CuriosCommand.resetSlotsForPlayer((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player")))));
        dispatcher.register(curiosCommand);
    }

    private static int setSlotsForPlayer(class_2168 source, class_3222 playerMP, String slot, int amount) {
        CuriosApi.getSlotHelper().setSlotsForType(slot, (class_1309)playerMP, amount);
        source.method_9226((class_2561)new class_2588("commands.curios.set.success", new Object[]{slot, CuriosApi.getSlotHelper().getSlotsForType((class_1309)playerMP, slot), playerMP.method_5476()}), true);
        return 1;
    }

    private static int growSlotForPlayer(class_2168 source, class_3222 playerMP, String slot, int amount) {
        CuriosApi.getSlotHelper().growSlotType(slot, amount, (class_1309)playerMP);
        source.method_9226((class_2561)new class_2588("commands.curios.add.success", new Object[]{amount, slot, playerMP.method_5476()}), true);
        return 1;
    }

    private static int shrinkSlotForPlayer(class_2168 source, class_3222 playerMP, String slot, int amount) {
        CuriosApi.getSlotHelper().shrinkSlotType(slot, amount, (class_1309)playerMP);
        source.method_9226((class_2561)new class_2588("commands.curios.remove.success", new Object[]{amount, slot, playerMP.method_5476()}), true);
        return 1;
    }

    private static int unlockSlotForPlayer(class_2168 source, class_3222 playerMP, String slot) {
        CuriosApi.getSlotHelper().unlockSlotType(slot, (class_1309)playerMP);
        source.method_9226((class_2561)new class_2588("commands.curios.unlock.success", new Object[]{slot, playerMP.method_5476()}), true);
        return 1;
    }

    private static int lockSlotForPlayer(class_2168 source, class_3222 playerMP, String slot) {
        CuriosApi.getSlotHelper().lockSlotType(slot, (class_1309)playerMP);
        source.method_9226((class_2561)new class_2588("commands.curios.lock.success", new Object[]{slot, playerMP.method_5476()}), true);
        return 1;
    }

    private static int clearSlotsForPlayer(class_2168 source, class_3222 playerMP, String slot) {
        CuriosApi.getCuriosHelper().getCuriosHandler((class_1309)playerMP).ifPresent(handler -> {
            Map<String, ICurioStacksHandler> curios = handler.getCurios();
            if (!slot.isEmpty() && curios.get(slot) != null) {
                CuriosCommand.clear(curios.get(slot));
            } else {
                for (String id : curios.keySet()) {
                    CuriosCommand.clear(curios.get(id));
                }
            }
        });
        if (slot.isEmpty()) {
            source.method_9226((class_2561)new class_2588("commands.curios.clearAll.success", new Object[]{playerMP.method_5476()}), true);
        } else {
            source.method_9226((class_2561)new class_2588("commands.curios.clear.success", new Object[]{slot, playerMP.method_5476()}), true);
        }
        return 1;
    }

    private static int resetSlotsForPlayer(class_2168 source, class_3222 playerMP) {
        CuriosApi.getCuriosHelper().getCuriosHandler((class_1309)playerMP).ifPresent(handler -> {
            handler.reset();
            handler.sync();
        });
        source.method_9226((class_2561)new class_2588("commands.curios.reset.success", new Object[]{playerMP.method_5476()}), true);
        return 1;
    }

    private static void clear(ICurioStacksHandler stacksHandler) {
        for (int i = 0; i < stacksHandler.getSlots(); ++i) {
            stacksHandler.getStacks().method_5447(i, class_1799.field_8037);
            stacksHandler.getCosmeticStacks().method_5447(i, class_1799.field_8037);
        }
    }
}

