/*
 * Decompiled with CFR 0.152.
 */
package ru.betterend.client;

import java.util.List;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import ru.bclib.BCLib;
import ru.bclib.blocks.BaseChestBlock;
import ru.bclib.blocks.BaseSignBlock;
import ru.bclib.client.render.BCLRenderLayer;
import ru.bclib.client.render.BaseChestBlockEntityRenderer;
import ru.bclib.client.render.BaseSignBlockEntityRenderer;
import ru.bclib.interfaces.IRenderTyped;
import ru.bclib.util.TranslationHelper;
import ru.betterend.client.ClientOptions;
import ru.betterend.events.ItemTooltipCallback;
import ru.betterend.interfaces.MultiModelItem;
import ru.betterend.item.CrystaliteArmor;
import ru.betterend.registry.EndBlockEntityRenders;
import ru.betterend.registry.EndBlocks;
import ru.betterend.registry.EndEntitiesRenders;
import ru.betterend.registry.EndModelProviders;
import ru.betterend.registry.EndParticles;
import ru.betterend.registry.EndScreens;

public class BetterEndClient
implements ClientModInitializer {
    public void onInitializeClient() {
        this.registerRenderLayers();
        EndBlockEntityRenders.register();
        EndScreens.register();
        EndParticles.register();
        EndEntitiesRenders.register();
        EndModelProviders.register();
        MultiModelItem.register();
        ClientOptions.init();
        BetterEndClient.registerRenderers();
        BetterEndClient.registerTooltips();
        if (BCLib.isDevEnvironment()) {
            TranslationHelper.printMissingNames((String)"betterend");
        }
    }

    public static void registerTooltips() {
        ItemTooltipCallback.EVENT.register((player, stack, context, lines) -> {
            if (stack.method_7909() instanceof CrystaliteArmor) {
                boolean hasSet = false;
                if (player != null) {
                    hasSet = CrystaliteArmor.hasFullSet((class_1309)player);
                }
                class_2588 setDesc = new class_2588("tooltip.armor.crystalite_set");
                setDesc.method_10862(class_2583.field_24360.method_27705(new class_124[]{hasSet ? class_124.field_1078 : class_124.field_1063, class_124.field_1056}));
                lines.add(class_2585.field_24366);
                lines.add(setDesc);
            }
        });
    }

    private void registerRenderLayers() {
        class_1921 cutout = class_1921.method_23581();
        class_1921 translucent = class_1921.method_23583();
        class_2378.field_11146.forEach(block -> {
            if (block instanceof IRenderTyped) {
                BCLRenderLayer layer = ((IRenderTyped)block).getRenderLayer();
                if (layer == BCLRenderLayer.CUTOUT) {
                    BlockRenderLayerMap.INSTANCE.putBlock(block, cutout);
                } else if (layer == BCLRenderLayer.TRANSLUCENT) {
                    BlockRenderLayerMap.INSTANCE.putBlock(block, translucent);
                }
            }
        });
    }

    private static void registerRenderers() {
        List<class_2248> modBlocks = EndBlocks.getModBlocks();
        modBlocks.stream().filter(BaseChestBlock.class::isInstance).forEach(BaseChestBlockEntityRenderer::registerRenderLayer);
        modBlocks.stream().filter(BaseSignBlock.class::isInstance).forEach(BaseSignBlockEntityRenderer::registerRenderLayer);
    }
}

