/*
 * Decompiled with CFR 0.152.
 */
package ru.betterend.integration.rei;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.TransferRecipeCategory;
import me.shedaniel.rei.api.widgets.Widgets;
import me.shedaniel.rei.gui.entries.RecipeEntry;
import me.shedaniel.rei.gui.entries.SimpleRecipeEntry;
import me.shedaniel.rei.gui.widget.Widget;
import net.minecraft.class_1747;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import org.jetbrains.annotations.NotNull;
import ru.betterend.blocks.basis.EndAnvilBlock;
import ru.betterend.integration.rei.REIAnvilDisplay;
import ru.betterend.integration.rei.REIPlugin;
import ru.betterend.util.LangUtil;

public class REIAnvilCategory
implements TransferRecipeCategory<REIAnvilDisplay> {
    @NotNull
    public class_2960 getIdentifier() {
        return REIPlugin.SMITHING;
    }

    @NotNull
    public String getCategoryName() {
        return LangUtil.translate(class_2246.field_10535.method_9539());
    }

    @NotNull
    public EntryStack getLogo() {
        return REIPlugin.ANVILS[0];
    }

    @NotNull
    public List<Widget> setupDisplay(REIAnvilDisplay display, Rectangle bounds) {
        Point startPoint = new Point(bounds.getCenterX() - 41, bounds.y + 10);
        ArrayList widgets = Lists.newArrayList();
        widgets.add(Widgets.createRecipeBase((Rectangle)bounds));
        int x = startPoint.x + 10;
        int y = startPoint.y;
        widgets.add(Widgets.createResultSlotBackground((Point)new Point(x + 61, y + 5)));
        List<List<EntryStack>> inputEntries = display.getInputEntries();
        List<EntryStack> materials = inputEntries.get(1);
        int anvilLevel = display.getAnvilLevel();
        List anvils = Arrays.stream(REIPlugin.ANVILS).filter(anvil -> {
            class_2248 block = ((class_1747)anvil.getItem()).method_7711();
            if (block instanceof EndAnvilBlock) {
                return ((EndAnvilBlock)block).getCraftingLevel() >= anvilLevel;
            }
            return anvilLevel == 1;
        }).collect(Collectors.toList());
        materials.forEach(entryStack -> entryStack.setAmount(display.getInputCount()));
        widgets.add(Widgets.createArrow((Point)new Point(x + 24, y + 4)));
        widgets.add(Widgets.createLabel((Point)new Point(bounds.x + bounds.width - 7, bounds.y + bounds.height - 15), (class_2561)new class_2588("category.rei.damage.amount&dmg", new Object[]{display.getDamage()})).noShadow().rightAligned().color(-12566464, -4473925));
        widgets.add(Widgets.createSlot((Point)new Point(x - 20, y + 4)).entries(materials).markInput());
        widgets.add(Widgets.createSlot((Point)new Point(x + 1, y + 4)).entries((Collection)inputEntries.get(0)).markInput());
        widgets.add(Widgets.createSlot((Point)new Point(x + 61, y + 5)).entries((Collection)display.getResultingEntries().get(0)).disableBackground().markOutput());
        widgets.add(Widgets.createSlot((Point)new Point(x - 9, y + 25)).entries(anvils));
        return widgets;
    }

    public void renderRedSlots(class_4587 matrices, List<Widget> widgets, Rectangle bounds, REIAnvilDisplay display, IntList redSlots) {
        Point startPoint = new Point(bounds.getCenterX() - 41, bounds.getCenterY() - 27);
        matrices.method_22903();
        matrices.method_22904(0.0, 0.0, 400.0);
        if (redSlots.contains(0)) {
            class_332.method_25294((class_4587)matrices, (int)(startPoint.x - 20), (int)(startPoint.y + 3), (int)(startPoint.x - 20 + 16), (int)(startPoint.y + 3 + 16), (int)0x40FF0000);
            class_332.method_25294((class_4587)matrices, (int)(startPoint.x + 1), (int)(startPoint.y + 3), (int)(startPoint.x + 1 + 16), (int)(startPoint.y + 3 + 16), (int)0x40FF0000);
        }
        matrices.method_22909();
    }

    @NotNull
    public RecipeEntry getSimpleRenderer(REIAnvilDisplay recipe) {
        return SimpleRecipeEntry.from(Collections.singletonList(recipe.getInputEntries().get(0)), recipe.getResultingEntries());
    }

    public int getDisplayHeight() {
        return 60;
    }
}

