/*
 * Decompiled with CFR 0.152.
 */
package ru.betterend.recipe.builders;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1263;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3494;
import net.minecraft.class_3518;
import net.minecraft.class_3956;
import ru.bclib.recipes.BCLRecipeManager;
import ru.betterend.BetterEnd;
import ru.betterend.config.Configs;
import ru.betterend.interfaces.BetterEndRecipe;
import ru.betterend.registry.EndBlocks;
import ru.betterend.util.ItemUtil;
import ru.betterend.util.RecipeHelper;

public class AlloyingRecipe
implements class_1860<class_1263>,
BetterEndRecipe {
    public static final String GROUP = "alloying";
    public static final class_3956<AlloyingRecipe> TYPE = BCLRecipeManager.registerType((String)"betterend", (String)"alloying");
    public static final Serializer SERIALIZER = (Serializer)BCLRecipeManager.registerSerializer((String)"betterend", (String)"alloying", (class_1865)new Serializer());
    public static final class_2960 ID = BetterEnd.makeID("alloying");
    protected final class_3956<?> type;
    protected final class_2960 id;
    protected final class_1856 primaryInput;
    protected final class_1856 secondaryInput;
    protected final class_1799 output;
    protected final String group;
    protected final float experience;
    protected final int smeltTime;

    public AlloyingRecipe(class_2960 id, String group, class_1856 primaryInput, class_1856 secondaryInput, class_1799 output, float experience, int smeltTime) {
        this.group = group;
        this.id = id;
        this.primaryInput = primaryInput;
        this.secondaryInput = secondaryInput;
        this.output = output;
        this.experience = experience;
        this.smeltTime = smeltTime;
        this.type = TYPE;
    }

    public float getExperience() {
        return this.experience;
    }

    public int getSmeltTime() {
        return this.smeltTime;
    }

    public class_2371<class_1856> method_8117() {
        class_2371 defaultedList = class_2371.method_10211();
        defaultedList.add((Object)this.primaryInput);
        defaultedList.add((Object)this.secondaryInput);
        return defaultedList;
    }

    public boolean method_8115(class_1263 inv, class_1937 world) {
        return this.primaryInput.method_8093(inv.method_5438(0)) && this.secondaryInput.method_8093(inv.method_5438(1)) || this.primaryInput.method_8093(inv.method_5438(1)) && this.secondaryInput.method_8093(inv.method_5438(0));
    }

    public class_1799 method_8116(class_1263 inv) {
        return this.output.method_7972();
    }

    public boolean method_8113(int width, int height) {
        return true;
    }

    public class_1799 method_8110() {
        return this.output;
    }

    public class_2960 method_8114() {
        return this.id;
    }

    public class_1865<?> method_8119() {
        return SERIALIZER;
    }

    public class_3956<?> method_17716() {
        return this.type;
    }

    @Environment(value=EnvType.CLIENT)
    public String method_8112() {
        return this.group;
    }

    @Environment(value=EnvType.CLIENT)
    public class_1799 method_17447() {
        return new class_1799((class_1935)EndBlocks.END_STONE_SMELTER);
    }

    public static class Serializer
    implements class_1865<AlloyingRecipe> {
        public AlloyingRecipe fromJson(class_2960 id, JsonObject json) {
            JsonArray ingredients = class_3518.method_15261((JsonObject)json, (String)"ingredients");
            class_1856 primaryInput = class_1856.method_8102((JsonElement)ingredients.get(0));
            class_1856 secondaryInput = class_1856.method_8102((JsonElement)ingredients.get(1));
            String group = class_3518.method_15253((JsonObject)json, (String)"group", (String)"");
            JsonObject result = class_3518.method_15296((JsonObject)json, (String)"result");
            class_1799 output = ItemUtil.fromJsonRecipe(result);
            if (output == null) {
                throw new IllegalStateException("Output item does not exists!");
            }
            float experience = class_3518.method_15277((JsonObject)json, (String)"experience", (float)0.0f);
            int smeltTime = class_3518.method_15282((JsonObject)json, (String)"smelttime", (int)350);
            return new AlloyingRecipe(id, group, primaryInput, secondaryInput, output, experience, smeltTime);
        }

        public AlloyingRecipe fromNetwork(class_2960 id, class_2540 packetBuffer) {
            String group = packetBuffer.method_10800(Short.MAX_VALUE);
            class_1856 primary = class_1856.method_8086((class_2540)packetBuffer);
            class_1856 secondary = class_1856.method_8086((class_2540)packetBuffer);
            class_1799 output = packetBuffer.method_10819();
            float experience = packetBuffer.readFloat();
            int smeltTime = packetBuffer.method_10816();
            return new AlloyingRecipe(id, group, primary, secondary, output, experience, smeltTime);
        }

        public void toNetwork(class_2540 packetBuffer, AlloyingRecipe recipe) {
            packetBuffer.method_10814(recipe.group);
            recipe.primaryInput.method_8088(packetBuffer);
            recipe.secondaryInput.method_8088(packetBuffer);
            packetBuffer.method_10793(recipe.output);
            packetBuffer.writeFloat(recipe.experience);
            packetBuffer.method_10804(recipe.smeltTime);
        }
    }

    public static class Builder {
        private static final Builder INSTANCE = new Builder();
        private static boolean exist;
        private class_2960 id;
        private class_1856 primaryInput;
        private class_1856 secondaryInput;
        private class_1799 output;
        private String group;
        private float experience;
        private int smeltTime;
        private boolean alright = true;

        public static Builder create(class_2960 id) {
            Builder.INSTANCE.id = id;
            Builder.INSTANCE.group = String.format("%s_%s", AlloyingRecipe.GROUP, id);
            Builder.INSTANCE.primaryInput = null;
            Builder.INSTANCE.secondaryInput = null;
            Builder.INSTANCE.output = null;
            Builder.INSTANCE.experience = 0.0f;
            Builder.INSTANCE.smeltTime = 350;
            exist = Configs.RECIPE_CONFIG.getBoolean(AlloyingRecipe.GROUP, id.method_12832(), true);
            return INSTANCE;
        }

        public static Builder create(String id) {
            return Builder.create(BetterEnd.makeID(id));
        }

        private Builder() {
        }

        public Builder setGroup(String group) {
            this.group = group;
            return this;
        }

        public Builder setPrimaryInput(class_1935 ... inputs) {
            for (class_1935 item : inputs) {
                this.alright &= RecipeHelper.exists(item);
            }
            this.primaryInput = class_1856.method_8091((class_1935[])inputs);
            return this;
        }

        public Builder setSecondaryInput(class_1935 ... inputs) {
            for (class_1935 item : inputs) {
                this.alright &= RecipeHelper.exists(item);
            }
            this.secondaryInput = class_1856.method_8091((class_1935[])inputs);
            return this;
        }

        public Builder setPrimaryInput(class_3494<class_1792> input) {
            this.primaryInput = class_1856.method_8106(input);
            return this;
        }

        public Builder setSecondaryInput(class_3494<class_1792> input) {
            this.secondaryInput = class_1856.method_8106(input);
            return this;
        }

        public Builder setInput(class_1935 primaryInput, class_1935 secondaryInput) {
            this.setPrimaryInput(primaryInput);
            this.setSecondaryInput(secondaryInput);
            return this;
        }

        public Builder setInput(class_3494<class_1792> primaryInput, class_3494<class_1792> secondaryInput) {
            this.setPrimaryInput(primaryInput);
            this.setSecondaryInput(secondaryInput);
            return this;
        }

        public Builder setOutput(class_1935 output, int amount) {
            this.alright &= RecipeHelper.exists(output);
            this.output = new class_1799(output, amount);
            return this;
        }

        public Builder setExpiriense(float amount) {
            this.experience = amount;
            return this;
        }

        public Builder setSmeltTime(int time) {
            this.smeltTime = time;
            return this;
        }

        public void build() {
            if (exist) {
                if (this.primaryInput == null) {
                    BetterEnd.LOGGER.warning("Primary input for Alloying recipe can't be 'null', recipe {} will be ignored!", new Object[]{this.id});
                    return;
                }
                if (this.secondaryInput == null) {
                    BetterEnd.LOGGER.warning("Secondary input for Alloying can't be 'null', recipe {} will be ignored!", new Object[]{this.id});
                    return;
                }
                if (this.output == null) {
                    BetterEnd.LOGGER.warning("Output for Alloying can't be 'null', recipe {} will be ignored!", new Object[]{this.id});
                    return;
                }
                if (BCLRecipeManager.getRecipe(TYPE, (class_2960)this.id) != null) {
                    BetterEnd.LOGGER.warning("Can't add Alloying recipe! Id {} already exists!", new Object[]{this.id});
                    return;
                }
                if (!this.alright) {
                    BetterEnd.LOGGER.debug((Object)"Can't add Alloying recipe {}! Ingeredient or output not exists.", new Object[]{this.id});
                    return;
                }
                BCLRecipeManager.addRecipe(TYPE, (class_1860)new AlloyingRecipe(this.id, this.group, this.primaryInput, this.secondaryInput, this.output, this.experience, this.smeltTime));
            }
        }
    }
}

