/*
 * Decompiled with CFR 0.152.
 */
package ru.betterend.world.features.trees;

import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.class_1160;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2397;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2794;
import net.minecraft.class_3111;
import net.minecraft.class_3494;
import net.minecraft.class_3614;
import net.minecraft.class_5281;
import net.minecraft.class_5425;
import ru.bclib.api.TagAPI;
import ru.bclib.sdf.PosInfo;
import ru.bclib.sdf.SDF;
import ru.bclib.sdf.operator.SDFDisplacement;
import ru.bclib.sdf.operator.SDFSubtraction;
import ru.bclib.sdf.operator.SDFTranslate;
import ru.bclib.sdf.primitive.SDFPrimitive;
import ru.bclib.sdf.primitive.SDFSphere;
import ru.bclib.util.BlocksHelper;
import ru.bclib.util.MHelper;
import ru.bclib.util.SplineHelper;
import ru.bclib.world.features.DefaultFeature;
import ru.betterend.noise.OpenSimplexNoise;
import ru.betterend.registry.EndBlocks;

public class LacugroveFeature
extends DefaultFeature {
    private static final Function<class_2680, Boolean> REPLACE = state -> {
        if (state.method_26164((class_3494)TagAPI.END_GROUND)) {
            return true;
        }
        if (EndBlocks.LACUGROVE.isTreeLog((class_2680)state)) {
            return true;
        }
        if (state.method_26204() == EndBlocks.LACUGROVE_LEAVES) {
            return true;
        }
        if (state.method_26207().equals(class_3614.field_15935)) {
            return true;
        }
        return state.method_26207().method_15800();
    };
    private static final Function<class_2680, Boolean> IGNORE = state -> EndBlocks.LACUGROVE.isTreeLog((class_2680)state);
    private static final Function<PosInfo, class_2680> POST = info -> {
        if (EndBlocks.LACUGROVE.isTreeLog(info.getStateUp()) && EndBlocks.LACUGROVE.isTreeLog(info.getStateDown())) {
            return EndBlocks.LACUGROVE.log.method_9564();
        }
        return info.getState();
    };

    public boolean place(class_5281 world, class_2794 chunkGenerator, Random random, class_2338 pos, class_3111 config) {
        if (!world.method_8320(pos.method_10074()).method_26164((class_3494)TagAPI.END_GROUND)) {
            return false;
        }
        float size = MHelper.randRange((int)15, (int)25, (Random)random);
        List spline = SplineHelper.makeSpline((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)size, (float)0.0f, (int)6);
        SplineHelper.offsetParts((List)spline, (Random)random, (float)1.0f, (float)0.0f, (float)1.0f);
        if (!SplineHelper.canGenerate((List)spline, (class_2338)pos, (class_5281)world, REPLACE)) {
            return false;
        }
        OpenSimplexNoise noise = new OpenSimplexNoise(random.nextLong());
        float radius = MHelper.randRange((float)6.0f, (float)8.0f, (Random)random);
        class_1160 center = (class_1160)spline.get(4);
        this.leavesBall(world, pos.method_10080((double)center.method_4943(), (double)center.method_4945(), (double)center.method_4947()), radius *= (size - 15.0f) / 20.0f + 1.0f, random, noise);
        radius = MHelper.randRange((float)1.2f, (float)1.8f, (Random)random);
        SDF function = SplineHelper.buildSDF((List)spline, (float)radius, (float)0.7f, bpos -> EndBlocks.LACUGROVE.bark.method_9564());
        function.setReplaceFunction(REPLACE);
        function.addPostProcess(POST);
        function.fillRecursive((class_5425)world, pos);
        spline = spline.subList(4, 6);
        SplineHelper.fillSpline(spline, (class_5281)world, (class_2680)EndBlocks.LACUGROVE.bark.method_9564(), (class_2338)pos, REPLACE);
        class_2338.class_2339 mut = new class_2338.class_2339();
        int offset = random.nextInt(2);
        block0: for (int i = 0; i < 100; ++i) {
            int top;
            double distance;
            double px = pos.method_10263() + MHelper.randRange((int)-5, (int)5, (Random)random);
            double pz = pos.method_10260() + MHelper.randRange((int)-5, (int)5, (Random)random);
            mut.method_20787(MHelper.floor((double)(px + 0.5)));
            mut.method_20788(MHelper.floor((double)(pz + 0.5)));
            if ((mut.method_10263() + mut.method_10260() + offset & 1) != 0 || !((distance = 3.5 - MHelper.length((double)(px - (double)pos.method_10263()), (double)(pz - (double)pos.method_10260())) * 0.5) > 0.0)) continue;
            int minY = MHelper.floor((double)((double)pos.method_10264() - distance * 0.5));
            int maxY = MHelper.floor((double)((double)pos.method_10264() + distance + random.nextDouble()));
            boolean generate = false;
            for (int y = minY; y < maxY; ++y) {
                mut.method_10099(y);
                if (!world.method_8320((class_2338)mut).method_26164((class_3494)TagAPI.END_GROUND)) continue;
                generate = true;
                break;
            }
            if (!generate) continue;
            for (int y = top = maxY - 1; y >= minY; --y) {
                mut.method_10099(y);
                class_2680 state = world.method_8320((class_2338)mut);
                if (!state.method_26207().method_15800() && !state.method_26207().equals(class_3614.field_15935) && !state.method_26164((class_3494)TagAPI.END_GROUND)) continue block0;
                BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)mut, (class_2248)(y == top ? EndBlocks.LACUGROVE.bark : EndBlocks.LACUGROVE.log));
            }
        }
        return true;
    }

    private void leavesBall(class_5281 world, class_2338 pos, float radius, Random random, OpenSimplexNoise noise) {
        SDFPrimitive sphere = new SDFSphere().setRadius(radius).setBlock((class_2680)EndBlocks.LACUGROVE_LEAVES.method_9564().method_11657((class_2769)class_2397.field_11199, (Comparable)Integer.valueOf(6)));
        sphere = new SDFDisplacement().setFunction(vec -> Float.valueOf((float)noise.eval((double)vec.method_4943() * 0.2, (double)vec.method_4945() * 0.2, (double)vec.method_4947() * 0.2) * 3.0f)).setSource((SDF)sphere);
        sphere = new SDFDisplacement().setFunction(vec -> Float.valueOf(random.nextFloat() * 3.0f - 1.5f)).setSource((SDF)sphere);
        sphere = new SDFSubtraction().setSourceA((SDF)sphere).setSourceB((SDF)new SDFTranslate().setTranslate(0.0f, -radius - 2.0f, 0.0f).setSource((SDF)sphere));
        class_2338.class_2339 mut = new class_2338.class_2339();
        sphere.addPostProcess(info -> {
            if (random.nextInt(5) == 0) {
                for (class_2350 dir : class_2350.values()) {
                    class_2680 state = info.getState(dir, 2);
                    if (!state.method_26215()) continue;
                    return info.getState();
                }
                info.setState(EndBlocks.LACUGROVE.bark.method_9564());
                for (int x = -6; x < 7; ++x) {
                    int ax = Math.abs(x);
                    mut.method_20787(x + info.getPos().method_10263());
                    for (int z = -6; z < 7; ++z) {
                        int az = Math.abs(z);
                        mut.method_20788(z + info.getPos().method_10260());
                        for (int y = -6; y < 7; ++y) {
                            int distance;
                            int ay = Math.abs(y);
                            int d = ax + ay + az;
                            if (d >= 7) continue;
                            mut.method_10099(y + info.getPos().method_10264());
                            class_2680 state = info.getState((class_2338)mut);
                            if (!(state.method_26204() instanceof class_2397) || d >= (distance = ((Integer)state.method_11654((class_2769)class_2397.field_11199)).intValue())) continue;
                            info.setState((class_2338)mut, (class_2680)state.method_11657((class_2769)class_2397.field_11199, (Comparable)Integer.valueOf(d)));
                        }
                    }
                }
            }
            return info.getState();
        });
        sphere.fillRecursiveIgnore((class_5425)world, pos, IGNORE);
        if (radius > 5.0f) {
            int count = (int)(radius * 2.5f);
            for (int i = 0; i < count; ++i) {
                class_2338 p = pos.method_10080(random.nextGaussian() * 1.0, random.nextGaussian() * 1.0, random.nextGaussian() * 1.0);
                boolean place = true;
                for (class_2350 d : class_2350.values()) {
                    class_2680 state = world.method_8320(p.method_10093(d));
                    if (EndBlocks.LACUGROVE.isTreeLog(state) || state.method_27852(EndBlocks.LACUGROVE_LEAVES)) continue;
                    place = false;
                    break;
                }
                if (!place) continue;
                BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)p, (class_2248)EndBlocks.LACUGROVE.bark);
            }
        }
        BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)pos, (class_2248)EndBlocks.LACUGROVE.bark);
    }
}

