/*
 * Decompiled with CFR 0.152.
 */
package ru.betterend.world.structures.piece;

import java.util.Random;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_3341;
import net.minecraft.class_3485;
import net.minecraft.class_3494;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import ru.bclib.api.TagAPI;
import ru.bclib.util.BlocksHelper;
import ru.bclib.util.MHelper;
import ru.betterend.noise.OpenSimplexNoise;
import ru.betterend.registry.EndStructures;
import ru.betterend.world.structures.piece.BasePiece;

public class CavePiece
extends BasePiece {
    private OpenSimplexNoise noise;
    private class_2338 center;
    private float radius;

    public CavePiece(class_2338 center, float radius, int id) {
        super(EndStructures.CAVE_PIECE, id);
        this.center = center;
        this.radius = radius;
        this.noise = new OpenSimplexNoise(MHelper.getSeed((int)534, (int)center.method_10263(), (int)center.method_10260()));
        this.makeBoundingBox();
    }

    public CavePiece(class_3485 manager, class_2487 tag) {
        super(EndStructures.CAVE_PIECE, tag);
        this.makeBoundingBox();
    }

    public boolean method_14931(class_5281 world, class_5138 arg, class_2794 chunkGenerator, Random random, class_3341 blockBox, class_1923 chunkPos, class_2338 blockPos) {
        int x1 = MHelper.max((int)this.field_15315.field_14381, (int)blockBox.field_14381);
        int z1 = MHelper.max((int)this.field_15315.field_14379, (int)blockBox.field_14379);
        int x2 = MHelper.min((int)this.field_15315.field_14378, (int)blockBox.field_14378);
        int z2 = MHelper.min((int)this.field_15315.field_14376, (int)blockBox.field_14376);
        int y1 = this.field_15315.field_14380;
        int y2 = this.field_15315.field_14377;
        double hr = (double)this.radius * 0.75;
        double nr = (double)this.radius * 0.25;
        class_2338.class_2339 pos = new class_2338.class_2339();
        for (int x = x1; x <= x2; ++x) {
            int xsq = x - this.center.method_10263();
            xsq *= xsq;
            pos.method_20787(x);
            for (int z = z1; z <= z2; ++z) {
                int zsq = z - this.center.method_10260();
                zsq *= zsq;
                pos.method_20788(z);
                for (int y = y1; y <= y2; ++y) {
                    int ysq = y - this.center.method_10264();
                    ysq = (int)((double)ysq * 1.6);
                    ysq *= ysq;
                    pos.method_10099(y);
                    double r = this.noise.eval((double)x * 0.1, (double)y * 0.1, (double)z * 0.1) * nr + hr;
                    double r2 = r - 4.5;
                    double dist = xsq + ysq + zsq;
                    if (dist < r2 * r2) {
                        if (!world.method_8320((class_2338)pos).method_26164((class_3494)TagAPI.END_GROUND)) continue;
                        BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)pos, (class_2680)field_15314);
                        continue;
                    }
                    if (!(dist < r * r) || !world.method_8320((class_2338)pos).method_26207().method_15800()) continue;
                    BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)pos, (class_2248)class_2246.field_10471);
                }
            }
        }
        return true;
    }

    protected void method_14943(class_2487 tag) {
        tag.method_10566("center", (class_2520)class_2512.method_10692((class_2338)this.center));
        tag.method_10548("radius", this.radius);
    }

    @Override
    protected void fromNbt(class_2487 tag) {
        this.center = class_2512.method_10691((class_2487)tag.method_10562("center"));
        this.radius = tag.method_10583("radius");
        this.noise = new OpenSimplexNoise(MHelper.getSeed((int)534, (int)this.center.method_10263(), (int)this.center.method_10260()));
    }

    private void makeBoundingBox() {
        int minX = MHelper.floor((double)((float)this.center.method_10263() - this.radius));
        int minY = MHelper.floor((double)((float)this.center.method_10264() - this.radius));
        int minZ = MHelper.floor((double)((float)this.center.method_10260() - this.radius));
        int maxX = MHelper.floor((double)((float)this.center.method_10263() + this.radius + 1.0f));
        int maxY = MHelper.floor((double)((float)this.center.method_10264() + this.radius + 1.0f));
        int maxZ = MHelper.floor((double)((float)this.center.method_10260() + this.radius + 1.0f));
        this.field_15315 = new class_3341(minX, minY, minZ, maxX, maxY, maxZ);
    }
}

