/*
 * Decompiled with CFR 0.152.
 */
package me.benfah.doorsofinfinity.block;

import java.util.function.Predicate;
import me.benfah.doorsofinfinity.block.entity.InfinityDoorBlockEntity;
import me.benfah.doorsofinfinity.config.DOFConfig;
import me.benfah.doorsofinfinity.dimension.InfinityDimHelper;
import me.benfah.doorsofinfinity.init.DOFBlocks;
import me.benfah.doorsofinfinity.init.DOFDimensions;
import me.benfah.doorsofinfinity.utils.MCUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2750;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_3614;
import net.minecraft.class_3619;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;

public class InfinityDoorBlock
extends class_2237 {
    public static final class_2753 FACING = class_2383.field_11177;
    public static final class_2746 OPEN = class_2741.field_12537;
    public static final class_2754<class_2750> HINGE = class_2741.field_12520;
    public static final class_2754<class_2756> HALF = class_2741.field_12533;
    protected static final class_265 NORTH_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    protected static final class_265 SOUTH_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final class_265 EAST_SHAPE = class_2248.method_9541((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final class_265 WEST_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);

    public InfinityDoorBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)OPEN, (Comparable)Boolean.valueOf(false))).method_11657(HINGE, (Comparable)class_2750.field_12588)).method_11657(HALF, (Comparable)class_2756.field_12607));
    }

    public class_265 method_9530(class_2680 state, class_1922 view, class_2338 pos, class_3726 context) {
        class_2350 direction = (class_2350)state.method_11654((class_2769)FACING);
        boolean bl = (Boolean)state.method_11654((class_2769)OPEN) == false;
        boolean bl2 = state.method_11654(HINGE) == class_2750.field_12586;
        switch (direction) {
            default: {
                return bl ? WEST_SHAPE : (bl2 ? SOUTH_SHAPE : NORTH_SHAPE);
            }
            case field_11035: {
                return bl ? NORTH_SHAPE : (bl2 ? WEST_SHAPE : EAST_SHAPE);
            }
            case field_11039: {
                return bl ? EAST_SHAPE : (bl2 ? NORTH_SHAPE : SOUTH_SHAPE);
            }
            case field_11043: 
        }
        return bl ? SOUTH_SHAPE : (bl2 ? EAST_SHAPE : WEST_SHAPE);
    }

    public class_2680 method_9559(class_2680 state, class_2350 facing, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        class_2756 doubleBlockHalf = (class_2756)state.method_11654(HALF);
        if (facing.method_10166() == class_2350.class_2351.field_11052 && doubleBlockHalf == class_2756.field_12607 == (facing == class_2350.field_11036)) {
            return neighborState.method_26204() == this && neighborState.method_11654(HALF) != doubleBlockHalf ? (class_2680)((class_2680)((class_2680)state.method_11657((class_2769)FACING, neighborState.method_11654((class_2769)FACING))).method_11657((class_2769)OPEN, neighborState.method_11654((class_2769)OPEN))).method_11657(HINGE, neighborState.method_11654(HINGE)) : class_2246.field_10124.method_9564();
        }
        return doubleBlockHalf == class_2756.field_12607 && facing == class_2350.field_11033 && !state.method_26184((class_4538)world, pos) ? class_2246.field_10124.method_9564() : super.method_9559(state, facing, neighborState, world, pos, neighborPos);
    }

    public void method_9556(class_1937 world, class_1657 player, class_2338 pos, class_2680 state, class_2586 blockEntity, class_1799 stack) {
        super.method_9556(world, player, pos, class_2246.field_10124.method_9564(), blockEntity, stack);
    }

    public void method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        if (!world.method_27983().equals(DOFDimensions.INFINITY_DIM)) {
            class_2338 lowerPos = state.method_11654(HALF) == class_2756.field_12607 ? pos : pos.method_10074();
            class_2680 lowerBlockState = world.method_8320(lowerPos);
            class_2756 doubleBlockHalf = (class_2756)state.method_11654(HALF);
            class_2338 otherPos = doubleBlockHalf == class_2756.field_12607 ? pos.method_10084() : pos.method_10074();
            class_2680 otherblockState = world.method_8320(otherPos);
            InfinityDoorBlockEntity lowerBlockEntity = (InfinityDoorBlockEntity)world.method_8321(lowerPos);
            if (otherblockState.method_26204() == this && otherblockState.method_11654(HALF) != doubleBlockHalf) {
                world.method_8444(player, 2001, otherPos, class_2248.method_9507((class_2680)otherblockState));
                if (!world.field_9236 && !player.method_7337() && player.method_7305(otherblockState)) {
                    class_2248.method_9610((class_2680)lowerBlockState, (class_1936)world, (class_2338)lowerPos, (class_2586)world.method_8321(lowerPos));
                }
                world.method_8652(otherPos, class_2246.field_10124.method_9564(), 35);
            }
            if (!world.field_9236 && MCUtils.isIPPresent()) {
                lowerBlockEntity.deleteLocalPortal();
            }
        }
        super.method_9576(world, pos, state, player);
    }

    public float method_9594(class_2680 state, class_1657 player, class_1922 world, class_2338 pos) {
        if (world instanceof class_1937 && ((class_1937)world).method_27983().equals(DOFDimensions.INFINITY_DIM)) {
            return 0.0f;
        }
        return super.method_9594(state, player, world, pos);
    }

    public boolean method_9516(class_2680 world, class_1922 view, class_2338 pos, class_10 env) {
        switch (env) {
            case field_50: 
            case field_51: {
                return (Boolean)world.method_11654((class_2769)OPEN);
            }
        }
        return false;
    }

    private int getOpenSoundEventId() {
        return this.field_23158 == class_3614.field_15953 ? 1011 : 1012;
    }

    private int getCloseSoundEventId() {
        return this.field_23158 == class_3614.field_15953 ? 1005 : 1006;
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_2338 blockPos = ctx.method_8037();
        if (blockPos.method_10264() < 255 && ctx.method_8045().method_8320(blockPos.method_10084()).method_26166(ctx)) {
            class_1937 world = ctx.method_8045();
            boolean bl = world.method_8479(blockPos) || world.method_8479(blockPos.method_10084());
            return (class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)ctx.method_8042())).method_11657(HINGE, (Comparable)this.getHinge(ctx))).method_11657((class_2769)OPEN, (Comparable)Boolean.valueOf(bl))).method_11657(HALF, (Comparable)class_2756.field_12607);
        }
        return null;
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, class_1309 placer, class_1799 itemStack) {
        world.method_8652(pos.method_10084(), (class_2680)state.method_11657(HALF, (Comparable)class_2756.field_12609), 3);
        if (state.method_11654(HALF) == class_2756.field_12607 && !world.field_9236) {
            InfinityDoorBlockEntity blockEntity;
            if (itemStack != null && itemStack.method_7941("BlockEntity") != null) {
                blockEntity = new InfinityDoorBlockEntity();
                blockEntity.updateSyncDoor();
            }
            blockEntity = (InfinityDoorBlockEntity)world.method_8321(pos);
            InfinityDimHelper.PersonalDimension personalDim = blockEntity.getOrCreateLinkedDimension();
            blockEntity.placeSyncedDoor((class_1937)InfinityDimHelper.getInfinityDimension(), personalDim.getPlayerPos());
        }
    }

    private class_2750 getHinge(class_1750 ctx) {
        boolean bl2;
        class_1937 blockView = ctx.method_8045();
        class_2338 blockPos = ctx.method_8037();
        class_2350 direction = ctx.method_8042();
        class_2338 blockPos2 = blockPos.method_10084();
        class_2350 direction2 = direction.method_10160();
        class_2338 blockPos3 = blockPos.method_10093(direction2);
        class_2680 blockState = blockView.method_8320(blockPos3);
        class_2338 blockPos4 = blockPos2.method_10093(direction2);
        class_2680 blockState2 = blockView.method_8320(blockPos4);
        class_2350 direction3 = direction.method_10170();
        class_2338 blockPos5 = blockPos.method_10093(direction3);
        class_2680 blockState3 = blockView.method_8320(blockPos5);
        class_2338 blockPos6 = blockPos2.method_10093(direction3);
        class_2680 blockState4 = blockView.method_8320(blockPos6);
        int i = (blockState.method_26234((class_1922)blockView, blockPos3) ? -1 : 0) + (blockState2.method_26234((class_1922)blockView, blockPos4) ? -1 : 0) + (blockState3.method_26234((class_1922)blockView, blockPos5) ? 1 : 0) + (blockState4.method_26234((class_1922)blockView, blockPos6) ? 1 : 0);
        boolean bl = blockState.method_26204() == this && blockState.method_11654(HALF) == class_2756.field_12607;
        boolean bl3 = bl2 = blockState3.method_26204() == this && blockState3.method_11654(HALF) == class_2756.field_12607;
        if ((!bl || bl2) && i <= 0) {
            if ((!bl2 || bl) && i >= 0) {
                int j = direction.method_10148();
                int k = direction.method_10165();
                class_243 vec3d = ctx.method_17698();
                double d = vec3d.field_1352 - (double)blockPos.method_10263();
                double e = vec3d.field_1350 - (double)blockPos.method_10260();
                return !(j < 0 && !(e >= 0.5) || j > 0 && !(e <= 0.5) || k < 0 && !(d <= 0.5) || k > 0 && !(d >= 0.5)) ? class_2750.field_12588 : class_2750.field_12586;
            }
            return class_2750.field_12588;
        }
        return class_2750.field_12586;
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        state = (class_2680)state.method_28493((class_2769)OPEN);
        world.method_8652(pos, state, 10);
        world.method_8444(player, (Boolean)state.method_11654((class_2769)OPEN) != false ? this.getCloseSoundEventId() : this.getOpenSoundEventId(), pos, 0);
        if (!world.field_9236) {
            class_2338 lowerPos = state.method_11654(HALF) == class_2756.field_12607 ? pos : pos.method_10074();
            InfinityDoorBlockEntity blockEntity = (InfinityDoorBlockEntity)world.method_8321(lowerPos);
            blockEntity.updateSyncDoor();
        }
        return class_1269.field_5812;
    }

    public void setOpen(class_1937 world, class_2338 pos, boolean open) {
        class_2680 blockState = world.method_8320(pos);
        if ((Boolean)blockState.method_11654((class_2769)OPEN) != open) {
            world.method_8652(pos, (class_2680)blockState.method_11657((class_2769)OPEN, (Comparable)Boolean.valueOf(open)), 10);
            this.playOpenCloseSound(world, pos, open);
        }
    }

    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 block, class_2338 neighborPos, boolean moved) {
        pos = state.method_11654(HALF) == class_2756.field_12607 ? pos : pos.method_10074();
        state = world.method_8320(pos);
        InfinityDoorBlockEntity blockEntity = (InfinityDoorBlockEntity)world.method_8321(pos);
        if (!state.method_26215() && !this.method_9558(state, (class_4538)world, pos)) {
            blockEntity.deleteLocalPortal();
            world.method_8652(pos.method_10084(), class_2246.field_10124.method_9564(), 35);
            world.method_22352(pos, true);
        }
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        if (!DOFConfig.getInstance().requireDoorBorder) {
            class_2338 blockPos = pos.method_10074();
            class_2680 blockState = world.method_8320(blockPos);
            if (state.method_11654(HALF) == class_2756.field_12607) {
                return blockState.method_26206((class_1922)world, blockPos, class_2350.field_11036);
            }
            return blockState.method_26204() == this;
        }
        pos = state.method_11654(HALF) == class_2756.field_12607 ? pos : pos.method_10074();
        return this.topAndBottomMatch(pos, world) && (this.sideMatches(pos, world, class_2350.field_11043) && this.sideMatches(pos, world, class_2350.field_11035) || this.sideMatches(pos, world, class_2350.field_11034) && this.sideMatches(pos, world, class_2350.field_11039));
    }

    private boolean topAndBottomMatch(class_2338 pos, class_4538 world) {
        Predicate<class_2248> matchingBlocks = block -> block == DOFBlocks.INFINITY_BLOCK || block == DOFBlocks.GENERATED_INFINITY_BLOCK;
        return matchingBlocks.test(world.method_8320(pos.method_10074()).method_26204()) && matchingBlocks.test(world.method_8320(pos.method_10086(2)).method_26204());
    }

    private boolean sideMatches(class_2338 pos, class_4538 world, class_2350 d) {
        Predicate<class_2248> matchingBlocks = block -> block == DOFBlocks.INFINITY_BLOCK || block == DOFBlocks.GENERATED_INFINITY_BLOCK;
        class_2338 sidePos = pos.method_10081(d.method_10163());
        return matchingBlocks.test(world.method_8320(sidePos).method_26204()) && matchingBlocks.test(world.method_8320(sidePos.method_10084()).method_26204());
    }

    private void playOpenCloseSound(class_1937 world, class_2338 pos, boolean open) {
        world.method_8444((class_1657)null, open ? this.getCloseSoundEventId() : this.getOpenSoundEventId(), pos, 0);
    }

    public class_3619 method_9527(class_2680 state) {
        return class_3619.field_15972;
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657((class_2769)FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)FACING)));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return mirror == class_2415.field_11302 ? state : (class_2680)state.method_26186(mirror.method_10345((class_2350)state.method_11654((class_2769)FACING))).method_28493(HINGE);
    }

    @Environment(value=EnvType.CLIENT)
    public long method_9535(class_2680 state, class_2338 pos) {
        return class_3532.method_15371((int)pos.method_10263(), (int)pos.method_10087(state.method_11654(HALF) == class_2756.field_12607 ? 0 : 1).method_10264(), (int)pos.method_10260());
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{HALF, FACING, OPEN, HINGE});
    }

    public class_2586 method_10123(class_1922 view) {
        return new InfinityDoorBlockEntity();
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }
}

