/*
 * Decompiled with CFR 0.152.
 */
package me.benfah.doorsofinfinity.block.entity.renderer;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Random;
import java.util.stream.IntStream;
import me.benfah.doorsofinfinity.block.InfinityDoorBlock;
import me.benfah.doorsofinfinity.block.entity.InfinityDoorBlockEntity;
import me.benfah.doorsofinfinity.utils.MCUtils;
import net.minecraft.class_1158;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2588;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4668;
import net.minecraft.class_824;
import net.minecraft.class_827;

public class InfinityDoorBlockEntityRenderer
extends class_827<InfinityDoorBlockEntity> {
    private static Random RANDOM = (Random)class_156.method_654((Object)new Random(), r -> r.setSeed(31100L));
    private static final List<class_1921> field_21732 = (List)IntStream.range(0, 16).mapToObj(i -> class_1921.method_23574((int)(i + 1))).collect(ImmutableList.toImmutableList());
    private class_310 client = class_310.method_1551();

    public InfinityDoorBlockEntityRenderer(class_824 dispatcher) {
        super(dispatcher);
    }

    public static class_1921 getOwnRenderLayer() {
        class_1921.class_4688 params = class_1921.class_4688.method_23598().method_23615(new class_4668.class_4685("translucent_transparency", () -> {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
        }, () -> RenderSystem.disableBlend())).method_23617(true);
        return class_1921.method_24049((String)"colored_upgrade", (class_293)class_290.field_1576, (int)7, (int)256, (boolean)false, (boolean)true, (class_1921.class_4688)params);
    }

    public void render(InfinityDoorBlockEntity entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        class_3965 blockHitResult;
        class_2350 direction = (class_2350)entity.method_11010().method_11654((class_2769)InfinityDoorBlock.FACING);
        if (!MCUtils.isIPPresent()) {
            this.drawEndTexture(entity, tickDelta, matrices, vertexConsumers, direction);
        }
        class_239 rayTrace = this.client.field_1724.method_5745((double)this.client.field_1761.method_2904(), tickDelta, false);
        if (this.client.field_1724.method_5715() && entity.method_11010().method_11654(InfinityDoorBlock.HALF) == class_2756.field_12607 && ((blockHitResult = (class_3965)rayTrace).method_17777().equals((Object)entity.method_11016()) || blockHitResult.method_17777().equals((Object)entity.method_11016().method_10084()))) {
            matrices.method_22903();
            InfinityDoorBlockEntityRenderer.transformToFace(matrices, direction);
            matrices.method_22904(0.5, 1.9, -0.001);
            matrices.method_22907(class_1160.field_20707.method_23214(180.0f));
            matrices.method_22905(0.01f, 0.01f, 1.0f);
            this.drawCenteredTextWithRect(new class_2588("text.doorsofinfinity.installed_upgrades", new Object[]{entity.installedUpgrades}).getString(), 0, 0xFFFFFF, false, matrices, vertexConsumers, false, 0xFFFFFF, light, 0.168f, 0.341f, 0.156f, 0.5f);
            matrices.method_22909();
        }
    }

    public static void drawRect(class_4597 vertexConsumerProvider, class_1159 matrix, int x1, int y1, int x2, int y2, float r, float g, float b, float a) {
        class_4588 consumer = vertexConsumerProvider.getBuffer(InfinityDoorBlockEntityRenderer.getOwnRenderLayer());
        consumer.method_22918(matrix, (float)x1, (float)y2, 0.0f).method_22915(r, g, b, a).method_1344();
        consumer.method_22918(matrix, (float)x2, (float)y2, 0.0f).method_22915(r, g, b, a).method_1344();
        consumer.method_22918(matrix, (float)x2, (float)y1, 0.0f).method_22915(r, g, b, a).method_1344();
        consumer.method_22918(matrix, (float)x1, (float)y1, 0.0f).method_22915(r, g, b, a).method_1344();
    }

    public static void transformToFace(class_4587 stack, class_2350 direction) {
        stack.method_22904(0.5, 0.0, 0.5);
        class_1158 rotationQuaternion = direction.method_23224();
        rotationQuaternion.method_4925(class_1160.field_20703.method_23214(-90.0f));
        stack.method_22907(rotationQuaternion);
        stack.method_22904(-0.5, 0.0, -0.5);
    }

    public void drawRightBoundText(String text, int x, int y, int color, boolean shadow, class_1159 matrix, class_4597 vertexConsumers, boolean seeThrough, int backgroundColor, int light) {
        int textLength = this.field_20989.method_3556().method_1727(text);
        this.field_20989.method_3556().method_27521(text, (float)(x - textLength), (float)y, color, shadow, matrix, vertexConsumers, seeThrough, backgroundColor, light);
    }

    public void drawCenteredText(String text, int y, int color, boolean shadow, class_1159 matrix, class_4597 vertexConsumers, boolean seeThrough, int backgroundColor, int light) {
        int textLength = this.field_20989.method_3556().method_1727(text);
        this.field_20989.method_3556().method_27521(text, (float)(-textLength / 2), (float)y, color, shadow, matrix, vertexConsumers, seeThrough, backgroundColor, light);
    }

    public void drawCenteredTextWithRect(String text, int y, int color, boolean shadow, class_4587 matrices, class_4597 vertexConsumers, boolean seeThrough, int backgroundColor, int light, float r, float g, float b, float a) {
        int textLength = this.field_20989.method_3556().method_1727(text);
        int border = 4;
        class_1159 class_11592 = matrices.method_23760().method_23761();
        int n = -textLength / 2 - border;
        int n2 = textLength / 2 + border;
        this.field_20989.method_3556().getClass();
        InfinityDoorBlockEntityRenderer.drawRect(vertexConsumers, class_11592, n, y - 2, n2, y + 9 + 2, r, g, b, a);
        matrices.method_22903();
        matrices.method_22904(0.0, 0.0, -0.001);
        this.drawCenteredText(text, y, color, shadow, matrices.method_23760().method_23761(), vertexConsumers, seeThrough, backgroundColor, light);
        matrices.method_22909();
    }

    public void drawRightBoundTextWithRect(String text, int x, int y, int color, boolean shadow, class_1159 matrix, class_4597 vertexConsumers, boolean seeThrough, int backgroundColor, int light, float r, float g, float b, float a) {
        int border = 4;
        int textLength = this.field_20989.method_3556().method_1727(text);
        this.field_20989.method_3556().getClass();
        InfinityDoorBlockEntityRenderer.drawRect(vertexConsumers, matrix, x - textLength - border * 2, y - 2, x, y + 9 + 2, r, g, b, a);
        this.drawRightBoundText(text, x - border, y, color, shadow, matrix, vertexConsumers, seeThrough, backgroundColor, light);
    }

    public void drawEndTexture(InfinityDoorBlockEntity endPortalBlockEntity, float f, class_4587 matrixStack, class_4597 vertexConsumerProvider, class_2350 direction) {
        matrixStack.method_22903();
        matrixStack.method_22904((double)direction.method_10163().method_10263() * 0.1, 0.0, (double)direction.method_10163().method_10260() * 0.1);
        RANDOM.setSeed(31100L);
        class_1159 matrix4f = matrixStack.method_23760().method_23761();
        this.drawEndLayer(endPortalBlockEntity, 0.15f, matrix4f, vertexConsumerProvider.getBuffer(field_21732.get(0)));
        for (int l = 1; l < 16; ++l) {
            this.drawEndLayer(endPortalBlockEntity, 2.0f / (float)(18 - l), matrix4f, vertexConsumerProvider.getBuffer(field_21732.get(l)));
        }
        matrixStack.method_22909();
    }

    private void drawEndLayer(InfinityDoorBlockEntity endPortalBlockEntity, float g, class_1159 matrix4f, class_4588 vertexConsumer) {
        float h = (RANDOM.nextFloat() * 0.5f + 0.1f) * g;
        float i = (RANDOM.nextFloat() * 0.5f + 0.4f) * g;
        float j = (RANDOM.nextFloat() * 0.5f + 0.5f) * g;
        this.drawEndLayerFace(endPortalBlockEntity, matrix4f, vertexConsumer, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, h, i, j, class_2350.field_11035);
        this.drawEndLayerFace(endPortalBlockEntity, matrix4f, vertexConsumer, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, h, i, j, class_2350.field_11043);
        this.drawEndLayerFace(endPortalBlockEntity, matrix4f, vertexConsumer, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, h, i, j, class_2350.field_11034);
        this.drawEndLayerFace(endPortalBlockEntity, matrix4f, vertexConsumer, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, h, i, j, class_2350.field_11039);
        this.drawEndLayerFace(endPortalBlockEntity, matrix4f, vertexConsumer, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, h, i, j, class_2350.field_11033);
    }

    private void drawEndLayerFace(InfinityDoorBlockEntity endPortalBlockEntity, class_1159 matrix4f, class_4588 vertexConsumer, float f, float g, float h, float i, float j, float k, float l, float m, float n, float o, float p, class_2350 direction) {
        if (direction == ((class_2350)endPortalBlockEntity.method_11010().method_11654((class_2769)InfinityDoorBlock.FACING)).method_10153()) {
            vertexConsumer.method_22918(matrix4f, f, h, j).method_22915(n, o, p, 1.0f).method_1344();
            vertexConsumer.method_22918(matrix4f, g, h, k).method_22915(n, o, p, 1.0f).method_1344();
            vertexConsumer.method_22918(matrix4f, g, i, l).method_22915(n, o, p, 1.0f).method_1344();
            vertexConsumer.method_22918(matrix4f, f, i, m).method_22915(n, o, p, 1.0f).method_1344();
        }
    }

    protected int getLayersToRender(double d) {
        if (d > 36864.0) {
            return 1;
        }
        if (d > 25600.0) {
            return 3;
        }
        if (d > 16384.0) {
            return 5;
        }
        if (d > 9216.0) {
            return 7;
        }
        if (d > 4096.0) {
            return 9;
        }
        if (d > 1024.0) {
            return 11;
        }
        if (d > 576.0) {
            return 13;
        }
        return d > 256.0 ? 14 : 15;
    }
}

