/*
 * Decompiled with CFR 0.152.
 */
package net.adventurez.entity.nonliving;

import java.util.UUID;
import net.adventurez.init.EntityInit;
import net.adventurez.network.EntitySpawnPacket;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1267;
import net.minecraft.class_1282;
import net.minecraft.class_1285;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1317;
import net.minecraft.class_1657;
import net.minecraft.class_1667;
import net.minecraft.class_1668;
import net.minecraft.class_1675;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1948;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4538;
import org.jetbrains.annotations.Nullable;

public class TinyEyeEntity
extends class_1668 {
    private class_1297 target;
    @Nullable
    private class_2350 direction;
    private int stepCount;
    private double targetX;
    private double targetY;
    private double targetZ;
    @Nullable
    private UUID targetUuid;

    public TinyEyeEntity(class_1299<? extends TinyEyeEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Environment(value=EnvType.CLIENT)
    public TinyEyeEntity(class_1937 world, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
        this(EntityInit.TINYEYE_ENTITY, world);
        this.method_5808(x, y, z, this.field_6031, this.field_5965);
        this.method_18800(velocityX, velocityY, velocityZ);
    }

    public TinyEyeEntity(class_1937 world, class_1309 owner, class_1297 target, class_2350.class_2351 axis) {
        this(EntityInit.TINYEYE_ENTITY, world);
        this.method_7432((class_1297)owner);
        class_2338 blockPos = owner.method_24515();
        double d = (double)blockPos.method_10263() + 0.5;
        double e = (double)blockPos.method_10264() + 0.5;
        double f = (double)blockPos.method_10260() + 0.5;
        this.method_5808(d, e, f, this.field_6031, this.field_5965);
        this.target = target;
        this.direction = class_2350.field_11036;
        this.movingAround();
    }

    public class_3419 method_5634() {
        return class_3419.field_15251;
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        if (this.target != null) {
            tag.method_25927("Target", this.target.method_5667());
        }
        if (this.direction != null) {
            tag.method_10569("Dir", this.direction.method_10146());
        }
        tag.method_10569("Steps", this.stepCount);
        tag.method_10549("TXD", this.targetX);
        tag.method_10549("TYD", this.targetY);
        tag.method_10549("TZD", this.targetZ);
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.stepCount = tag.method_10550("Steps");
        this.targetX = tag.method_10574("TXD");
        this.targetY = tag.method_10574("TYD");
        this.targetZ = tag.method_10574("TZD");
        if (tag.method_10573("Dir", 99)) {
            this.direction = class_2350.method_10143((int)tag.method_10550("Dir"));
        }
        if (tag.method_25928("Target")) {
            this.targetUuid = tag.method_25926("Target");
        }
    }

    protected void method_5693() {
    }

    private void movingAround() {
        class_2338 blockPos2;
        double d = 0.5;
        if (this.target == null) {
            blockPos2 = this.method_24515().method_10074();
        } else {
            d = (double)this.target.method_17682() * 0.5;
            blockPos2 = new class_2338(this.target.method_23317(), this.target.method_23318() + d, this.target.method_23321());
        }
        double e = (double)blockPos2.method_10263() + 0.5;
        double f = (double)blockPos2.method_10264() + d;
        double g = (double)blockPos2.method_10260() + 0.5;
        double h = e - this.method_23317();
        double j = f - this.method_23318();
        double k = g - this.method_23321();
        double l = class_3532.method_15368((double)(h * h + j * j + k * k));
        if (l == 0.0) {
            this.targetX = 0.0;
            this.targetY = 0.0;
            this.targetZ = 0.0;
        } else {
            this.targetX = h / l * 0.15;
            this.targetY = j / l * 0.15;
            this.targetZ = k / l * 0.15;
        }
        this.field_6007 = true;
        this.stepCount = 10 + this.field_5974.nextInt(5) * 10;
    }

    public void method_5982() {
        if (this.field_6002.method_8407() == class_1267.field_5801) {
            this.method_5650();
        }
    }

    public void method_5773() {
        class_243 vec3d;
        if (!this.field_6002.field_9236) {
            class_239 hitResult;
            if (this.target == null && this.targetUuid != null) {
                this.target = ((class_3218)this.field_6002).method_14190(this.targetUuid);
                if (this.target == null) {
                    this.targetUuid = null;
                }
            }
            if (this.target == null || !this.target.method_5805() || this.target instanceof class_1657 && ((class_1657)this.target).method_7325()) {
                if (!this.method_5740()) {
                    this.method_18799(this.method_18798().method_1031(0.0, -0.04, 0.0));
                }
            } else {
                this.targetX = class_3532.method_15350((double)(this.targetX * 1.025), (double)-1.0, (double)1.0);
                this.targetY = class_3532.method_15350((double)(this.targetY * 1.025), (double)-1.0, (double)1.0);
                this.targetZ = class_3532.method_15350((double)(this.targetZ * 1.025), (double)-1.0, (double)1.0);
                vec3d = this.method_18798();
                this.method_18799(vec3d.method_1031((this.targetX - vec3d.field_1352) * 0.2, (this.targetY - vec3d.field_1351) * 0.2, (this.targetZ - vec3d.field_1350) * 0.2));
            }
            if ((hitResult = class_1675.method_18074((class_1297)this, this::method_26958)).method_17783() != class_239.class_240.field_1333) {
                this.method_7488(hitResult);
            }
        }
        this.method_5852();
        vec3d = this.method_18798();
        this.method_5814(this.method_23317() + vec3d.field_1352, this.method_23318() + vec3d.field_1351, this.method_23321() + vec3d.field_1350);
        class_1675.method_7484((class_1297)this, (float)0.5f);
        if (!this.field_6002.field_9236 && this.target != null && !this.target.field_5988) {
            if (this.stepCount > 0) {
                --this.stepCount;
                if (this.stepCount == 0) {
                    this.movingAround();
                }
            }
            if (this.direction != null) {
                class_2338 blockPos = this.method_24515();
                class_2350.class_2351 axis = this.direction.method_10166();
                if (this.field_6002.method_8515(blockPos.method_10093(this.direction), (class_1297)this)) {
                    this.movingAround();
                } else {
                    class_2338 blockPos2 = this.target.method_24515();
                    if (axis == class_2350.class_2351.field_11048 && blockPos.method_10263() == blockPos2.method_10263() || axis == class_2350.class_2351.field_11051 && blockPos.method_10260() == blockPos2.method_10260() || axis == class_2350.class_2351.field_11052 && blockPos.method_10264() == blockPos2.method_10264()) {
                        this.movingAround();
                    }
                }
            }
        }
    }

    public boolean method_26958(class_1297 entity) {
        return super.method_26958(entity) && !entity.field_5960;
    }

    public boolean method_5809() {
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    public boolean method_5640(double distance) {
        return distance < 16384.0;
    }

    public float method_5718() {
        return 1.0f;
    }

    public void method_7454(class_3966 entityHitResult) {
        super.method_7454(entityHitResult);
        class_1297 entity = this.method_24921();
        class_1297 hittedEntity = entityHitResult.method_17782();
        if (!this.field_6002.field_9236 && entity != null && hittedEntity != entity && !(hittedEntity instanceof TinyEyeEntity) || hittedEntity instanceof class_1667) {
            this.method_5783(class_3417.field_15210, 1.0f, 1.0f);
            if (hittedEntity instanceof class_1309) {
                this.teleportEntityRandom((class_1309)hittedEntity);
                hittedEntity.method_5643(TinyEyeEntity.createDamageSource((class_1297)this), 1.0f);
            }
            this.method_5650();
        }
    }

    public static class_1282 createDamageSource(class_1297 entity) {
        return new class_1285("tinyEye", entity).method_5517();
    }

    private void teleportEntityRandom(class_1309 livingEntity) {
        for (int counter = 0; counter < 100; ++counter) {
            int posZ;
            int posY;
            float randomFloat = this.field_6002.method_8409().nextFloat() * ((float)Math.PI * 2);
            int posX = livingEntity.method_24515().method_10263() + class_3532.method_15375((float)(class_3532.method_15362((float)randomFloat) * 9.0f + (float)livingEntity.field_6002.method_8409().nextInt(30)));
            class_2338 teleportPos = new class_2338(posX, posY = livingEntity.field_6002.method_8624(class_2902.class_2903.field_13202, posX, posZ = livingEntity.method_24515().method_10260() + class_3532.method_15375((float)(class_3532.method_15374((float)randomFloat) * 9.0f + (float)livingEntity.field_6002.method_8409().nextInt(30)))), posZ);
            if (!livingEntity.field_6002.method_22341(teleportPos.method_10263() - 4, teleportPos.method_10264() - 4, teleportPos.method_10260() - 4, teleportPos.method_10263() + 4, teleportPos.method_10264() + 4, teleportPos.method_10260() + 4) || !livingEntity.field_6002.method_8398().method_20591(new class_1923(teleportPos)) || !class_1948.method_8660((class_1317.class_1319)class_1317.class_1319.field_6317, (class_4538)livingEntity.field_6002, (class_2338)teleportPos, (class_1299)class_1299.field_6097)) continue;
            if (!this.field_6002.field_9236) {
                livingEntity.method_20620((double)teleportPos.method_10263(), (double)teleportPos.method_10264(), (double)teleportPos.method_10260());
            }
            livingEntity.field_6002.method_8396(null, teleportPos, class_3417.field_14879, class_3419.field_15251, 1.0f, 1.0f);
            break;
        }
    }

    public void method_24920(class_3965 blockHitResult) {
        super.method_24920(blockHitResult);
        this.method_5783(class_3417.field_15210, 1.0f, 1.0f);
        this.method_5650();
    }

    public void method_7488(class_239 hitResult) {
        super.method_7488(hitResult);
    }

    public boolean method_5863() {
        return true;
    }

    public class_2596<?> method_18002() {
        return EntitySpawnPacket.createPacket((class_1297)this);
    }
}

