/*
 * Decompiled with CFR 0.152.
 */
package supercoder79.cavebiomes.command;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.imageio.ImageIO;
import net.fabricmc.fabric.api.command.v1.CommandRegistrationCallback;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import supercoder79.cavebiomes.world.noise.OpenSimplexNoise;

public class MapOreNodulesCommand {
    public static void init() {
        CommandRegistrationCallback.EVENT.register((dispatcher, dedicated) -> {
            LiteralArgumentBuilder builder = (LiteralArgumentBuilder)class_2170.method_9247((String)"maporenodules").requires(source -> source.method_9259(2));
            builder.executes(context -> MapOreNodulesCommand.execute((class_2168)context.getSource()));
            dispatcher.register(builder);
        });
    }

    private static int execute(class_2168 source) {
        BufferedImage img = new BufferedImage(1024, 1024, 1);
        class_3218 world = source.method_9225();
        OpenSimplexNoise noise = new OpenSimplexNoise(world.method_8412() + 443L);
        OpenSimplexNoise oreNoise = new OpenSimplexNoise(world.method_8412() - 321L);
        for (int x = -512; x < 512; ++x) {
            if (x % 128 == 0) {
                source.method_9226((class_2561)new class_2585((double)(x + 512) / 1024.0 * 100.0 + "%"), false);
            }
            for (int z = -512; z < 512; ++z) {
                boolean generating = false;
                double oreSelector = -1.0;
                int maxY = 64;
                for (int y = 0; y < maxY; ++y) {
                    double noiseAt = noise.sample((double)x / 24.0, (double)y / 24.0, (double)z / 24.0);
                    noiseAt += Math.max(8.5 / (double)y - 1.0, 0.0);
                    if (!((noiseAt += Math.max(5.0 / (double)(maxY - y) - 1.0, 0.0)) < -0.7665)) continue;
                    oreSelector = oreNoise.sample((double)x / 140.0, (double)z / 140.0);
                    generating = true;
                    break;
                }
                if (generating) {
                    int color = oreSelector > 0.0 ? MapOreNodulesCommand.getIntFromColor((int)class_3532.method_16436((double)oreSelector, (double)0.0, (double)0.0), (int)class_3532.method_16436((double)oreSelector, (double)0.0, (double)255.0), (int)class_3532.method_16436((double)oreSelector, (double)255.0, (double)255.0)) : MapOreNodulesCommand.getIntFromColor((int)class_3532.method_16436((double)(-oreSelector), (double)0.0, (double)0.0), (int)class_3532.method_16436((double)(-oreSelector), (double)0.0, (double)255.0), (int)class_3532.method_16436((double)(-oreSelector), (double)255.0, (double)0.0));
                    img.setRGB(x + 512, z + 512, color);
                    continue;
                }
                img.setRGB(x + 512, z + 512, 0x919191);
            }
        }
        Path p = Paths.get("orenodulemap.png", new String[0]);
        try {
            ImageIO.write((RenderedImage)img, "png", p.toAbsolutePath().toFile());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        source.method_9226((class_2561)new class_2585("Mapped ore nodules!"), false);
        return 0;
    }

    private static int getIntFromColor(int red, int green, int blue) {
        red = red << 16 & 0xFF0000;
        green = green << 8 & 0xFF00;
        return 0xFF000000 | red | green | (blue &= 0xFF);
    }
}

