/*
 * Decompiled with CFR 0.152.
 */
package supercoder79.cavebiomes.world.layer;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import supercoder79.cavebiomes.CaveBiomes;
import supercoder79.cavebiomes.api.CaveBiomesAPI;
import supercoder79.cavebiomes.api.CaveDecorator;
import supercoder79.cavebiomes.impl.CaveBiomesImpl;
import supercoder79.cavebiomes.world.layer.CaveLayer;
import supercoder79.cavebiomes.world.layer.LayerDispatcher;
import supercoder79.cavebiomes.world.layer.SamplingCaveLayer;
import supercoder79.cavebiomes.world.layer.ScaleCaveLayer;
import supercoder79.cavebiomes.world.layer.cave.BaseCavesLayer;

public class LayerGenerator {
    private static CaveLayer layer;
    private static long seed;

    public static CaveDecorator getDecorator(long worldSeed, int x, int z) {
        if (layer == null || seed != worldSeed) {
            layer = LayerGenerator.build(worldSeed);
            seed = worldSeed;
        }
        List<CaveDecorator> decorators = CaveBiomesAPI.getCaveDecorators();
        return decorators.get(layer.sample(x, z));
    }

    private static CaveLayer build(long worldSeed) {
        LayerDispatcher dispatcher = new LayerDispatcher();
        List<LayerDispatcher.DispatchFunction> functions = CaveBiomesImpl.getDispatchFunctions();
        for (LayerDispatcher.DispatchFunction function : functions) {
            function.apply(dispatcher, worldSeed);
        }
        Map<Integer, List<SamplingCaveLayer>> layers = dispatcher.getLayers();
        CaveLayer factory = new BaseCavesLayer(worldSeed, 100);
        for (SamplingCaveLayer layer : (List)layers.getOrDefault(-1, new ArrayList())) {
            layer.setParent(factory);
            factory = layer;
        }
        for (int i = 0; i < CaveBiomes.CONFIG.caveBiomeSize; ++i) {
            factory = new ScaleCaveLayer(worldSeed, 10 + i, factory);
            for (SamplingCaveLayer layer : (List)layers.getOrDefault(i, new ArrayList())) {
                layer.setParent(factory);
                factory = layer;
            }
        }
        return factory;
    }
}

