/*
 * Decompiled with CFR 0.152.
 */
package supercoder79.cavebiomes.world.layer;

import supercoder79.cavebiomes.util.LayerRandom;
import supercoder79.cavebiomes.world.layer.CaveLayer;

public abstract class SamplingCaveLayer
extends CaveLayer {
    protected CaveLayer parent = null;

    public SamplingCaveLayer(long worldSeed, int salt) {
        super(worldSeed, salt);
    }

    public SamplingCaveLayer setParent(CaveLayer parent) {
        if (this.parent != null) {
            throw new IllegalStateException("Cannot modify existing parent!");
        }
        this.parent = parent;
        return this;
    }

    @Override
    protected int operate(LayerRandom random, int x, int z) {
        throw new UnsupportedOperationException("Call the correct operate method!");
    }

    @Override
    protected CaveLayer.Cache initializeCache() {
        return new SamplingCache(512);
    }

    protected abstract int operate(LayerRandom var1, int var2, int var3, int var4);

    private class SamplingCache
    extends CaveLayer.Cache {
        private SamplingCache(int size) {
            super(size);
        }

        @Override
        protected int getValueForSample(int x, int z) {
            LayerRandom random = new LayerRandom(SamplingCaveLayer.this.worldSeed);
            random.setPosSeed(x, z, SamplingCaveLayer.this.salt);
            int parentSample = SamplingCaveLayer.this.parent.sample(x, z);
            return SamplingCaveLayer.this.operate(random, x, z, parentSample);
        }
    }
}

