/*
 * Decompiled with CFR 0.152.
 */
package ru.bclib.api;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.impl.biome.InternalBiomeData;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_5458;
import net.minecraft.server.MinecraftServer;
import ru.bclib.util.MHelper;
import ru.bclib.world.biomes.BCLBiome;

public class BiomeAPI {
    public static final BCLBiome EMPTY_BIOME = new BCLBiome(class_1972.field_9473.method_29177(), (class_1959)class_5458.field_25933.method_29107(class_1972.field_9473), 1.0f, 0.0f);
    private static final HashMap<class_2960, BCLBiome> ID_MAP = Maps.newHashMap();
    private static final HashMap<class_1959, BCLBiome> CLIENT = Maps.newHashMap();
    private static class_2378<class_1959> biomeRegistry;

    public static void initRegistry(MinecraftServer server) {
        biomeRegistry = server.method_30611().method_30530(class_2378.field_25114);
        CLIENT.clear();
    }

    public static void registerBiome(BCLBiome biome) {
        if (class_5458.field_25933.method_10223(biome.getID()) == null) {
            class_2378.method_10230((class_2378)class_5458.field_25933, (class_2960)biome.getID(), (Object)biome.getBiome());
        }
        ID_MAP.put(biome.getID(), biome);
    }

    public static void addNetherBiomeToFabricApi(BCLBiome biome) {
        class_5321 key = (class_5321)class_5458.field_25933.method_29113((Object)biome.getBiome()).get();
        Random random = new Random(biome.getID().toString().hashCode());
        class_1959.class_4762 parameters = new class_1959.class_4762(MHelper.randRange(-2.0f, 2.0f, random), MHelper.randRange(-2.0f, 2.0f, random), MHelper.randRange(-2.0f, 2.0f, random), MHelper.randRange(-2.0f, 2.0f, random), MHelper.randRange(-2.0f, 2.0f, random));
        InternalBiomeData.addNetherBiome((class_5321)key, (class_1959.class_4762)parameters);
    }

    public static void addEndLandBiomeToFabricApi(BCLBiome biome) {
        float weight = biome.getGenChance();
        class_5321 key = (class_5321)class_5458.field_25933.method_29113((Object)biome.getBiome()).get();
        InternalBiomeData.addEndBiomeReplacement((class_5321)class_1972.field_9442, (class_5321)key, (double)weight);
        InternalBiomeData.addEndBiomeReplacement((class_5321)class_1972.field_9447, (class_5321)key, (double)weight);
    }

    public static void addEndVoidBiomeToFabricApi(BCLBiome biome) {
        float weight = biome.getGenChance();
        class_5321 key = (class_5321)class_5458.field_25933.method_29113((Object)biome.getBiome()).get();
        InternalBiomeData.addEndBiomeReplacement((class_5321)class_1972.field_9457, (class_5321)key, (double)weight);
    }

    public static BCLBiome getFromBiome(class_1959 biome) {
        if (biomeRegistry == null) {
            return EMPTY_BIOME;
        }
        return ID_MAP.getOrDefault(biomeRegistry.method_10221((Object)biome), EMPTY_BIOME);
    }

    @Environment(value=EnvType.CLIENT)
    public static BCLBiome getRenderBiome(class_1959 biome) {
        BCLBiome endBiome = CLIENT.get(biome);
        if (endBiome == null) {
            class_310 minecraft = class_310.method_1551();
            class_2960 id = minecraft.field_1687.method_30349().method_30530(class_2378.field_25114).method_10221((Object)biome);
            endBiome = id == null ? EMPTY_BIOME : ID_MAP.getOrDefault(id, EMPTY_BIOME);
            CLIENT.put(biome, endBiome);
        }
        return endBiome;
    }

    public static class_2960 getBiomeID(class_1959 biome) {
        class_2960 id = biomeRegistry.method_10221((Object)biome);
        return id == null ? EMPTY_BIOME.getID() : id;
    }

    public static BCLBiome getBiome(class_2960 biomeID) {
        return ID_MAP.getOrDefault(biomeID, EMPTY_BIOME);
    }

    public static class_1959 getActualBiome(BCLBiome biome) {
        class_1959 actual = biome.getActualBiome();
        if (actual == null) {
            biome.updateActualBiomes(biomeRegistry);
            actual = biome.getActualBiome();
        }
        return actual;
    }

    public static boolean hasBiome(class_2960 biomeID) {
        return ID_MAP.containsKey(biomeID);
    }
}

