/*
 * Decompiled with CFR 0.152.
 */
package ru.bclib.config;

import org.jetbrains.annotations.Nullable;
import ru.bclib.BCLib;
import ru.bclib.config.ConfigKeeper;
import ru.bclib.config.ConfigKey;

public abstract class Config {
    protected final ConfigKeeper keeper;

    protected abstract void registerEntries();

    public Config(String modID, String group) {
        this.keeper = new ConfigKeeper(modID, group);
        this.registerEntries();
    }

    public void saveChanges() {
        this.keeper.save();
    }

    @Nullable
    public <T, E extends ConfigKeeper.Entry<T>> E getEntry(ConfigKey key, Class<E> type) {
        return this.keeper.getEntry(key, type);
    }

    @Nullable
    public <T, E extends ConfigKeeper.Entry<T>> T getDefault(ConfigKey key, Class<E> type) {
        E entry = this.keeper.getEntry(key, type);
        return entry != null ? (T)((ConfigKeeper.Entry)entry).getDefault() : null;
    }

    protected String getString(ConfigKey key, String defaultValue) {
        String str = (String)this.keeper.getValue(key, ConfigKeeper.StringEntry.class);
        if (str == null) {
            ConfigKeeper.StringEntry entry = this.keeper.registerEntry(key, new ConfigKeeper.StringEntry(defaultValue));
            return (String)entry.getValue();
        }
        return str != null ? str : defaultValue;
    }

    protected String getString(ConfigKey key) {
        String str = (String)this.keeper.getValue(key, ConfigKeeper.StringEntry.class);
        return str != null ? str : "";
    }

    protected boolean setString(ConfigKey key, String value) {
        try {
            ConfigKeeper.StringEntry entry = this.keeper.getEntry(key, ConfigKeeper.StringEntry.class);
            if (entry == null) {
                return false;
            }
            entry.setValue(value);
            return true;
        }
        catch (NullPointerException ex) {
            BCLib.LOGGER.catching(ex);
            return false;
        }
    }

    protected int getInt(ConfigKey key, int defaultValue) {
        Integer val = (Integer)this.keeper.getValue(key, ConfigKeeper.IntegerEntry.class);
        if (val == null) {
            ConfigKeeper.IntegerEntry entry = this.keeper.registerEntry(key, new ConfigKeeper.IntegerEntry(defaultValue));
            return (Integer)entry.getValue();
        }
        return val != null ? val : defaultValue;
    }

    protected int getInt(ConfigKey key) {
        Integer val = (Integer)this.keeper.getValue(key, ConfigKeeper.IntegerEntry.class);
        return val != null ? val : 0;
    }

    protected boolean setInt(ConfigKey key, int value) {
        try {
            ConfigKeeper.IntegerEntry entry = this.keeper.getEntry(key, ConfigKeeper.IntegerEntry.class);
            if (entry == null) {
                return false;
            }
            entry.setValue(value);
            return true;
        }
        catch (NullPointerException ex) {
            BCLib.LOGGER.catching(ex);
            return false;
        }
    }

    protected <T extends Comparable<T>, RE extends ConfigKeeper.RangeEntry<T>> boolean setRanged(ConfigKey key, T value, Class<RE> type) {
        try {
            ConfigKeeper.RangeEntry entry = (ConfigKeeper.RangeEntry)this.keeper.getEntry(key, type);
            if (entry == null) {
                return false;
            }
            entry.setValue(value);
            return true;
        }
        catch (ClassCastException | NullPointerException ex) {
            BCLib.LOGGER.catching(ex);
            return false;
        }
    }

    protected float getFloat(ConfigKey key, float defaultValue) {
        Float val = (Float)this.keeper.getValue(key, ConfigKeeper.FloatEntry.class);
        if (val == null) {
            ConfigKeeper.FloatEntry entry = this.keeper.registerEntry(key, new ConfigKeeper.FloatEntry(Float.valueOf(defaultValue)));
            return ((Float)entry.getValue()).floatValue();
        }
        return val.floatValue();
    }

    protected float getFloat(ConfigKey key) {
        Float val = (Float)this.keeper.getValue(key, ConfigKeeper.FloatEntry.class);
        return val != null ? val.floatValue() : 0.0f;
    }

    protected boolean setFloat(ConfigKey key, float value) {
        try {
            ConfigKeeper.FloatEntry entry = this.keeper.getEntry(key, ConfigKeeper.FloatEntry.class);
            if (entry == null) {
                return false;
            }
            entry.setValue(Float.valueOf(value));
            return true;
        }
        catch (NullPointerException ex) {
            BCLib.LOGGER.catching(ex);
            return false;
        }
    }

    protected boolean getBoolean(ConfigKey key, boolean defaultValue) {
        Boolean val = (Boolean)this.keeper.getValue(key, ConfigKeeper.BooleanEntry.class);
        if (val == null) {
            ConfigKeeper.BooleanEntry entry = this.keeper.registerEntry(key, new ConfigKeeper.BooleanEntry(defaultValue));
            return (Boolean)entry.getValue();
        }
        return val;
    }

    protected boolean getBoolean(ConfigKey key) {
        Boolean val = (Boolean)this.keeper.getValue(key, ConfigKeeper.BooleanEntry.class);
        return val != null ? val : false;
    }

    protected boolean setBoolean(ConfigKey key, boolean value) {
        try {
            ConfigKeeper.BooleanEntry entry = this.keeper.getEntry(key, ConfigKeeper.BooleanEntry.class);
            if (entry == null) {
                return false;
            }
            entry.setValue(value);
            return true;
        }
        catch (NullPointerException ex) {
            BCLib.LOGGER.catching(ex);
            return false;
        }
    }
}

