/*
 * Decompiled with CFR 0.152.
 */
package ru.bclib.util;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Random;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_2769;

public class BlocksHelper {
    private static final Map<class_2248, Integer> COLOR_BY_BLOCK = Maps.newHashMap();
    public static final int FLAG_UPDATE_BLOCK = 1;
    public static final int FLAG_SEND_CLIENT_CHANGES = 2;
    public static final int FLAG_NO_RERENDER = 4;
    public static final int FORSE_RERENDER = 8;
    public static final int FLAG_IGNORE_OBSERVERS = 16;
    public static final int SET_SILENT = 19;
    public static final int SET_OBSERV = 3;
    public static final class_2350[] HORIZONTAL = BlocksHelper.makeHorizontal();
    public static final class_2350[] DIRECTIONS = class_2350.values();
    private static final class_2338.class_2339 POS = new class_2338.class_2339();
    protected static final class_2680 AIR = class_2246.field_10124.method_9564();
    protected static final class_2680 WATER = class_2246.field_10382.method_9564();

    public static void addBlockColor(class_2248 block, int color) {
        COLOR_BY_BLOCK.put(block, color);
    }

    public static int getBlockColor(class_2248 block) {
        return COLOR_BY_BLOCK.getOrDefault(block, -16777216);
    }

    public static void setWithoutUpdate(class_1936 world, class_2338 pos, class_2680 state) {
        world.method_8652(pos, state, 19);
    }

    public static void setWithoutUpdate(class_1936 world, class_2338 pos, class_2248 block) {
        world.method_8652(pos, block.method_9564(), 19);
    }

    public static void setWithUpdate(class_1936 world, class_2338 pos, class_2680 state) {
        world.method_8652(pos, state, 3);
    }

    public static void setWithUpdate(class_1936 world, class_2338 pos, class_2248 block) {
        world.method_8652(pos, block.method_9564(), 3);
    }

    public static int upRay(class_1936 world, class_2338 pos, int maxDist) {
        int length = 0;
        for (int j = 1; j < maxDist && world.method_22347(pos.method_10086(j)); ++j) {
            ++length;
        }
        return length;
    }

    public static int downRay(class_1936 world, class_2338 pos, int maxDist) {
        int length = 0;
        for (int j = 1; j < maxDist && world.method_22347(pos.method_10087(j)); ++j) {
            ++length;
        }
        return length;
    }

    public static int downRayRep(class_1936 world, class_2338 pos, int maxDist) {
        POS.method_10101((class_2382)pos);
        for (int j = 1; j < maxDist && world.method_8320((class_2338)POS).method_26207().method_15800(); ++j) {
            POS.method_10099(POS.method_10264() - 1);
        }
        return pos.method_10264() - POS.method_10264();
    }

    public static int raycastSqr(class_1936 world, class_2338 pos, int dx, int dy, int dz, int maxDist) {
        POS.method_10101((class_2382)pos);
        for (int j = 1; j < maxDist && world.method_8320((class_2338)POS).method_26207().method_15800(); ++j) {
            POS.method_10100(dx, dy, dz);
        }
        return (int)pos.method_10262((class_2382)POS);
    }

    public static class_2680 rotateHorizontal(class_2680 state, class_2470 rotation, class_2769<class_2350> facing) {
        return (class_2680)state.method_11657(facing, (Comparable)rotation.method_10503((class_2350)state.method_11654(facing)));
    }

    public static class_2680 mirrorHorizontal(class_2680 state, class_2415 mirror, class_2769<class_2350> facing) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654(facing)));
    }

    public static int getLengthDown(class_1936 world, class_2338 pos, class_2248 block) {
        int count = 1;
        while (world.method_8320(pos.method_10087(count)).method_26204() == block) {
            ++count;
        }
        return count;
    }

    public static class_2350[] makeHorizontal() {
        return new class_2350[]{class_2350.field_11043, class_2350.field_11034, class_2350.field_11035, class_2350.field_11039};
    }

    public static class_2350 randomHorizontal(Random random) {
        return HORIZONTAL[random.nextInt(4)];
    }

    public static class_2350 randomDirection(Random random) {
        return DIRECTIONS[random.nextInt(6)];
    }

    public static boolean isFluid(class_2680 state) {
        return !state.method_26227().method_15769();
    }

    public static boolean isInvulnerable(class_2680 state, class_1922 world, class_2338 pos) {
        return state.method_26214(world, pos) < 0.0f;
    }

    public static boolean isInvulnerableUnsafe(class_2680 state) {
        try {
            return BlocksHelper.isInvulnerable(state, null, null);
        }
        catch (Exception e) {
            return false;
        }
    }
}

