/*
 * Decompiled with CFR 0.152.
 */
package ru.bclib.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.class_1160;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_5281;
import ru.bclib.sdf.SDF;
import ru.bclib.sdf.operator.SDFUnion;
import ru.bclib.sdf.primitive.SDFLine;
import ru.bclib.sdf.primitive.SDFPrimitive;
import ru.bclib.util.BlocksHelper;
import ru.bclib.util.MHelper;

public class SplineHelper {
    public static List<class_1160> makeSpline(float x1, float y1, float z1, float x2, float y2, float z2, int points) {
        ArrayList spline = Lists.newArrayList();
        spline.add(new class_1160(x1, y1, z1));
        int count = points - 1;
        for (int i = 1; i < count; ++i) {
            float delta = (float)i / (float)count;
            float x = class_3532.method_16439((float)delta, (float)x1, (float)x2);
            float y = class_3532.method_16439((float)delta, (float)y1, (float)y2);
            float z = class_3532.method_16439((float)delta, (float)z1, (float)z2);
            spline.add(new class_1160(x, y, z));
        }
        spline.add(new class_1160(x2, y2, z2));
        return spline;
    }

    public static List<class_1160> smoothSpline(List<class_1160> spline, int segmentPoints) {
        ArrayList result = Lists.newArrayList();
        class_1160 start = spline.get(0);
        for (int i = 1; i < spline.size(); ++i) {
            class_1160 end = spline.get(i);
            for (int j = 0; j < segmentPoints; ++j) {
                float delta = (float)j / (float)segmentPoints;
                delta = 0.5f - 0.5f * class_3532.method_15362((float)(delta * 3.14159f));
                result.add(SplineHelper.lerp(start, end, delta));
            }
            start = end;
        }
        result.add(start);
        return result;
    }

    private static class_1160 lerp(class_1160 start, class_1160 end, float delta) {
        float x = class_3532.method_16439((float)delta, (float)start.method_4943(), (float)end.method_4943());
        float y = class_3532.method_16439((float)delta, (float)start.method_4945(), (float)end.method_4945());
        float z = class_3532.method_16439((float)delta, (float)start.method_4947(), (float)end.method_4947());
        return new class_1160(x, y, z);
    }

    public static void offsetParts(List<class_1160> spline, Random random, float dx, float dy, float dz) {
        int count = spline.size();
        for (int i = 1; i < count; ++i) {
            class_1160 pos = spline.get(i);
            float x = pos.method_4943() + (float)random.nextGaussian() * dx;
            float y = pos.method_4945() + (float)random.nextGaussian() * dy;
            float z = pos.method_4947() + (float)random.nextGaussian() * dz;
            pos.method_4949(x, y, z);
        }
    }

    public static void powerOffset(List<class_1160> spline, float distance, float power) {
        int count = spline.size();
        float max = count + 1;
        for (int i = 1; i < count; ++i) {
            class_1160 pos = spline.get(i);
            float x = (float)i / max;
            float y = pos.method_4945() + (float)Math.pow(x, power) * distance;
            pos.method_4949(pos.method_4943(), y, pos.method_4947());
        }
    }

    public static SDF buildSDF(List<class_1160> spline, float radius1, float radius2, Function<class_2338, class_2680> placerFunction) {
        int count = spline.size();
        float max = count - 2;
        SDFPrimitive result = null;
        class_1160 start = spline.get(0);
        for (int i = 1; i < count; ++i) {
            class_1160 pos = spline.get(i);
            float delta = (float)(i - 1) / max;
            SDFPrimitive line = new SDFLine().setRadius(class_3532.method_16439((float)delta, (float)radius1, (float)radius2)).setStart(start.method_4943(), start.method_4945(), start.method_4947()).setEnd(pos.method_4943(), pos.method_4945(), pos.method_4947()).setBlock(placerFunction);
            result = result == null ? line : new SDFUnion().setSourceA(result).setSourceB(line);
            start = pos;
        }
        return result;
    }

    public static SDF buildSDF(List<class_1160> spline, Function<Float, Float> radiusFunction, Function<class_2338, class_2680> placerFunction) {
        int count = spline.size();
        float max = count - 2;
        SDFPrimitive result = null;
        class_1160 start = spline.get(0);
        for (int i = 1; i < count; ++i) {
            class_1160 pos = spline.get(i);
            float delta = (float)(i - 1) / max;
            SDFPrimitive line = new SDFLine().setRadius(radiusFunction.apply(Float.valueOf(delta)).floatValue()).setStart(start.method_4943(), start.method_4945(), start.method_4947()).setEnd(pos.method_4943(), pos.method_4945(), pos.method_4947()).setBlock(placerFunction);
            result = result == null ? line : new SDFUnion().setSourceA(result).setSourceB(line);
            start = pos;
        }
        return result;
    }

    public static boolean fillSpline(List<class_1160> spline, class_5281 world, class_2680 state, class_2338 pos, Function<class_2680, Boolean> replace) {
        class_1160 startPos = spline.get(0);
        for (int i = 1; i < spline.size(); ++i) {
            class_1160 endPos = spline.get(i);
            if (!SplineHelper.fillLine(startPos, endPos, world, state, pos, replace)) {
                return false;
            }
            startPos = endPos;
        }
        return true;
    }

    public static void fillSplineForce(List<class_1160> spline, class_5281 world, class_2680 state, class_2338 pos, Function<class_2680, Boolean> replace) {
        class_1160 startPos = spline.get(0);
        for (int i = 1; i < spline.size(); ++i) {
            class_1160 endPos = spline.get(i);
            SplineHelper.fillLineForce(startPos, endPos, world, state, pos, replace);
            startPos = endPos;
        }
    }

    public static boolean fillLine(class_1160 start, class_1160 end, class_5281 world, class_2680 state, class_2338 pos, Function<class_2680, Boolean> replace) {
        class_2680 bState;
        float dx = end.method_4943() - start.method_4943();
        float dy = end.method_4945() - start.method_4945();
        float dz = end.method_4947() - start.method_4947();
        float max = MHelper.max(Math.abs(dx), Math.abs(dy), Math.abs(dz));
        int count = MHelper.floor(max + 1.0f);
        dx /= max;
        dz /= max;
        float x = start.method_4943();
        float y = start.method_4945();
        float z = start.method_4947();
        boolean down = (double)Math.abs(dy /= max) > 0.2;
        class_2338.class_2339 bPos = new class_2338.class_2339();
        for (int i = 0; i < count; ++i) {
            bPos.method_10102((double)(x + (float)pos.method_10263()), (double)(y + (float)pos.method_10264()), (double)(z + (float)pos.method_10260()));
            bState = world.method_8320((class_2338)bPos);
            if (bState.equals(state) || replace.apply(bState).booleanValue()) {
                BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)bPos, state);
                bPos.method_10099(bPos.method_10264() - 1);
                bState = world.method_8320((class_2338)bPos);
                if (down && bState.equals(state) || replace.apply(bState).booleanValue()) {
                    BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)bPos, state);
                }
            } else {
                return false;
            }
            x += dx;
            y += dy;
            z += dz;
        }
        bPos.method_10102((double)(end.method_4943() + (float)pos.method_10263()), (double)(end.method_4945() + (float)pos.method_10264()), (double)(end.method_4947() + (float)pos.method_10260()));
        bState = world.method_8320((class_2338)bPos);
        if (bState.equals(state) || replace.apply(bState).booleanValue()) {
            BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)bPos, state);
            bPos.method_10099(bPos.method_10264() - 1);
            bState = world.method_8320((class_2338)bPos);
            if (down && bState.equals(state) || replace.apply(bState).booleanValue()) {
                BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)bPos, state);
            }
            return true;
        }
        return false;
    }

    public static void fillLineForce(class_1160 start, class_1160 end, class_5281 world, class_2680 state, class_2338 pos, Function<class_2680, Boolean> replace) {
        class_2680 bState;
        float dx = end.method_4943() - start.method_4943();
        float dy = end.method_4945() - start.method_4945();
        float dz = end.method_4947() - start.method_4947();
        float max = MHelper.max(Math.abs(dx), Math.abs(dy), Math.abs(dz));
        int count = MHelper.floor(max + 1.0f);
        dx /= max;
        dz /= max;
        float x = start.method_4943();
        float y = start.method_4945();
        float z = start.method_4947();
        boolean down = (double)Math.abs(dy /= max) > 0.2;
        class_2338.class_2339 bPos = new class_2338.class_2339();
        for (int i = 0; i < count; ++i) {
            bPos.method_10102((double)(x + (float)pos.method_10263()), (double)(y + (float)pos.method_10264()), (double)(z + (float)pos.method_10260()));
            bState = world.method_8320((class_2338)bPos);
            if (replace.apply(bState).booleanValue()) {
                BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)bPos, state);
                bPos.method_10099(bPos.method_10264() - 1);
                bState = world.method_8320((class_2338)bPos);
                if (down && replace.apply(bState).booleanValue()) {
                    BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)bPos, state);
                }
            }
            x += dx;
            y += dy;
            z += dz;
        }
        bPos.method_10102((double)(end.method_4943() + (float)pos.method_10263()), (double)(end.method_4945() + (float)pos.method_10264()), (double)(end.method_4947() + (float)pos.method_10260()));
        bState = world.method_8320((class_2338)bPos);
        if (replace.apply(bState).booleanValue()) {
            BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)bPos, state);
            bPos.method_10099(bPos.method_10264() - 1);
            bState = world.method_8320((class_2338)bPos);
            if (down && replace.apply(bState).booleanValue()) {
                BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)bPos, state);
            }
        }
    }

    public static boolean canGenerate(List<class_1160> spline, float scale, class_2338 start, class_5281 world, Function<class_2680, Boolean> canReplace) {
        int count = spline.size();
        class_1160 vec = spline.get(0);
        class_2338.class_2339 mut = new class_2338.class_2339();
        float x1 = (float)start.method_10263() + vec.method_4943() * scale;
        float y1 = (float)start.method_10264() + vec.method_4945() * scale;
        float z1 = (float)start.method_10260() + vec.method_4947() * scale;
        for (int i = 1; i < count; ++i) {
            vec = spline.get(i);
            float x2 = (float)start.method_10263() + vec.method_4943() * scale;
            float y2 = (float)start.method_10264() + vec.method_4945() * scale;
            float z2 = (float)start.method_10260() + vec.method_4947() * scale;
            for (float py = y1; py < y2; py += 3.0f) {
                if (py - (float)start.method_10264() < 10.0f) continue;
                float lerp = (py - y1) / (y2 - y1);
                float x = class_3532.method_16439((float)lerp, (float)x1, (float)x2);
                float z = class_3532.method_16439((float)lerp, (float)z1, (float)z2);
                mut.method_10102((double)x, (double)py, (double)z);
                if (canReplace.apply(world.method_8320((class_2338)mut)).booleanValue()) continue;
                return false;
            }
            x1 = x2;
            y1 = y2;
            z1 = z2;
        }
        return true;
    }

    public static boolean canGenerate(List<class_1160> spline, class_2338 start, class_5281 world, Function<class_2680, Boolean> canReplace) {
        int count = spline.size();
        class_1160 vec = spline.get(0);
        class_2338.class_2339 mut = new class_2338.class_2339();
        float x1 = (float)start.method_10263() + vec.method_4943();
        float y1 = (float)start.method_10264() + vec.method_4945();
        float z1 = (float)start.method_10260() + vec.method_4947();
        for (int i = 1; i < count; ++i) {
            vec = spline.get(i);
            float x2 = (float)start.method_10263() + vec.method_4943();
            float y2 = (float)start.method_10264() + vec.method_4945();
            float z2 = (float)start.method_10260() + vec.method_4947();
            for (float py = y1; py < y2; py += 3.0f) {
                if (py - (float)start.method_10264() < 10.0f) continue;
                float lerp = (py - y1) / (y2 - y1);
                float x = class_3532.method_16439((float)lerp, (float)x1, (float)x2);
                float z = class_3532.method_16439((float)lerp, (float)z1, (float)z2);
                mut.method_10102((double)x, (double)py, (double)z);
                if (canReplace.apply(world.method_8320((class_2338)mut)).booleanValue()) continue;
                return false;
            }
            x1 = x2;
            y1 = y2;
            z1 = z2;
        }
        return true;
    }

    public static class_1160 getPos(List<class_1160> spline, float index) {
        int i = (int)index;
        int last = spline.size() - 1;
        if (i >= last) {
            return spline.get(last);
        }
        float delta = index - (float)i;
        class_1160 p1 = spline.get(i);
        class_1160 p2 = spline.get(i + 1);
        float x = class_3532.method_16439((float)delta, (float)p1.method_4943(), (float)p2.method_4943());
        float y = class_3532.method_16439((float)delta, (float)p1.method_4945(), (float)p2.method_4945());
        float z = class_3532.method_16439((float)delta, (float)p1.method_4947(), (float)p2.method_4947());
        return new class_1160(x, y, z);
    }

    public static void rotateSpline(List<class_1160> spline, float angle) {
        for (class_1160 v : spline) {
            float sin = (float)Math.sin(angle);
            float cos = (float)Math.cos(angle);
            float x = v.method_4943() * cos + v.method_4947() * sin;
            float z = v.method_4943() * sin + v.method_4947() * cos;
            v.method_4949(x, v.method_4945(), z);
        }
    }

    public static List<class_1160> copySpline(List<class_1160> spline) {
        ArrayList<class_1160> result = new ArrayList<class_1160>(spline.size());
        for (class_1160 v : spline) {
            result.add(new class_1160(v.method_4943(), v.method_4945(), v.method_4947()));
        }
        return result;
    }

    public static void scale(List<class_1160> spline, float scale) {
        SplineHelper.scale(spline, scale, scale, scale);
    }

    public static void scale(List<class_1160> spline, float x, float y, float z) {
        for (class_1160 v : spline) {
            v.method_4949(v.method_4943() * x, v.method_4945() * y, v.method_4947() * z);
        }
    }

    public static void offset(List<class_1160> spline, class_1160 offset) {
        for (class_1160 v : spline) {
            v.method_4949(offset.method_4943() + v.method_4943(), offset.method_4945() + v.method_4945(), offset.method_4947() + v.method_4947());
        }
    }
}

