/*
 * Decompiled with CFR 0.152.
 */
package ru.bclib.util;

import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Random;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3341;
import net.minecraft.class_3481;
import net.minecraft.class_3492;
import net.minecraft.class_3494;
import net.minecraft.class_3499;
import net.minecraft.class_3614;
import net.minecraft.class_4538;
import net.minecraft.class_5281;
import net.minecraft.class_5425;
import ru.bclib.api.TagAPI;
import ru.bclib.util.BlocksHelper;
import ru.bclib.util.MHelper;

public class StructureHelper {
    private static final class_2350[] DIR = BlocksHelper.makeHorizontal();

    public static class_3499 readStructure(class_2960 resource) {
        String ns = resource.method_12836();
        String nm = resource.method_12832();
        return StructureHelper.readStructure("/data/" + ns + "/structures/" + nm + ".nbt");
    }

    public static class_3499 readStructure(File datapack, String path) {
        if (datapack.isDirectory()) {
            return StructureHelper.readStructure(datapack.toString() + "/" + path);
        }
        if (datapack.isFile() && datapack.getName().endsWith(".zip")) {
            try {
                ZipFile zipFile = new ZipFile(datapack);
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    String name = entry.getName();
                    long compressedSize = entry.getCompressedSize();
                    long normalSize = entry.getSize();
                    String type = entry.isDirectory() ? "DIR" : "FILE";
                    System.out.println(name);
                    System.out.format("\t %s - %d - %d\n", type, compressedSize, normalSize);
                }
                zipFile.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static class_3499 readStructure(String path) {
        try {
            InputStream inputstream = StructureHelper.class.getResourceAsStream(path);
            return StructureHelper.readStructureFromStream(inputstream);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static class_3499 readStructureFromStream(InputStream stream) throws IOException {
        class_2487 nbttagcompound = class_2507.method_10629((InputStream)stream);
        class_3499 template = new class_3499();
        template.method_15183(nbttagcompound);
        return template;
    }

    public static class_2338 offsetPos(class_2338 pos, class_3499 structure, class_2470 rotation, class_2415 mirror) {
        class_2338 offset = class_3499.method_15168((class_2338)structure.method_15160(), (class_2415)mirror, (class_2470)rotation, (class_2338)class_2338.field_10980);
        return pos.method_10080((double)(-offset.method_10263()) * 0.5, 0.0, (double)(-offset.method_10260()) * 0.5);
    }

    public static void placeCenteredBottom(class_5281 world, class_2338 pos, class_3499 structure, class_2470 rotation, class_2415 mirror, Random random) {
        StructureHelper.placeCenteredBottom(world, pos, structure, rotation, mirror, StructureHelper.makeBox(pos), random);
    }

    public static void placeCenteredBottom(class_5281 world, class_2338 pos, class_3499 structure, class_2470 rotation, class_2415 mirror, class_3341 bounds, Random random) {
        class_2338 offset = StructureHelper.offsetPos(pos, structure, rotation, mirror);
        class_3492 placementData = new class_3492().method_15123(rotation).method_15125(mirror).method_15126(bounds);
        structure.method_15182((class_5425)world, offset, placementData, random);
    }

    private static class_3341 makeBox(class_2338 pos) {
        int sx = (pos.method_10263() >> 4 << 4) - 16;
        int sz = (pos.method_10260() >> 4 << 4) - 16;
        int ex = sx + 47;
        int ez = sz + 47;
        return class_3341.method_14666((int)sx, (int)0, (int)sz, (int)ex, (int)255, (int)ez);
    }

    public static class_3341 getStructureBounds(class_2338 pos, class_3499 structure, class_2470 rotation, class_2415 mirror) {
        class_2338 max = structure.method_15160();
        class_2338 min = class_3499.method_15168((class_2338)structure.method_15160(), (class_2415)mirror, (class_2470)rotation, (class_2338)class_2338.field_10980);
        max = max.method_10059((class_2382)min);
        return new class_3341((class_2382)min.method_10081((class_2382)pos), (class_2382)max.method_10081((class_2382)pos));
    }

    public static class_3341 intersectBoxes(class_3341 box1, class_3341 box2) {
        int x1 = MHelper.max(box1.field_14381, box2.field_14381);
        int y1 = MHelper.max(box1.field_14380, box2.field_14380);
        int z1 = MHelper.max(box1.field_14379, box2.field_14379);
        int x2 = MHelper.min(box1.field_14378, box2.field_14378);
        int y2 = MHelper.min(box1.field_14377, box2.field_14377);
        int z2 = MHelper.min(box1.field_14376, box2.field_14376);
        return class_3341.method_14666((int)x1, (int)y1, (int)z1, (int)x2, (int)y2, (int)z2);
    }

    public static void erode(class_5281 world, class_3341 bounds, int iterations, Random random) {
        class_2338.class_2339 mut = new class_2338.class_2339();
        boolean canDestruct = true;
        for (int i = 0; i < iterations; ++i) {
            for (int x = bounds.field_14381; x <= bounds.field_14378; ++x) {
                mut.method_20787(x);
                block2: for (int z = bounds.field_14379; z <= bounds.field_14376; ++z) {
                    mut.method_20788(z);
                    for (int y = bounds.field_14377; y >= bounds.field_14380; --y) {
                        mut.method_10099(y);
                        class_2680 state = world.method_8320((class_2338)mut);
                        boolean ignore = StructureHelper.ignore(state, world, (class_2338)mut);
                        if (canDestruct && BlocksHelper.isInvulnerable(state, (class_1922)world, (class_2338)mut) && random.nextInt(8) == 0 && world.method_22347(mut.method_10087(2))) {
                            int r = MHelper.randRange(1, 4, random);
                            int cx = mut.method_10263();
                            int cy = mut.method_10264();
                            int cz = mut.method_10260();
                            int x1 = cx - r;
                            int y1 = cy - r;
                            int z1 = cz - r;
                            int x2 = cx + r;
                            int y2 = cy + r;
                            int z2 = cz + r;
                            for (int px = x1; px <= x2; ++px) {
                                int dx = px - cx;
                                dx *= dx;
                                mut.method_20787(px);
                                for (int py = y1; py <= y2; ++py) {
                                    int dy = py - cy;
                                    dy *= dy;
                                    mut.method_10099(py);
                                    for (int pz = z1; pz <= z2; ++pz) {
                                        int dz = pz - cz;
                                        dz *= dz;
                                        mut.method_20788(pz);
                                        if (dx + dy + dz > r || !BlocksHelper.isInvulnerable(world.method_8320((class_2338)mut), (class_1922)world, (class_2338)mut)) continue;
                                        BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)mut, class_2246.field_10124);
                                    }
                                }
                            }
                            mut.method_20787(cx);
                            mut.method_10099(cy);
                            mut.method_20788(cz);
                            canDestruct = false;
                            continue;
                        }
                        if (ignore) continue;
                        if (!state.method_26215() && random.nextBoolean()) {
                            MHelper.shuffle(DIR, random);
                            block7: for (class_2350 dir : DIR) {
                                if (!world.method_22347(mut.method_10093(dir)) || !world.method_22347(mut.method_10074().method_10093(dir))) continue;
                                BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)mut, class_2246.field_10124);
                                mut.method_10098(dir).method_10098(class_2350.field_11033);
                                int py = mut.method_10264();
                                while (y >= bounds.field_14380 - 10) {
                                    mut.method_10099(py - 1);
                                    if (!world.method_22347((class_2338)mut)) {
                                        mut.method_10099(py);
                                        BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)mut, state);
                                        continue block7;
                                    }
                                    --y;
                                }
                            }
                            continue block2;
                        }
                        if (random.nextInt(8) != 0 || BlocksHelper.isInvulnerable(world.method_8320(mut.method_10084()), (class_1922)world, (class_2338)mut)) continue;
                        BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)mut, class_2246.field_10124);
                    }
                }
            }
        }
        for (int x = bounds.field_14381; x <= bounds.field_14378; ++x) {
            mut.method_20787(x);
            for (int z = bounds.field_14379; z <= bounds.field_14376; ++z) {
                mut.method_20788(z);
                block11: for (int y = bounds.field_14377; y >= bounds.field_14380; --y) {
                    mut.method_10099(y);
                    class_2680 state = world.method_8320((class_2338)mut);
                    if (StructureHelper.ignore(state, world, (class_2338)mut) || !world.method_22347(mut.method_10074())) continue;
                    BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)mut, class_2246.field_10124);
                    for (int py = mut.method_10264(); py >= bounds.field_14380 - 10; --py) {
                        mut.method_10099(py - 1);
                        if (world.method_22347((class_2338)mut)) continue;
                        mut.method_10099(py);
                        BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)mut, state);
                        continue block11;
                    }
                }
            }
        }
    }

    public static void erodeIntense(class_5281 world, class_3341 bounds, Random random) {
        class_2338.class_2339 mut = new class_2338.class_2339();
        class_2338.class_2339 mut2 = new class_2338.class_2339();
        int minY = bounds.field_14380 - 10;
        for (int x = bounds.field_14381; x <= bounds.field_14378; ++x) {
            mut.method_20787(x);
            for (int z = bounds.field_14379; z <= bounds.field_14376; ++z) {
                mut.method_20788(z);
                for (int y = bounds.field_14377; y >= bounds.field_14380; --y) {
                    mut.method_10099(y);
                    class_2680 state = world.method_8320((class_2338)mut);
                    if (StructureHelper.ignore(state, world, (class_2338)mut)) continue;
                    if (random.nextInt(6) == 0) {
                        BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)mut, class_2246.field_10124);
                        if (!random.nextBoolean()) continue;
                        int px = MHelper.floor(random.nextGaussian() * 2.0 + (double)x + 0.5);
                        int pz = MHelper.floor(random.nextGaussian() * 2.0 + (double)z + 0.5);
                        mut2.method_10103(px, y, pz);
                        while (world.method_8320((class_2338)mut2).method_26207().method_15800() && mut2.method_10264() > minY) {
                            mut2.method_10099(mut2.method_10264() - 1);
                        }
                        if (world.method_8320((class_2338)mut2).method_26215() || !state.method_26184((class_4538)world, (class_2338)mut2)) continue;
                        mut2.method_10099(mut2.method_10264() + 1);
                        BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)mut2, state);
                        continue;
                    }
                    if (random.nextInt(8) != 0) continue;
                    BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)mut, class_2246.field_10124);
                }
            }
        }
        StructureHelper.drop(world, bounds);
    }

    private static boolean isTerrainNear(class_5281 world, class_2338 pos) {
        for (class_2350 dir : BlocksHelper.DIRECTIONS) {
            if (!world.method_8320(pos.method_10093(dir)).method_26164(TagAPI.GEN_TERRAIN)) continue;
            return true;
        }
        return false;
    }

    private static void drop(class_5281 world, class_3341 bounds) {
        class_2338.class_2339 mut = new class_2338.class_2339();
        HashSet blocks = Sets.newHashSet();
        HashSet edge = Sets.newHashSet();
        HashSet add = Sets.newHashSet();
        for (int x = bounds.field_14381; x <= bounds.field_14378; ++x) {
            mut.method_20787(x);
            for (int z = bounds.field_14379; z <= bounds.field_14376; ++z) {
                mut.method_20788(z);
                for (int y = bounds.field_14380; y <= bounds.field_14377; ++y) {
                    mut.method_10099(y);
                    class_2680 state = world.method_8320((class_2338)mut);
                    if (StructureHelper.ignore(state, world, (class_2338)mut) || !StructureHelper.isTerrainNear(world, (class_2338)mut)) continue;
                    edge.add(mut.method_10062());
                }
            }
        }
        if (edge.isEmpty()) {
            return;
        }
        while (!edge.isEmpty()) {
            for (class_2338 center : edge) {
                for (class_2350 dir : BlocksHelper.DIRECTIONS) {
                    class_2680 state = world.method_8320(center);
                    if (!state.method_26234((class_1922)world, center)) continue;
                    mut.method_10101((class_2382)center).method_10098(dir);
                    if (!bounds.method_14662((class_2382)mut) || StructureHelper.ignore(state = world.method_8320((class_2338)mut), world, (class_2338)mut) || blocks.contains(mut)) continue;
                    add.add(mut.method_10062());
                }
            }
            blocks.addAll(edge);
            edge.clear();
            edge.addAll(add);
            add.clear();
        }
        int minY = bounds.field_14380 - 10;
        for (int x = bounds.field_14381; x <= bounds.field_14378; ++x) {
            mut.method_20787(x);
            for (int z = bounds.field_14379; z <= bounds.field_14376; ++z) {
                mut.method_20788(z);
                for (int y = bounds.field_14380; y <= bounds.field_14377; ++y) {
                    mut.method_10099(y);
                    class_2680 state = world.method_8320((class_2338)mut);
                    if (StructureHelper.ignore(state, world, (class_2338)mut) || blocks.contains(mut)) continue;
                    BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)mut, class_2246.field_10124);
                    while (world.method_8320((class_2338)mut).method_26207().method_15800() && mut.method_10264() > minY) {
                        mut.method_10099(mut.method_10264() - 1);
                    }
                    if (mut.method_10264() <= minY) continue;
                    mut.method_10099(mut.method_10264() + 1);
                    BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)mut, state);
                }
            }
        }
    }

    private static boolean ignore(class_2680 state, class_5281 world, class_2338 pos) {
        return state.method_26207().method_15800() || !state.method_26227().method_15769() || state.method_26164(TagAPI.END_GROUND) || state.method_26164((class_3494)class_3481.field_15475) || state.method_26164((class_3494)class_3481.field_15503) || state.method_26207().equals(class_3614.field_15935) || state.method_26207().equals(class_3614.field_15923) || BlocksHelper.isInvulnerable(state, (class_1922)world, pos);
    }

    public static void cover(class_5281 world, class_3341 bounds, Random random) {
        class_2338.class_2339 mut = new class_2338.class_2339();
        for (int x = bounds.field_14381; x <= bounds.field_14378; ++x) {
            mut.method_20787(x);
            for (int z = bounds.field_14379; z <= bounds.field_14376; ++z) {
                mut.method_20788(z);
                class_2680 top = world.method_23753((class_2338)mut).method_30970().method_30985().method_15337();
                for (int y = bounds.field_14377; y >= bounds.field_14380; --y) {
                    mut.method_10099(y);
                    class_2680 state = world.method_8320((class_2338)mut);
                    if (!state.method_26164(TagAPI.END_GROUND) || world.method_8320(mut.method_10084()).method_26207().method_15804()) continue;
                    BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)mut, top);
                }
            }
        }
    }
}

