/*
 * Decompiled with CFR 0.152.
 */
package ru.bclib.util;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5458;

public class TranslationHelper {
    public static void printMissingNames(String modID) {
        ArrayList missingNamesEn = Lists.newArrayList();
        ArrayList missingNamesRu = Lists.newArrayList();
        Gson gson = new Gson();
        InputStream streamEn = TranslationHelper.class.getResourceAsStream("/assets/" + modID + "/lang/en_us.json");
        InputStream streamRu = TranslationHelper.class.getResourceAsStream("/assets/" + modID + "/lang/ru_ru.json");
        JsonObject translationEn = (JsonObject)gson.fromJson((Reader)new InputStreamReader(streamEn), JsonObject.class);
        JsonObject translationRu = (JsonObject)gson.fromJson((Reader)new InputStreamReader(streamRu), JsonObject.class);
        class_2378.field_11146.forEach(block -> {
            if (class_2378.field_11146.method_10221(block).method_12836().equals(modID)) {
                String name = block.method_9518().getString();
                if (!translationEn.has(name)) {
                    missingNamesEn.add(name);
                }
                if (!translationRu.has(name)) {
                    missingNamesRu.add(name);
                }
            }
        });
        class_2378.field_11142.forEach(item -> {
            if (class_2378.field_11142.method_10221(item).method_12836().equals(modID)) {
                String name = item.method_7848().getString();
                if (!translationEn.has(name)) {
                    missingNamesEn.add(name);
                }
                if (!translationRu.has(name)) {
                    missingNamesRu.add(name);
                }
            }
        });
        class_5458.field_25933.forEach(biome -> {
            class_2960 id = class_5458.field_25933.method_10221(biome);
            if (id.method_12836().equals(modID)) {
                String name = "biome." + modID + "." + id.method_12832();
                if (!translationEn.has(name)) {
                    missingNamesEn.add(name);
                }
                if (!translationRu.has(name)) {
                    missingNamesRu.add(name);
                }
            }
        });
        class_2378.field_11145.forEach(entity -> {
            class_2960 id = class_2378.field_11145.method_10221(entity);
            if (id.method_12836().equals(modID)) {
                String name = "entity." + modID + "." + id.method_12832();
                if (!translationEn.has(name)) {
                    missingNamesEn.add(name);
                }
                if (!translationRu.has(name)) {
                    missingNamesRu.add(name);
                }
            }
        });
        if (!missingNamesEn.isEmpty() || !missingNamesRu.isEmpty()) {
            System.out.println("========================================");
            System.out.println("           MISSING NAMES LIST");
            if (!missingNamesEn.isEmpty()) {
                Collections.sort(missingNamesEn);
                System.out.println("========================================");
                System.out.println("                 ENGLISH");
                System.out.println("========================================");
                missingNamesEn.forEach(name -> System.out.println("\t\"" + name + "\": \"" + TranslationHelper.fastTranslateEn(name) + "\","));
            }
            if (!missingNamesRu.isEmpty()) {
                Collections.sort(missingNamesRu);
                System.out.println("========================================");
                System.out.println("                 RUSSIAN");
                System.out.println("========================================");
                missingNamesRu.forEach(name -> System.out.println("\t\"" + name + "\": \"\","));
            }
            System.out.println("========================================");
        }
    }

    public static String fastTranslateEn(String text) {
        String[] words = text.substring(text.lastIndexOf(46) + 1).split("_");
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < words.length; ++i) {
            String word = words[i];
            builder.append(Character.toUpperCase(word.charAt(0)));
            builder.append(word, 1, word.length());
            if (i >= words.length - 1) continue;
            builder.append(' ');
        }
        return builder.toString();
    }
}

