/*
 * Decompiled with CFR 0.152.
 */
package ru.bclib.world.biomes;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import ru.bclib.util.JsonFactory;
import ru.bclib.util.StructureHelper;
import ru.bclib.util.WeightedList;
import ru.bclib.world.biomes.BCLBiomeDef;
import ru.bclib.world.features.BCLFeature;
import ru.bclib.world.features.ListFeature;
import ru.bclib.world.features.NBTStructureFeature;

public class BCLBiome {
    protected WeightedList<BCLBiome> subbiomes = new WeightedList();
    protected final class_1959 biome;
    protected final class_2960 mcID;
    protected BCLBiome edge;
    protected int edgeSize;
    protected BCLBiome biomeParent;
    protected float maxSubBiomeChance = 1.0f;
    protected final float genChance;
    private final Map<String, Object> customData;
    private final float fogDensity;
    private BCLFeature structuresFeature;
    private class_1959 actualBiome;

    public BCLBiome(BCLBiomeDef definition) {
        this.mcID = definition.getID();
        this.readStructureList();
        if (this.structuresFeature != null) {
            definition.addFeature(this.structuresFeature);
        }
        this.biome = definition.build();
        this.genChance = definition.getGenChance();
        this.fogDensity = definition.getFodDensity();
        this.customData = definition.getCustomData();
    }

    public BCLBiome(class_2960 id, class_1959 biome, float fogDensity, float genChance) {
        this.mcID = id;
        this.biome = biome;
        this.genChance = genChance;
        this.fogDensity = fogDensity;
        this.readStructureList();
        this.customData = Maps.newHashMap();
    }

    public BCLBiome getEdge() {
        return this.edge == null ? this : this.edge;
    }

    public void setEdge(BCLBiome edge) {
        this.edge = edge;
        edge.biomeParent = this;
    }

    public int getEdgeSize() {
        return this.edgeSize;
    }

    public void setEdgeSize(int size) {
        this.edgeSize = size;
    }

    public void addSubBiome(BCLBiome biome) {
        biome.biomeParent = this;
        this.subbiomes.add(biome, biome.getGenChance());
    }

    public boolean containsSubBiome(BCLBiome biome) {
        return this.subbiomes.contains(biome);
    }

    public BCLBiome getSubBiome(Random random) {
        BCLBiome biome = this.subbiomes.get(random);
        return biome == null ? this : biome;
    }

    public BCLBiome getParentBiome() {
        return this.biomeParent;
    }

    public boolean hasEdge() {
        return this.edge != null;
    }

    public boolean hasParentBiome() {
        return this.biomeParent != null;
    }

    public boolean isSame(BCLBiome biome) {
        return biome == this || biome.hasParentBiome() && biome.getParentBiome() == this;
    }

    public class_1959 getBiome() {
        return this.biome;
    }

    public String toString() {
        return this.mcID.toString();
    }

    public class_2960 getID() {
        return this.mcID;
    }

    public float getFogDensity() {
        return this.fogDensity;
    }

    protected void readStructureList() {
        JsonObject obj;
        JsonArray enties;
        String ns = this.mcID.method_12836();
        String nm = this.mcID.method_12832();
        String path = "/data/" + ns + "/structures/biome/" + nm + "/";
        InputStream inputstream = StructureHelper.class.getResourceAsStream(path + "structures.json");
        if (inputstream != null && (enties = (obj = JsonFactory.getJsonObject(inputstream)).getAsJsonArray("structures")) != null) {
            ArrayList list = Lists.newArrayList();
            enties.forEach(entry -> {
                JsonObject e = entry.getAsJsonObject();
                String structure = path + e.get("nbt").getAsString() + ".nbt";
                NBTStructureFeature.TerrainMerge terrainMerge = NBTStructureFeature.TerrainMerge.getFromString(e.get("terrainMerge").getAsString());
                int offsetY = e.get("offsetY").getAsInt();
                list.add(new ListFeature.StructureInfo(structure, offsetY, terrainMerge));
            });
            if (!list.isEmpty()) {
                this.structuresFeature = BCLFeature.makeChansedFeature(new class_2960(ns, nm + "_structures"), new ListFeature(list), 10);
            }
        }
    }

    public BCLFeature getStructuresFeature() {
        return this.structuresFeature;
    }

    public class_1959 getActualBiome() {
        return this.actualBiome;
    }

    public float getGenChance() {
        return this.genChance;
    }

    public void updateActualBiomes(class_2378<class_1959> biomeRegistry) {
        this.subbiomes.forEach(sub -> {
            if (sub != this) {
                sub.updateActualBiomes(biomeRegistry);
            }
        });
        if (this.edge != null && this.edge != this) {
            this.edge.updateActualBiomes(biomeRegistry);
        }
        this.actualBiome = (class_1959)biomeRegistry.method_10223(this.mcID);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        BCLBiome biome = (BCLBiome)obj;
        return biome == null ? false : biome.mcID.equals((Object)this.mcID);
    }

    public int hashCode() {
        return this.mcID.hashCode();
    }

    public <T> T getCustomData(String name, T defaultValue) {
        return (T)this.customData.getOrDefault(name, defaultValue);
    }

    public void addCustomData(String name, Object obj) {
        this.customData.put(name, obj);
    }
}

