/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.client.renderer;

import juuxel.adorn.block.entity.TradingStationBlockEntity;
import juuxel.adorn.config.ConfigManager;
import juuxel.adorn.trading.Trade;
import juuxel.adorn.util.Colors;
import juuxel.adorn.util.ColorsKt;
import juuxel.adorn.util.ExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_124;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3965;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5348;
import net.minecraft.class_746;
import net.minecraft.class_809;
import net.minecraft.class_824;
import net.minecraft.class_827;
import net.minecraft.class_918;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\b\u0007\u0018\u0000 \u001b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001bB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J8\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016JP\u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u001c"}, d2={"Ljuuxel/adorn/client/renderer/TradingStationRenderer;", "Lnet/minecraft/client/render/block/entity/BlockEntityRenderer;", "Ljuuxel/adorn/block/entity/TradingStationBlockEntity;", "dispatcher", "Lnet/minecraft/client/render/block/entity/BlockEntityRenderDispatcher;", "(Lnet/minecraft/client/render/block/entity/BlockEntityRenderDispatcher;)V", "render", "", "be", "tickDelta", "", "matrices", "Lnet/minecraft/client/util/math/MatrixStack;", "vertexConsumerProvider", "Lnet/minecraft/client/render/VertexConsumerProvider;", "light", "", "overlay", "renderLabel", "label", "Lnet/minecraft/text/Text;", "x", "", "y", "z", "maxDistance", "vertexConsumers", "Companion", "Adorn"})
@Environment(value=EnvType.CLIENT)
public final class TradingStationRenderer
extends class_827<TradingStationBlockEntity> {
    private static final float SELLING_ROTATION_MULTIPLIER = 1.2f;
    private static final String OWNER_LABEL = "block.adorn.trading_station.label.owner";
    private static final String SELLING_LABEL = "block.adorn.trading_station.label.selling";
    private static final String PRICE_LABEL = "block.adorn.trading_station.label.price";
    @NotNull
    public static final Companion Companion = new Companion(null);

    public void render(@NotNull TradingStationBlockEntity be, float tickDelta, @NotNull class_4587 matrices, @NotNull class_4597 vertexConsumerProvider, int light, int overlay) {
        Intrinsics.checkNotNullParameter((Object)be, (String)"be");
        Intrinsics.checkNotNullParameter((Object)matrices, (String)"matrices");
        Intrinsics.checkNotNullParameter((Object)vertexConsumerProvider, (String)"vertexConsumerProvider");
        class_239 hitResult = this.field_20989.field_4350;
        boolean lookingAtBlock = hitResult != null && hitResult.method_17783() == class_239.class_240.field_1332 && Intrinsics.areEqual((Object)be.method_11016(), (Object)((class_3965)hitResult).method_17777());
        Trade trade = be.getTrade();
        if (!trade.isEmpty()) {
            matrices.method_22903();
            matrices.method_22904(0.5, 1.2, 0.5);
            class_746 class_7462 = class_310.method_1551().field_1724;
            Intrinsics.checkNotNull((Object)class_7462);
            int playerAge = class_7462.field_6012;
            matrices.method_22903();
            matrices.method_22907(class_1160.field_20705.method_23214(((float)playerAge + tickDelta) * 1.2f));
            matrices.method_22905(0.6f, 0.6f, 0.6f);
            matrices.method_22904(0.0, 0.3, 0.0);
            class_310 class_3102 = class_310.method_1551();
            Intrinsics.checkNotNullExpressionValue((Object)class_3102, (String)"MinecraftClient.getInstance()");
            class_918 itemRenderer = class_3102.method_1480();
            itemRenderer.method_23178(trade.getSelling(), class_809.class_811.field_4319, light, overlay, matrices, vertexConsumerProvider);
            matrices.method_22909();
            matrices.method_22909();
        }
        if (lookingAtBlock && ConfigManager.INSTANCE.getConfig().getClient().getShowTradingStationTooltips()) {
            class_2588 label1 = new class_2588(OWNER_LABEL, new Object[]{be.getOwnerName().method_27662().method_27692(class_124.field_1065)});
            this.renderLabel(be, (class_2561)label1, 0.0, 0.9, 0.0, 12, matrices, vertexConsumerProvider, light);
            if (!be.getTrade().isEmpty()) {
                class_2588 label2 = new class_2588(SELLING_LABEL, new Object[]{ExtensionsKt.toTextWithCount(be.getTrade().getSelling())});
                class_2588 label3 = new class_2588(PRICE_LABEL, new Object[]{ExtensionsKt.toTextWithCount(be.getTrade().getPrice())});
                this.renderLabel(be, (class_2561)label2, 0.0, 0.65, 0.0, 12, matrices, vertexConsumerProvider, light);
                this.renderLabel(be, (class_2561)label3, 0.0, 0.4, 0.0, 12, matrices, vertexConsumerProvider, light);
            }
        }
    }

    private final void renderLabel(TradingStationBlockEntity be, class_2561 label, double x, double y, double z, int maxDistance, class_4587 matrices, class_4597 vertexConsumers, int light) {
        class_4184 camera = this.field_20989.field_4344;
        class_2586 class_25862 = be;
        class_4184 class_41842 = camera;
        Intrinsics.checkNotNullExpressionValue((Object)class_41842, (String)"camera");
        double dist = ExtensionsKt.getSquaredDistance(class_25862, class_41842.method_19326().field_1352, camera.method_19326().field_1351, camera.method_19326().field_1350);
        if (dist < (double)(maxDistance * maxDistance)) {
            matrices.method_22903();
            matrices.method_22904(x + 0.5, y + 1.5, z + 0.5);
            matrices.method_22907(camera.method_23767());
            matrices.method_22905(-0.025f, -0.025f, 0.025f);
            class_4587.class_4665 class_46652 = matrices.method_23760();
            Intrinsics.checkNotNullExpressionValue((Object)class_46652, (String)"matrices.peek()");
            class_1159 matrixModel = class_46652.method_23761();
            float opacity = class_310.method_1551().field_1690.method_19343(0.25f);
            int backgroundColor = ColorsKt.color(0, opacity);
            class_824 class_8242 = this.field_20989;
            Intrinsics.checkNotNullExpressionValue((Object)class_8242, (String)"dispatcher");
            class_327 textRenderer = class_8242.method_3556();
            float textX = (float)(-textRenderer.method_27525((class_5348)label)) / 2.0f;
            textRenderer.method_30882(label, textX, 0.0f, Colors.INSTANCE.getWHITE(), false, matrixModel, vertexConsumers, false, backgroundColor, light);
            matrices.method_22909();
        }
    }

    public TradingStationRenderer(@NotNull class_824 dispatcher) {
        Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
        super(dispatcher);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Ljuuxel/adorn/client/renderer/TradingStationRenderer$Companion;", "", "()V", "OWNER_LABEL", "", "PRICE_LABEL", "SELLING_LABEL", "SELLING_ROTATION_MULTIPLIER", "", "Adorn"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

