/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.world.carver;

import com.yungnickyoung.minecraft.bettercaves.BetterCaves;
import com.yungnickyoung.minecraft.bettercaves.world.carver.CarvingContext;
import com.yungnickyoung.minecraft.bettercaves.world.carver.controller.MasterController;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2791;
import net.minecraft.class_2893;
import net.minecraft.class_2922;
import net.minecraft.class_2932;
import net.minecraft.class_2939;
import net.minecraft.class_3218;
import net.minecraft.class_5281;

public class BetterCavesCarver
extends class_2939<class_2932> {
    public BetterCavesCarver() {
        super(class_2932.field_24829, 256);
    }

    public boolean carve(class_2791 chunkIn, Function<class_2338, class_1959> biomePos, Random rand, int seaLevel, int chunkXOffset, int chunkZOffset, int chunkX, int chunkZ, BitSet carvingMask, class_2932 config) {
        CarvingContext context = CarvingContext.peek();
        if (context == null) {
            return false;
        }
        class_3218 world = context.getWorld();
        if (world == null) {
            BetterCaves.LOGGER.error("ERROR: Unable to retrieve world from CarvingContext!");
            return false;
        }
        BitSet airCarvingMask = context.getMask(class_2893.class_2894.field_13169);
        BitSet liquidCarvingMask = context.getMask(class_2893.class_2894.field_13166);
        String dimensionName = null;
        try {
            dimensionName = Objects.requireNonNull(world.method_8410().method_27983().method_29177()).toString();
        }
        catch (NullPointerException e) {
            BetterCaves.LOGGER.error("ERROR: Unable to get dimension name! Using default cave gen...");
        }
        if (dimensionName == null || !this.isDimensionWhitelisted(dimensionName)) {
            return this.useDefaultCarvers(world, chunkIn, biomePos, rand, seaLevel, chunkXOffset, chunkZOffset, chunkX, chunkZ, airCarvingMask, liquidCarvingMask);
        }
        CarvingContext.pop();
        if (BetterCaves.activeCarversMap.get(dimensionName) == null || BetterCaves.activeCarversMap.get(dimensionName).getSeed() != world.method_8412()) {
            MasterController newCarver = new MasterController();
            BetterCaves.activeCarversMap.put(dimensionName, newCarver);
            BetterCaves.LOGGER.info(String.format("CREATING AND INIT'ING CARVER W DIMENSION %s...", dimensionName));
            newCarver.initialize((class_5281)world);
        }
        MasterController masterController = BetterCaves.activeCarversMap.get(dimensionName);
        masterController.setWorld((class_5281)world);
        return masterController.carveRegion(chunkIn, biomePos, chunkIn.method_12004().field_9181, chunkIn.method_12004().field_9180, airCarvingMask, liquidCarvingMask);
    }

    public boolean shouldCarve(Random rand, int chunkX, int chunkZ, class_2932 config) {
        return true;
    }

    protected boolean method_16582(double scaledRelativeX, double scaledRelativeY, double scaledRelativeZ, int y) {
        return true;
    }

    private boolean useDefaultCarvers(class_3218 world, class_2791 chunkIn, Function<class_2338, class_1959> biomePos, Random rand, int seaLevel, int chunkXOffset, int chunkZOffset, int chunkX, int chunkZ, BitSet airCarvingMask, BitSet liquidCarvingMask) {
        class_2922<?> carver;
        String biomeName = biomePos.apply(new class_2338(chunkIn.method_12004().field_9181 << 4, 0, chunkIn.method_12004().field_9180 << 4)).toString();
        List<Supplier<class_2922<?>>> defaultAirCarvers = BetterCaves.defaultBiomeAirCarvers.get(biomeName);
        List<Supplier<class_2922<?>>> defaultLiquidCarvers = BetterCaves.defaultBiomeLiquidCarvers.get(biomeName);
        if (defaultAirCarvers == null || defaultLiquidCarvers == null) {
            return false;
        }
        for (Supplier<class_2922<?>> carverSupplier : defaultAirCarvers) {
            carver = carverSupplier.get();
            if (!carver.method_12669(rand, chunkX, chunkZ)) continue;
            carver.method_12668(chunkIn, biomePos, rand, seaLevel, chunkXOffset, chunkZOffset, chunkX, chunkZ, airCarvingMask);
        }
        for (Supplier<class_2922<?>> carverSupplier : defaultLiquidCarvers) {
            carver = carverSupplier.get();
            if (!carver.method_12669(rand, chunkX, chunkZ)) continue;
            carver.method_12668(chunkIn, biomePos, rand, seaLevel, chunkXOffset, chunkZOffset, chunkX, chunkZ, liquidCarvingMask);
        }
        return true;
    }

    private boolean isDimensionWhitelisted(String dimensionName) {
        return BetterCaves.CONFIG.betterCaves.enableGlobalWhitelist || BetterCaves.whitelistedDimensions.contains(dimensionName);
    }
}

