/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.world.carver;

import com.google.common.collect.ImmutableSet;
import com.yungnickyoung.minecraft.bettercaves.util.BetterCavesUtils;
import java.util.BitSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_3614;

public class CarverUtils {
    private static final class_2680 CAVE_AIR = class_2246.field_10543.method_9564();
    private static final class_2680 WATER = class_2246.field_10382.method_9564();
    private static final class_2680 SAND = class_2246.field_10102.method_9564();
    private static final class_2680 RED_SAND = class_2246.field_10534.method_9564();
    private static final class_2680 SANDSTONE = class_2246.field_9979.method_9564();
    private static final class_2680 RED_SANDSTONE = class_2246.field_10344.method_9564();
    private static final class_2680 GRAVEL = class_2246.field_10255.method_9564();
    private static final class_2680 ANDESITE = class_2246.field_10115.method_9564();
    public static Set<class_2248> carvableBlocks = ImmutableSet.of((Object)class_2246.field_10340, (Object)class_2246.field_10474, (Object)class_2246.field_10508, (Object)class_2246.field_10115, (Object)class_2246.field_10566, (Object)class_2246.field_10253, (Object[])new class_2248[]{class_2246.field_10520, class_2246.field_10219, class_2246.field_10415, class_2246.field_10611, class_2246.field_10184, class_2246.field_10015, class_2246.field_10325, class_2246.field_10143, class_2246.field_10014, class_2246.field_10444, class_2246.field_10349, class_2246.field_10590, class_2246.field_10235, class_2246.field_10570, class_2246.field_10409, class_2246.field_10123, class_2246.field_10526, class_2246.field_10328, class_2246.field_10626, class_2246.field_9979, class_2246.field_10344, class_2246.field_10402, class_2246.field_10477, class_2246.field_10225});
    public static Set<class_2248> liquidCarvableBlocks = ImmutableSet.of((Object)class_2246.field_10340, (Object)class_2246.field_10474, (Object)class_2246.field_10508, (Object)class_2246.field_10115, (Object)class_2246.field_10566, (Object)class_2246.field_10253, (Object[])new class_2248[]{class_2246.field_10520, class_2246.field_10219, class_2246.field_10415, class_2246.field_10611, class_2246.field_10184, class_2246.field_10015, class_2246.field_10325, class_2246.field_10143, class_2246.field_10014, class_2246.field_10444, class_2246.field_10349, class_2246.field_10590, class_2246.field_10235, class_2246.field_10570, class_2246.field_10409, class_2246.field_10123, class_2246.field_10526, class_2246.field_10328, class_2246.field_10626, class_2246.field_9979, class_2246.field_10344, class_2246.field_10402, class_2246.field_10477, class_2246.field_10102, class_2246.field_10255, class_2246.field_10382, class_2246.field_10164, class_2246.field_10540, class_2246.field_10124, class_2246.field_10543, class_2246.field_10225});
    private static final ImmutableSet<class_2680> DEBUG_BLOCKS = ImmutableSet.of((Object)class_2246.field_10205.method_9564(), (Object)class_2246.field_10161.method_9564(), (Object)class_2246.field_10445.method_9564(), (Object)class_2246.field_10002.method_9564(), (Object)class_2246.field_10234.method_9564(), (Object)class_2246.field_10104.method_9564(), (Object[])new class_2680[0]);

    private CarverUtils() {
    }

    public static void carveBlock(class_2791 chunkIn, class_2338 blockPos, class_2680 airBlockState, class_2680 liquidBlockState, int liquidAltitude, boolean replaceGravel, BitSet carvingMask) {
        int bitIndex = blockPos.method_10263() & 0xF | (blockPos.method_10260() & 0xF) << 4 | blockPos.method_10264() << 8;
        carvingMask.set(bitIndex);
        class_2338 blockPosAbove = blockPos.method_10084();
        class_2338 blockPosBelow = blockPos.method_10074();
        class_1959 biome = chunkIn.method_12036().method_16359(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260());
        class_2680 biomeTopBlockState = biome.method_30970().method_30985().method_15337();
        class_2680 biomeFillerBlockState = biome.method_30970().method_30985().method_15336();
        class_2680 blockState = chunkIn.method_8320(blockPos);
        class_2680 blockStateAbove = chunkIn.method_8320(blockPosAbove);
        class_2680 blockStateBelow = chunkIn.method_8320(blockPosBelow);
        if (!CarverUtils.canReplaceBlock(blockState, blockStateAbove) && blockState != biomeTopBlockState && blockState != biomeFillerBlockState) {
            return;
        }
        if (airBlockState == CAVE_AIR && blockPos.method_10264() <= liquidAltitude) {
            if (liquidBlockState != null) {
                chunkIn.method_12010(blockPos, liquidBlockState, false);
            }
        } else {
            if (airBlockState == CAVE_AIR && CarverUtils.isWaterAdjacent(chunkIn, blockPos)) {
                return;
            }
            if (blockState == biomeTopBlockState && CarverUtils.canReplaceBlock(blockStateBelow, CAVE_AIR)) {
                chunkIn.method_12010(blockPosBelow, biomeTopBlockState, false);
            }
            if (blockStateAbove == SAND) {
                chunkIn.method_12010(blockPosAbove, SANDSTONE, false);
            } else if (blockStateAbove == RED_SAND) {
                chunkIn.method_12010(blockPosAbove, RED_SANDSTONE, false);
            }
            if (replaceGravel && blockStateAbove == GRAVEL) {
                chunkIn.method_12010(blockPosAbove, ANDESITE, false);
            }
            chunkIn.method_12010(blockPos, airBlockState, false);
        }
    }

    public static void carveBlock(class_2791 chunkIn, class_2338 blockPos, class_2680 liquidBlockState, int liquidAltitude, boolean replaceGravel, BitSet carvingMask) {
        CarverUtils.carveBlock(chunkIn, blockPos, class_2246.field_10543.method_9564(), liquidBlockState, liquidAltitude, replaceGravel, carvingMask);
    }

    public static void carveBlock(class_2791 chunkIn, int x, int y, int z, class_2680 liquidBlockState, int liquidAltitude, boolean replaceGravel, BitSet carvingMask) {
        CarverUtils.carveBlock(chunkIn, new class_2338(x, y, z), class_2246.field_10543.method_9564(), liquidBlockState, liquidAltitude, replaceGravel, carvingMask);
    }

    public static void carveBlock(class_2791 chunkIn, int x, int y, int z, class_2680 airBlockState, class_2680 liquidBlockState, int liquidAltitude, boolean replaceGravel, BitSet carvingMask) {
        CarverUtils.carveBlock(chunkIn, new class_2338(x, y, z), airBlockState, liquidBlockState, liquidAltitude, replaceGravel, carvingMask);
    }

    public static void carveFloodedBlock(class_2791 chunkIn, Random rand, class_2338.class_2339 blockPos, class_2680 liquidBlockState, int liquidAltitude, boolean replaceGravel, BitSet carvingMask) {
        int bitIndex = blockPos.method_10263() & 0xF | (blockPos.method_10260() & 0xF) << 4 | blockPos.method_10264() << 8;
        carvingMask.set(bitIndex);
        class_1959 biome = chunkIn.method_12036().method_16359(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260());
        class_2680 biomeTopBlockState = biome.method_30970().method_30985().method_15337();
        class_2680 biomeFillerBlockState = biome.method_30970().method_30985().method_15336();
        class_2680 blockState = chunkIn.method_8320((class_2338)blockPos);
        class_2680 blockStateAbove = chunkIn.method_8320(blockPos.method_10084());
        if (!CarverUtils.canReplaceLiquidBlock(blockState, blockStateAbove) && blockState != biomeTopBlockState && blockState != biomeFillerBlockState) {
            return;
        }
        if (liquidBlockState != null && liquidBlockState.method_26204() == class_2246.field_10164 && blockPos.method_10264() == liquidAltitude + 1) {
            float f = rand.nextFloat();
            if (f < 0.25f) {
                chunkIn.method_12010((class_2338)blockPos, class_2246.field_10092.method_9564(), false);
                chunkIn.method_12013().method_8676((class_2338)blockPos, (Object)class_2246.field_10092, 0);
            } else {
                chunkIn.method_12010((class_2338)blockPos, class_2246.field_10540.method_9564(), false);
            }
        } else if (liquidBlockState != null && blockPos.method_10264() <= liquidAltitude) {
            chunkIn.method_12010((class_2338)blockPos, liquidBlockState, false);
        } else {
            chunkIn.method_12010((class_2338)blockPos, WATER, false);
            int x = blockPos.method_10263();
            int y = blockPos.method_10264();
            int z = blockPos.method_10260();
            for (class_2350 direction : class_2350.class_2353.field_11062) {
                int j = blockPos.method_10263() + direction.method_10148();
                int k = blockPos.method_10260() + direction.method_10165();
                if (j >> 4 == chunkIn.method_12004().field_9181 && k >> 4 == chunkIn.method_12004().field_9180 && !chunkIn.method_8320((class_2338)blockPos.method_10103(j, y, k)).method_26215()) continue;
                chunkIn.method_12010((class_2338)blockPos, WATER, false);
                chunkIn.method_12014().method_8676((class_2338)blockPos, (Object)WATER.method_26227().method_15772(), 0);
                break;
            }
            blockPos.method_10103(x, y, z);
            if (replaceGravel && blockStateAbove == GRAVEL) {
                chunkIn.method_12010(blockPos.method_10084(), ANDESITE, false);
            }
        }
    }

    public static void carveFloodedBlock(class_2791 chunkIn, Random rand, class_2338.class_2339 blockPos, class_2680 liquidBlockState, int liquidAltitude, BitSet carvingMask) {
        CarverUtils.carveFloodedBlock(chunkIn, rand, blockPos, liquidBlockState, liquidAltitude, false, carvingMask);
    }

    public static void debugCarveBlock(class_2791 chunkIn, class_2338 blockPos, class_2680 blockState, boolean digBlock) {
        if (DEBUG_BLOCKS.contains((Object)chunkIn.method_8320(blockPos))) {
            return;
        }
        if (digBlock) {
            chunkIn.method_12010(blockPos, blockState, false);
        } else {
            chunkIn.method_12010(blockPos, class_2246.field_10124.method_9564(), false);
        }
    }

    public static void debugCarveBlock(class_2791 chunkIn, int x, int y, int z, class_2680 blockState, boolean digBlock) {
        CarverUtils.debugCarveBlock(chunkIn, new class_2338(x, y, z), blockState, digBlock);
    }

    public static boolean canReplaceBlock(class_2680 blockState, class_2680 blockStateAbove) {
        class_2248 block = blockState.method_26204();
        if (blockState.method_26207() == class_3614.field_15923 || blockState.method_26207() == class_3614.field_15932) {
            return false;
        }
        if (blockStateAbove.method_26207() == class_3614.field_15932) {
            return false;
        }
        if (block == class_2246.field_10362 || block == class_2246.field_10194) {
            return false;
        }
        if (blockState.method_26207() == class_3614.field_15914 || blockState.method_26207() == class_3614.field_15936 || blockState.method_26207() == class_3614.field_15941) {
            return true;
        }
        if (carvableBlocks.contains(block)) {
            return true;
        }
        return (block == class_2246.field_10102 || block == class_2246.field_10255) && blockStateAbove.method_26207() != class_3614.field_15920;
    }

    public static boolean canReplaceLiquidBlock(class_2680 blockState, class_2680 blockStateAbove) {
        class_2248 block = blockState.method_26204();
        if (blockState.method_26207() == class_3614.field_15923 || blockState.method_26207() == class_3614.field_15932) {
            return false;
        }
        if (blockStateAbove.method_26207() == class_3614.field_15932) {
            return false;
        }
        if (block == class_2246.field_10362 || block == class_2246.field_10194) {
            return false;
        }
        if (blockState.method_26207() == class_3614.field_15914) {
            return true;
        }
        return liquidCarvableBlocks.contains(block);
    }

    private static boolean isWaterAdjacent(class_2791 chunkIn, class_2338 blockPos) {
        int localX = BetterCavesUtils.getLocal(blockPos.method_10263());
        int localZ = BetterCavesUtils.getLocal(blockPos.method_10260());
        int y = blockPos.method_10264();
        return y < 255 && chunkIn.method_8320(blockPos.method_10084()).method_26207() == class_3614.field_15920 || localZ > 0 && chunkIn.method_8320(blockPos.method_10095()).method_26207() == class_3614.field_15920 || localX < 15 && chunkIn.method_8320(blockPos.method_10078()).method_26207() == class_3614.field_15920 || localZ < 15 && chunkIn.method_8320(blockPos.method_10072()).method_26207() == class_3614.field_15920 || localX > 0 && chunkIn.method_8320(blockPos.method_10067()).method_26207() == class_3614.field_15920;
    }
}

