/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.world.carver.cavern;

import com.yungnickyoung.minecraft.bettercaves.BetterCaves;
import com.yungnickyoung.minecraft.bettercaves.enums.CavernType;
import com.yungnickyoung.minecraft.bettercaves.noise.NoiseGen;
import com.yungnickyoung.minecraft.bettercaves.world.carver.CarverSettings;
import com.yungnickyoung.minecraft.bettercaves.world.carver.CarverUtils;
import com.yungnickyoung.minecraft.bettercaves.world.carver.ICarver;
import com.yungnickyoung.minecraft.bettercaves.world.carver.cavern.CavernCarverBuilder;
import java.util.BitSet;
import java.util.Random;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2791;

public class CavernCarver
implements ICarver {
    private CarverSettings settings;
    private NoiseGen noiseGen;
    private CavernType cavernType;
    private int bottomY;
    private int topY;

    public CavernCarver(CavernCarverBuilder builder) {
        this.settings = builder.getSettings();
        this.noiseGen = new NoiseGen(this.settings.getSeed(), this.settings.isFastNoise(), this.settings.getNoiseSettings(), this.settings.getNumGens(), this.settings.getyCompression(), this.settings.getXzCompression());
        this.cavernType = builder.getCavernType();
        this.bottomY = builder.getBottomY();
        this.topY = builder.getTopY();
        if (this.bottomY > this.topY) {
            BetterCaves.LOGGER.warn("Warning: Min altitude for caverns should not be greater than max altitude.");
            BetterCaves.LOGGER.warn("Using default values...");
            this.bottomY = 1;
            this.topY = 35;
        }
    }

    public void carveColumn(class_2791 chunk, class_2338 colPos, int topY, float smoothAmp, double[][] noises, class_2680 liquidBlock, boolean flooded, BitSet carvingMask) {
        int localX = colPos.method_10263() & 0xF;
        int localZ = colPos.method_10260() & 0xF;
        if (this.bottomY < 0) {
            this.bottomY = 0;
        }
        if (this.bottomY > 255) {
            this.bottomY = 255;
        }
        if (topY < 2) {
            topY = 2;
        }
        if (topY > 255) {
            topY = 255;
        }
        int topTransitionBoundary = (topY -= 2) - 6;
        int bottomTransitionBoundary = this.bottomY + 3;
        if (this.cavernType == CavernType.FLOORED) {
            bottomTransitionBoundary = this.bottomY < this.settings.getLiquidAltitude() ? this.settings.getLiquidAltitude() + 8 : this.bottomY + 7;
        }
        topTransitionBoundary = Math.max(topTransitionBoundary, 1);
        bottomTransitionBoundary = Math.min(bottomTransitionBoundary, 255);
        class_2338.class_2339 localPos = new class_2338.class_2339(localX, 1, localZ);
        for (int y = topY; y >= this.bottomY && (y > this.settings.getLiquidAltitude() || liquidBlock != null); --y) {
            double[] noiseBlock;
            boolean digBlock = false;
            float noise = 1.0f;
            for (double n : noiseBlock = noises[y - this.bottomY]) {
                noise = (float)((double)noise * n);
            }
            float noiseThreshold = this.settings.getNoiseThreshold();
            if (y >= topTransitionBoundary) {
                noiseThreshold *= (float)(y - topY) / (float)(topTransitionBoundary - topY);
            }
            if (y < bottomTransitionBoundary) {
                noiseThreshold *= (float)(y - this.bottomY) / (float)(bottomTransitionBoundary - this.bottomY);
            }
            if (smoothAmp < 1.0f) {
                noiseThreshold *= smoothAmp;
            }
            if (noise < noiseThreshold) {
                digBlock = true;
            }
            localPos.method_10103(localX, y, localZ);
            if (this.settings.isEnableDebugVisualizer()) {
                CarverUtils.debugCarveBlock(chunk, (class_2338)localPos, this.settings.getDebugBlock(), digBlock);
                continue;
            }
            if (!digBlock) continue;
            if (flooded) {
                CarverUtils.carveFloodedBlock(chunk, new Random(), localPos, liquidBlock, this.settings.getLiquidAltitude(), this.settings.isReplaceFloatingGravel(), carvingMask);
                continue;
            }
            CarverUtils.carveBlock(chunk, (class_2338)localPos, liquidBlock, this.settings.getLiquidAltitude(), this.settings.isReplaceFloatingGravel(), carvingMask);
        }
    }

    public NoiseGen getNoiseGen() {
        return this.noiseGen;
    }

    public CarverSettings getSettings() {
        return this.settings;
    }

    @Override
    public int getPriority() {
        return this.settings.getPriority();
    }

    public int getBottomY() {
        return this.bottomY;
    }

    @Override
    public int getTopY() {
        return this.topY;
    }
}

