/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.corelib;

import de.maxhenkel.voicechat.corelib.config.ConfigBase;
import de.maxhenkel.voicechat.corelib.config.DynamicConfig;
import de.maxhenkel.voicechat.corelib.net.Message;
import java.nio.file.Path;
import java.util.function.Consumer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.storage.FolderName;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLConfig;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public class CommonRegistry {
    private static final FolderName SERVERCONFIG = new FolderName("serverconfig");
    private static final Path DEFAULT_CONFIG_PATH = FMLPaths.GAMEDIR.get().resolve(FMLConfig.defaultConfigPath());

    public static SimpleChannel registerChannel(String modId, String name, int protocolVersion) {
        String protocolVersionString = String.valueOf(protocolVersion);
        return NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation(modId, name), () -> String.valueOf(protocolVersion), s -> s.equals(protocolVersionString), s -> s.equals(protocolVersionString));
    }

    public static SimpleChannel registerChannel(String modId, String name) {
        return NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation(modId, name), () -> "1.0.0", s -> true, s -> true);
    }

    public static <T extends Message<?>> void registerMessage(SimpleChannel channel, int id, Class<T> message) {
        channel.registerMessage(id, message, Message::toBytes, buf -> {
            try {
                Message msg = (Message)message.newInstance();
                return msg.fromBytes((PacketBuffer)buf);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }, (msg, fun) -> {
            if (msg.getExecutingSide().equals((Object)Dist.CLIENT)) {
                msg.executeClientSide((NetworkEvent.Context)fun.get());
            } else if (msg.getExecutingSide().equals((Object)Dist.DEDICATED_SERVER)) {
                msg.executeServerSide((NetworkEvent.Context)fun.get());
            }
        });
    }

    public static <T extends Entity> EntityType<T> registerEntity(String modId, String name, EntityClassification classification, Class<? extends Entity> entityClass, Consumer<EntityType.Builder<T>> builderConsumer) {
        EntityType.Builder builder = EntityType.Builder.func_220322_a((type, world) -> {
            try {
                try {
                    return (Entity)entityClass.getConstructor(EntityType.class, World.class).newInstance(type, world);
                }
                catch (NoSuchMethodException e) {
                    return (Entity)entityClass.getConstructor(World.class).newInstance(world);
                }
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }, (EntityClassification)classification);
        builderConsumer.accept(builder);
        EntityType type2 = builder.func_206830_a(modId + ":" + name);
        type2.setRegistryName(new ResourceLocation(modId, name));
        return type2;
    }

    public static <T extends ConfigBase> T registerConfig(ModConfig.Type type, Class<T> configClass, boolean registerListener) {
        ConfigBase config;
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        try {
            config = (ConfigBase)configClass.getConstructor(ForgeConfigSpec.Builder.class).newInstance(builder);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        ForgeConfigSpec spec = builder.build();
        ModLoadingContext.get().registerConfig(type, spec);
        config.setConfigSpec(spec);
        if (registerListener) {
            Consumer<ModConfig.ModConfigEvent> consumer = evt -> {
                if (evt.getConfig().getType() == type) {
                    config.onReload((ModConfig.ModConfigEvent)evt);
                }
            };
            FMLJavaModLoadingContext.get().getModEventBus().addListener(consumer);
        }
        return (T)config;
    }

    public static <T extends ConfigBase> T registerConfig(ModConfig.Type type, Class<T> configClass) {
        return CommonRegistry.registerConfig(type, configClass, false);
    }

    public static <T extends DynamicConfig> T registerDynamicConfig(DynamicConfig.DynamicConfigType type, String folderName, String configName, Class<T> configClass) {
        try {
            DynamicConfig config = (DynamicConfig)configClass.newInstance();
            String configFileName = configName + ".toml";
            if (type.equals((Object)DynamicConfig.DynamicConfigType.SERVER)) {
                Consumer<FMLServerAboutToStartEvent> consumer = event -> {
                    Path serverConfig = event.getServer().func_240776_a_(SERVERCONFIG).resolve(folderName);
                    serverConfig.toFile().mkdirs();
                    Path configPath = serverConfig.resolve(configFileName);
                    Path defaultPath = DEFAULT_CONFIG_PATH.resolve(folderName).resolve(configFileName);
                    config.init(configPath, defaultPath);
                };
                MinecraftForge.EVENT_BUS.addListener(consumer);
            } else {
                Path commonConfig = FMLPaths.CONFIGDIR.get().resolve(folderName);
                commonConfig.toFile().mkdirs();
                Path configPath = commonConfig.resolve(configFileName);
                config.init(configPath);
            }
            return (T)config;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

