/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.debug;

import com.electronwill.nightconfig.core.UnmodifiableConfig;
import de.maxhenkel.voicechat.Main;
import de.maxhenkel.voicechat.ServerConfig;
import de.maxhenkel.voicechat.voice.client.AudioChannelConfig;
import de.maxhenkel.voicechat.voice.client.Client;
import de.maxhenkel.voicechat.voice.client.DataLines;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.commons.io.FileUtils;

public class DebugReport {
    private static final SimpleDateFormat FILE_FORMAT = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
    private static final SimpleDateFormat TEXT_FORMAT = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
    private final StringBuilder builder = new StringBuilder();

    private DebugReport() {
    }

    public static void generateReport(PlayerEntity player) {
        try {
            Path path = DebugReport.generateReport();
            player.func_145747_a((ITextComponent)new TranslationTextComponent("message.voicechat.saved_debug_report", new Object[]{new StringTextComponent(path.normalize().toString()).func_240699_a_(TextFormatting.GRAY).func_240700_a_(style -> style.func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new TranslationTextComponent("message.voicechat.open"))).func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_FILE, path.normalize().toString())))}), Util.field_240973_b_);
        }
        catch (IOException e) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("message.voicechat.saved_debug_report_failed", new Object[]{e.getMessage()}), Util.field_240973_b_);
            e.printStackTrace();
        }
    }

    public static Path generateReport() throws IOException {
        DebugReport report = new DebugReport();
        report.generate();
        Path debugFolder = report.getDebugFolder();
        debugFolder.toFile().mkdirs();
        Path location = debugFolder.resolve("voicechat-" + FILE_FORMAT.format(Calendar.getInstance().getTime()) + ".txt");
        FileUtils.writeStringToFile((File)location.toFile(), (String)report.builder.toString(), (Charset)StandardCharsets.UTF_8);
        Main.LOGGER.info("Saved voicechat debug report to {}", (Object)location.normalize().toString());
        return location;
    }

    private Path getDebugFolder() {
        return Minecraft.func_71410_x().field_71412_D.toPath().resolve("debug");
    }

    private void generate() {
        this.appendHeader();
        this.divider();
        this.appendMods();
        this.divider();
        this.appendKeyBinds();
        this.divider();
        this.appendMics();
        this.divider();
        this.appendSpeakers();
        this.divider();
        this.appendOS();
        this.divider();
        this.appendJava();
        this.divider();
        this.appendServer();
        this.divider();
        this.appendConfig();
        this.divider();
        this.appendPlayerVolumes();
    }

    private void appendHeader() {
        this.addLine("Simple Voice Chat Debug Report");
        this.addLine(TEXT_FORMAT.format(Calendar.getInstance().getTime()));
        this.addLine("");
    }

    private void appendMods() {
        this.addLine("Loaded mods");
        this.addLine("");
        for (ModInfo mod : ModList.get().getMods()) {
            this.addLine("Mod ID: " + mod.getModId());
            this.addLine("Name: " + mod.getDisplayName());
            this.addLine("Version: " + mod.getVersion().getQualifier());
            this.addLine("Dependencies: " + mod.getDependencies().stream().map(IModInfo.ModVersion::getModId).collect(Collectors.joining(", ")));
            this.addLine("");
        }
    }

    private void appendKeyBinds() {
        this.addLine("Keybinds");
        this.addLine("");
        for (KeyBinding mapping : Minecraft.func_71410_x().field_71474_y.field_74324_K) {
            this.addLine(mapping.func_151464_g() + "(" + mapping.func_151466_e() + "): " + mapping.getKey().func_197935_d() + " (" + mapping.func_197977_i().func_197935_d() + ")");
        }
        this.addLine("");
    }

    private void appendMics() {
        this.addLine("Input Devices");
        this.addLine("");
        for (String mic : DataLines.getMicrophoneNames()) {
            TargetDataLine microphone = DataLines.getMicrophoneByName(mic);
            if (microphone == null) {
                this.addLine(mic + ": Not found");
                continue;
            }
            this.addLine(mic + ": " + microphone.getFormat().getSampleRate() + " Hz " + microphone.getFormat().getEncoding().toString() + ", " + microphone.getFormat().getFrameSize() + " bytes, " + microphone.getFormat().getChannels() + " channels, " + (microphone.getFormat().isBigEndian() ? "BE" : "LE"));
        }
        this.addLine("");
    }

    private void appendSpeakers() {
        this.addLine("Output Devices");
        this.addLine("");
        for (String name : DataLines.getSpeakerNames()) {
            SourceDataLine speaker = DataLines.getSpeakerByName(name);
            if (speaker == null) {
                this.addLine(name + ": Not found");
                continue;
            }
            this.addLine(name + ": " + speaker.getFormat().getSampleRate() + " Hz " + speaker.getFormat().getEncoding().toString() + ", " + speaker.getFormat().getFrameSize() + " bytes, " + speaker.getFormat().getChannels() + " channels, " + (speaker.getFormat().isBigEndian() ? "BE" : "LE"));
        }
        this.addLine("");
    }

    private void appendOS() {
        this.addLine("Operating System");
        this.addLine(System.getProperty("os.name"));
        this.addLine(System.getProperty("os.version"));
        this.addLine(System.getProperty("os.arch"));
        this.addLine("");
    }

    private void appendJava() {
        this.addLine("Java");
        this.addLine("");
        this.addLine("Version: " + System.getProperty("java.version"));
        this.addLine("");
    }

    private void appendServer() {
        Client client;
        this.addLine("Connection");
        Minecraft mc = Minecraft.func_71410_x();
        this.addLine(mc.func_71387_A() ? "Local Server" : "Dedicated Server");
        if (!mc.func_71387_A()) {
            try {
                SocketAddress socketAddress = mc.func_147114_u().func_147298_b().channel().remoteAddress();
                this.addLine("Server address: " + socketAddress.toString());
            }
            catch (Exception e) {
                this.addLine("Server address: N/A (" + e.getMessage() + ")");
            }
        }
        if ((client = Main.CLIENT_VOICE_EVENTS.getClient()) != null) {
            this.addLine("");
            this.addLine("Voice chat connected");
            this.addLine("Address: " + client.getAddress().toString());
            this.addLine("Port: " + client.getPort());
            this.addLine("Codec: " + ((ServerConfig.Codec)((Object)Main.SERVER_CONFIG.voiceChatCodec.get())).toString());
            this.addLine((Boolean)Main.SERVER_CONFIG.groupsEnabled.get() != false ? "Groups enabled" : "Groups disabled");
            this.addLine("Sample rate: " + AudioChannelConfig.getSampleRate());
            this.addLine("Frame size: " + AudioChannelConfig.getFrameSize());
            this.addLine("MTU size: " + Main.SERVER_CONFIG.voiceChatMtuSize.get());
            this.addLine("Distance: " + Main.SERVER_CONFIG.voiceChatDistance.get());
            this.addLine("Fade distance: " + Main.SERVER_CONFIG.voiceChatFadeDistance.get());
            this.addLine("Authenticated: " + client.isAuthenticated());
            this.addLine("Recording: " + (client.getRecorder() != null));
            this.addLine("");
        } else {
            this.addLine("");
            this.addLine("Voice chat not connected");
            this.addLine("");
        }
    }

    private void appendConfig() {
        this.addLine("Client Configuration");
        this.addLine("");
        for (UnmodifiableConfig.Entry o : Main.CLIENT_CONFIG.getConfigSpec().entrySet()) {
            try {
                ForgeConfigSpec.ValueSpec value = (ForgeConfigSpec.ValueSpec)o.getValue();
                Field supplier = value.getClass().getDeclaredField("supplier");
                supplier.setAccessible(true);
                this.addLine(o.getKey() + ": " + ((Supplier)supplier.get(value)).get());
            }
            catch (Exception exception) {}
        }
        this.addLine("");
    }

    private void appendPlayerVolumes() {
        this.addLine("Player volumes");
        this.addLine("");
        for (Map.Entry<Object, Object> o : Main.VOLUME_CONFIG.getProperties().entrySet()) {
            this.addLine(o.getKey() + ": " + o.getValue());
        }
        this.addLine("");
    }

    private void divider() {
        this.addLine("#####################################################################################################\n");
    }

    private void addLine(String str) {
        this.builder.append(str).append("\n");
    }
}

