/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.client;

import de.maxhenkel.voicechat.Main;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;

public class DataLines {
    @Nullable
    public static TargetDataLine getMicrophone() {
        TargetDataLine mic;
        String micName = (String)Main.CLIENT_CONFIG.microphone.get();
        if (!micName.isEmpty() && (mic = DataLines.getMicrophoneByName(micName)) != null) {
            return mic;
        }
        return DataLines.getDefaultMicrophone();
    }

    @Nullable
    public static SourceDataLine getSpeaker() {
        SourceDataLine speaker;
        String speakerName = (String)Main.CLIENT_CONFIG.speaker.get();
        if (!speakerName.isEmpty() && (speaker = DataLines.getSpeakerByName(speakerName)) != null) {
            return speaker;
        }
        return DataLines.getDefaultSpeaker();
    }

    @Nullable
    public static TargetDataLine getDefaultMicrophone() {
        return DataLines.getDefaultDevice(TargetDataLine.class);
    }

    @Nullable
    public static SourceDataLine getDefaultSpeaker() {
        return DataLines.getDefaultDevice(SourceDataLine.class);
    }

    @Nullable
    public static <T> T getDefaultDevice(Class<T> lineClass) {
        DataLine.Info info = new DataLine.Info(lineClass, null);
        try {
            return lineClass.cast(AudioSystem.getLine(info));
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public static TargetDataLine getMicrophoneByName(String name) {
        return DataLines.getDeviceByName(TargetDataLine.class, name);
    }

    @Nullable
    public static SourceDataLine getSpeakerByName(String name) {
        return DataLines.getDeviceByName(SourceDataLine.class, name);
    }

    @Nullable
    public static <T> T getDeviceByName(Class<T> lineClass, String name) {
        Mixer.Info[] mixers;
        for (Mixer.Info mixerInfo : mixers = AudioSystem.getMixerInfo()) {
            Line.Info lineInfo;
            Mixer mixer = AudioSystem.getMixer(mixerInfo);
            if (!mixer.isLineSupported(lineInfo = new Line.Info(lineClass)) || !mixerInfo.getName().equals(name)) continue;
            try {
                return lineClass.cast(mixer.getLine(lineInfo));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static List<String> getMicrophoneNames() {
        return DataLines.getDeviceNames(TargetDataLine.class);
    }

    public static List<String> getSpeakerNames() {
        return DataLines.getDeviceNames(SourceDataLine.class);
    }

    public static List<String> getDeviceNames(Class<?> lineClass) {
        Mixer.Info[] mixers;
        ArrayList<String> names = new ArrayList<String>();
        for (Mixer.Info mixerInfo : mixers = AudioSystem.getMixerInfo()) {
            Line.Info lineInfo;
            Mixer mixer = AudioSystem.getMixer(mixerInfo);
            if (!mixer.isLineSupported(lineInfo = new Line.Info(lineClass))) continue;
            names.add(mixerInfo.getName());
        }
        return names;
    }
}

