/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.api;

import it.unimi.dsi.fastutil.objects.ObjectRBTreeSet;
import java.util.Collection;
import java.util.Objects;
import java.util.SortedSet;
import net.minecraft.class_1297;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import virtuoel.pehkui.api.ScaleEventCallback;
import virtuoel.pehkui.api.ScaleModifier;
import virtuoel.pehkui.api.ScaleRegistries;
import virtuoel.pehkui.api.ScaleType;

public class ScaleData {
    public static final ScaleData IDENTITY = Builder.create().buildImmutable(1.0f);
    private float baseScale;
    private float prevBaseScale;
    private float initialScale;
    private float targetScale;
    private int scaleTicks;
    private int totalScaleTicks;
    private boolean shouldSync = false;
    private final ScaleType scaleType;
    @Nullable
    private final class_1297 entity;
    private final SortedSet<ScaleModifier> baseValueModifiers = new ObjectRBTreeSet();

    @ApiStatus.Internal
    protected ScaleData(ScaleType scaleType, @Nullable class_1297 entity) {
        float defaultBaseScale;
        this.scaleType = scaleType;
        this.entity = entity;
        this.baseScale = defaultBaseScale = scaleType.getDefaultBaseScale();
        this.prevBaseScale = defaultBaseScale;
        this.initialScale = defaultBaseScale;
        this.targetScale = defaultBaseScale;
        this.scaleTicks = 0;
        this.totalScaleTicks = scaleType.getDefaultTickDelay();
        this.getBaseValueModifiers().addAll(this.getScaleType().getDefaultBaseValueModifiers());
    }

    public void tick() {
        float currScale = this.getBaseScale();
        float targetScale = this.getTargetScale();
        int scaleTickDelay = this.getScaleTickDelay();
        if (currScale != targetScale) {
            this.prevBaseScale = currScale;
            if (this.scaleTicks >= scaleTickDelay) {
                this.initialScale = targetScale;
                this.scaleTicks = 0;
                this.setBaseScale(targetScale);
            } else {
                ++this.scaleTicks;
                float nextScale = currScale + (targetScale - this.initialScale) / (float)scaleTickDelay;
                this.setBaseScale(nextScale);
            }
        } else if (this.prevBaseScale != currScale) {
            this.prevBaseScale = currScale;
        }
    }

    public ScaleType getScaleType() {
        return this.scaleType;
    }

    @Nullable
    public class_1297 getEntity() {
        return this.entity;
    }

    public SortedSet<ScaleModifier> getBaseValueModifiers() {
        return this.baseValueModifiers;
    }

    @Deprecated
    protected float computeScale(float value, Collection<ScaleModifier> modifiers, float delta) {
        for (ScaleModifier m : modifiers) {
            value = m.modifyScale(this, value, delta);
        }
        return value;
    }

    public float getBaseScale() {
        return this.getBaseScale(1.0f);
    }

    public float getBaseScale(float delta) {
        return delta == 1.0f ? this.baseScale : class_3532.method_16439((float)delta, (float)this.getPrevBaseScale(), (float)this.baseScale);
    }

    public void setBaseScale(float scale) {
        scale = (float)this.getScaleType().clampBaseScale(this, scale);
        this.prevBaseScale = this.getBaseScale();
        this.baseScale = scale;
        this.onUpdate();
    }

    public float getScale() {
        return this.getScale(1.0f);
    }

    public float getScale(float delta) {
        float value = this.getBaseScale(delta);
        for (ScaleModifier m : this.getBaseValueModifiers()) {
            value = m.modifyScale(this, value, delta);
        }
        return value;
    }

    public void setScale(float scale) {
        this.setBaseScale(scale);
        this.setTargetScale(scale);
    }

    public float getInitialScale() {
        return this.initialScale;
    }

    public float getTargetScale() {
        return this.targetScale;
    }

    public void setTargetScale(float targetScale) {
        targetScale = (float)this.getScaleType().clampTargetScale(this, targetScale);
        this.initialScale = this.getBaseScale();
        this.targetScale = targetScale;
        this.scaleTicks = 0;
        this.markForSync(true);
    }

    public int getScaleTickDelay() {
        return this.totalScaleTicks;
    }

    public void setScaleTickDelay(int ticks) {
        this.totalScaleTicks = ticks;
        this.markForSync(true);
    }

    public float getPrevScale() {
        float value = this.getPrevBaseScale();
        for (ScaleModifier m : this.getBaseValueModifiers()) {
            value = m.modifyPrevScale(this, value);
        }
        return value;
    }

    public float getPrevBaseScale() {
        return this.prevBaseScale;
    }

    public void markForSync(boolean sync) {
        class_1297 e = this.getEntity();
        if (e != null && e.field_6002 != null && !e.field_6002.field_9236) {
            this.shouldSync = sync;
        }
    }

    public boolean shouldSync() {
        return this.shouldSync;
    }

    public void onUpdate() {
        this.markForSync(true);
        ((ScaleEventCallback)this.getScaleType().getScaleChangedEvent().invoker()).onEvent(this);
    }

    public class_2540 toPacket(class_2540 buffer) {
        ObjectRBTreeSet syncedModifiers = new ObjectRBTreeSet();
        syncedModifiers.addAll(this.getBaseValueModifiers());
        syncedModifiers.removeAll(this.getScaleType().getDefaultBaseValueModifiers());
        buffer.writeFloat(this.baseScale).writeFloat(this.prevBaseScale).writeFloat(this.initialScale).writeFloat(this.targetScale).writeInt(this.scaleTicks).writeInt(this.totalScaleTicks).writeInt(syncedModifiers.size());
        for (ScaleModifier modifier : syncedModifiers) {
            buffer.method_10812(ScaleRegistries.getId(ScaleRegistries.SCALE_MODIFIERS, modifier));
        }
        return buffer;
    }

    public void readNbt(class_2487 tag) {
        ScaleType type = this.getScaleType();
        this.baseScale = tag.method_10545("scale") ? tag.method_10583("scale") : type.getDefaultBaseScale();
        this.prevBaseScale = tag.method_10545("previous") ? tag.method_10583("previous") : this.baseScale;
        this.initialScale = tag.method_10545("initial") ? tag.method_10583("initial") : this.baseScale;
        this.targetScale = tag.method_10545("target") ? tag.method_10583("target") : this.baseScale;
        this.scaleTicks = tag.method_10545("ticks") ? tag.method_10550("ticks") : 0;
        this.totalScaleTicks = tag.method_10545("total_ticks") ? tag.method_10550("total_ticks") : type.getDefaultTickDelay();
        SortedSet<ScaleModifier> baseValueModifiers = this.getBaseValueModifiers();
        baseValueModifiers.clear();
        baseValueModifiers.addAll(type.getDefaultBaseValueModifiers());
        if (tag.method_10545("baseValueModifiers")) {
            class_2499 modifiers = tag.method_10554("baseValueModifiers", 8);
            for (int i = 0; i < modifiers.size(); ++i) {
                class_2960 id = class_2960.method_12829((String)modifiers.method_10608(i));
                ScaleModifier modifier = ScaleRegistries.getEntry(ScaleRegistries.SCALE_MODIFIERS, id);
                if (modifier == null) continue;
                baseValueModifiers.add(modifier);
            }
        }
        this.onUpdate();
    }

    public class_2487 writeNbt(class_2487 tag) {
        float target;
        float initial;
        ScaleType type = this.getScaleType();
        float defaultBaseScale = type.getDefaultBaseScale();
        float scale = this.getBaseScale();
        if (scale != defaultBaseScale) {
            tag.method_10548("scale", scale);
        }
        if ((initial = this.getInitialScale()) != defaultBaseScale) {
            tag.method_10548("initial", initial);
        }
        if ((target = this.getTargetScale()) != defaultBaseScale) {
            tag.method_10548("target", target);
        }
        if (this.scaleTicks != 0) {
            tag.method_10569("ticks", this.scaleTicks);
        }
        if (this.totalScaleTicks != type.getDefaultTickDelay()) {
            tag.method_10569("total_ticks", this.totalScaleTicks);
        }
        ObjectRBTreeSet savedModifiers = new ObjectRBTreeSet();
        savedModifiers.addAll(this.getBaseValueModifiers());
        savedModifiers.removeAll(this.getScaleType().getDefaultBaseValueModifiers());
        if (!savedModifiers.isEmpty()) {
            class_2499 modifiers = new class_2499();
            for (ScaleModifier modifier : savedModifiers) {
                modifiers.add((Object)class_2509.field_11560.method_10639(ScaleRegistries.getId(ScaleRegistries.SCALE_MODIFIERS, modifier).toString()));
            }
            tag.method_10566("baseValueModifiers", (class_2520)modifiers);
        }
        return tag;
    }

    public ScaleData resetScale() {
        return this.resetScale(true);
    }

    public ScaleData resetScale(boolean notifyListener) {
        float defaultBaseScale;
        ScaleType type = this.getScaleType();
        this.baseScale = defaultBaseScale = type.getDefaultBaseScale();
        this.prevBaseScale = defaultBaseScale;
        this.initialScale = defaultBaseScale;
        this.targetScale = defaultBaseScale;
        this.scaleTicks = 0;
        this.totalScaleTicks = type.getDefaultTickDelay();
        SortedSet<ScaleModifier> baseValueModifiers = this.getBaseValueModifiers();
        baseValueModifiers.clear();
        baseValueModifiers.addAll(type.getDefaultBaseValueModifiers());
        if (notifyListener) {
            this.onUpdate();
        }
        return this;
    }

    public boolean isReset() {
        ScaleType type = this.getScaleType();
        float defaultBaseScale = type.getDefaultBaseScale();
        if (this.getBaseScale() != defaultBaseScale) {
            return false;
        }
        if (this.prevBaseScale != defaultBaseScale) {
            return false;
        }
        if (this.getInitialScale() != defaultBaseScale) {
            return false;
        }
        if (this.getTargetScale() != defaultBaseScale) {
            return false;
        }
        if (this.scaleTicks != 0) {
            return false;
        }
        if (this.getScaleTickDelay() != type.getDefaultTickDelay()) {
            return false;
        }
        return this.getBaseValueModifiers().equals(this.getScaleType().getDefaultBaseValueModifiers());
    }

    public ScaleData fromScale(ScaleData scaleData) {
        return this.fromScale(scaleData, true);
    }

    public ScaleData fromScale(ScaleData scaleData, boolean notifyListener) {
        this.baseScale = scaleData.getBaseScale();
        this.prevBaseScale = scaleData.getPrevBaseScale();
        this.initialScale = scaleData.getInitialScale();
        this.targetScale = scaleData.getTargetScale();
        this.scaleTicks = scaleData.scaleTicks;
        this.totalScaleTicks = scaleData.totalScaleTicks;
        if (notifyListener) {
            this.onUpdate();
        }
        return this;
    }

    public ScaleData averagedFromScales(ScaleData scaleData, ScaleData ... scales) {
        float scale = scaleData.getBaseScale();
        float prevScale = scaleData.prevBaseScale;
        float fromScale = scaleData.getInitialScale();
        float toScale = scaleData.getTargetScale();
        int scaleTicks = scaleData.scaleTicks;
        int totalScaleTicks = scaleData.totalScaleTicks;
        for (ScaleData data : scales) {
            scale += data.getBaseScale();
            prevScale += data.prevBaseScale;
            fromScale += data.getInitialScale();
            toScale += data.getTargetScale();
            scaleTicks += data.scaleTicks;
            totalScaleTicks += data.totalScaleTicks;
        }
        float count = scales.length + 1;
        this.baseScale = scale / count;
        this.prevBaseScale = prevScale / count;
        this.initialScale = fromScale / count;
        this.targetScale = toScale / count;
        this.scaleTicks = Math.round((float)scaleTicks / count);
        this.totalScaleTicks = Math.round((float)totalScaleTicks / count);
        this.onUpdate();
        return this;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.initialScale), Float.valueOf(this.prevBaseScale), Float.valueOf(this.baseScale), this.scaleTicks, Float.valueOf(this.targetScale), this.totalScaleTicks);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ScaleData)) {
            return false;
        }
        return this.equals((ScaleData)obj);
    }

    public boolean equals(ScaleData other) {
        if (this == other) {
            return true;
        }
        return Float.floatToIntBits(this.baseScale) == Float.floatToIntBits(other.baseScale) && Float.floatToIntBits(this.prevBaseScale) == Float.floatToIntBits(other.prevBaseScale) && Float.floatToIntBits(this.initialScale) == Float.floatToIntBits(other.initialScale) && Float.floatToIntBits(this.targetScale) == Float.floatToIntBits(other.targetScale) && this.scaleTicks == other.scaleTicks && this.totalScaleTicks == other.totalScaleTicks && Float.floatToIntBits(this.getScale()) == Float.floatToIntBits(other.getScale());
    }

    public static class Builder {
        private class_1297 entity = null;
        private ScaleType type = ScaleType.INVALID;

        public static Builder create() {
            return new Builder();
        }

        private Builder() {
        }

        public Builder type(ScaleType type) {
            this.type = type == null ? ScaleType.INVALID : type;
            return this;
        }

        public Builder entity(@Nullable class_1297 entity) {
            this.entity = entity;
            return this;
        }

        public ImmutableScaleData buildImmutable(float value) {
            return new ImmutableScaleData(value, this.type, this.entity);
        }

        public ScaleData build() {
            return new ScaleData(this.type, this.entity);
        }
    }

    public static class ImmutableScaleData
    extends ScaleData {
        protected ImmutableScaleData(float scale, ScaleType scaleType, @Nullable class_1297 entity) {
            super(scaleType, entity);
        }

        @Override
        public void tick() {
        }

        @Override
        public float getScale(float delta) {
            return this.getBaseScale(delta);
        }

        @Override
        public void setBaseScale(float scale) {
        }

        @Override
        public float getPrevScale() {
            return this.getPrevBaseScale();
        }

        @Override
        public void setTargetScale(float targetScale) {
        }

        @Override
        public void setScaleTickDelay(int ticks) {
        }

        @Override
        public void markForSync(boolean sync) {
        }

        @Override
        public void onUpdate() {
        }

        @Override
        public void readNbt(class_2487 tag) {
        }

        @Override
        public ScaleData resetScale(boolean notifyListener) {
            return this;
        }

        @Override
        public boolean isReset() {
            return true;
        }

        @Override
        public ScaleData fromScale(ScaleData scaleData, boolean notifyListener) {
            return this;
        }
    }
}

