/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.api;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_2960;
import virtuoel.pehkui.Pehkui;
import virtuoel.pehkui.api.ScaleModifier;
import virtuoel.pehkui.api.ScaleType;

public class ScaleRegistries {
    private static final Map<Map<class_2960, ?>, class_2960> REGISTRY_IDS = new IdentityHashMap();
    private static final Map<class_2960, Supplier<?>> DEFAULT_ENTRIES = new LinkedHashMap();
    private static final Map<class_2960, class_2960> DEFAULT_IDS = new LinkedHashMap<class_2960, class_2960>();
    public static final BiMap<class_2960, ScaleType> SCALE_TYPES = ScaleRegistries.create("scale_types", "invalid", () -> ScaleType.INVALID);
    public static final BiMap<class_2960, ScaleModifier> SCALE_MODIFIERS = ScaleRegistries.create("scale_modifiers", "identity", () -> ScaleModifier.IDENTITY);

    public static <E> E register(Map<class_2960, E> registry, class_2960 id, E entry) {
        return (E)registry.computeIfAbsent(id, i -> entry);
    }

    public static <E> E getEntry(Map<class_2960, E> registry, class_2960 id) {
        return registry.get(id);
    }

    public static <E> class_2960 getDefaultId(BiMap<class_2960, E> registry) {
        return DEFAULT_IDS.get(REGISTRY_IDS.get(registry));
    }

    public static <E> class_2960 getId(BiMap<class_2960, E> registry, E entry) {
        return (class_2960)registry.inverse().get(entry);
    }

    private static <E> BiMap<class_2960, E> create(String id, String defaultPath, Supplier<E> defaultEntry) {
        return ScaleRegistries.create(Pehkui.id(id), Pehkui.id(defaultPath), defaultEntry);
    }

    private static <E> BiMap<class_2960, E> create(class_2960 id, class_2960 defaultId, Supplier<E> defaultEntry) {
        HashBiMap registry = HashBiMap.create();
        REGISTRY_IDS.put((Map<class_2960, ?>)registry, id);
        DEFAULT_IDS.put(id, defaultId);
        DEFAULT_ENTRIES.put(id, defaultEntry);
        return registry;
    }
}

