/*
 * Decompiled with CFR 0.152.
 */
package squeek.appleskin.client;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1657;
import net.minecraft.class_1702;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_4493;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import squeek.appleskin.helpers.FoodHelper;
import squeek.appleskin.helpers.HungerHelper;

public class HUDOverlayHandler {
    private static float flashAlpha = 0.0f;
    private static byte alphaDir = 1;
    private static int foodIconsOffset;
    public static int FOOD_BAR_HEIGHT;
    private static final class_2960 modIcons;

    public static void onPreRender(class_4587 matrixStack) {
        foodIconsOffset = FOOD_BAR_HEIGHT;
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        int left = mc.method_22683().method_4486() / 2 + 91;
        int top = mc.method_22683().method_4502() - foodIconsOffset;
        HUDOverlayHandler.drawExhaustionOverlay(matrixStack, HungerHelper.getExhaustion((class_1657)player), mc, left, top, 1.0f);
    }

    public static void onRender(class_4587 matrixStack) {
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        class_1799 heldItem = player.method_6047();
        if (!FoodHelper.isFood(heldItem)) {
            heldItem = player.method_6079();
        }
        class_1702 stats = player.method_7344();
        int left = mc.method_22683().method_4486() / 2 + 91;
        int top = mc.method_22683().method_4502() - foodIconsOffset;
        HUDOverlayHandler.drawSaturationOverlay(matrixStack, 0.0f, stats.method_7589(), mc, left, top, 1.0f);
        if (heldItem.method_7960() || !FoodHelper.isFood(heldItem)) {
            flashAlpha = 0.0f;
            alphaDir = 1;
            return;
        }
        FoodHelper.BasicFoodValues foodValues = FoodHelper.getModifiedFoodValues(heldItem, (class_1657)player);
        HUDOverlayHandler.drawHungerOverlay(matrixStack, foodValues.hunger, stats.method_7586(), mc, left, top, flashAlpha, FoodHelper.isRotten(heldItem));
        int newFoodValue = stats.method_7586() + foodValues.hunger;
        float newSaturationValue = stats.method_7589() + foodValues.getSaturationIncrement();
        HUDOverlayHandler.drawSaturationOverlay(matrixStack, newSaturationValue > (float)newFoodValue ? (float)newFoodValue - stats.method_7589() : foodValues.getSaturationIncrement(), stats.method_7589(), mc, left, top, flashAlpha);
    }

    public static void drawSaturationOverlay(class_4587 matrixStack, float saturationGained, float saturationLevel, class_310 mc, int left, int top, float alpha) {
        if (saturationLevel + saturationGained < 0.0f) {
            return;
        }
        int startBar = saturationGained != 0.0f ? Math.max(0, (int)saturationLevel / 2) : 0;
        int endBar = (int)Math.ceil(Math.min(20.0f, saturationLevel + saturationGained) / 2.0f);
        int barsNeeded = endBar - startBar;
        mc.method_1531().method_22813(modIcons);
        HUDOverlayHandler.enableAlpha(alpha);
        for (int i = startBar; i < startBar + barsNeeded; ++i) {
            int x = left - i * 8 - 9;
            int y = top;
            float effectiveSaturationOfBar = (saturationLevel + saturationGained) / 2.0f - (float)i;
            if (effectiveSaturationOfBar >= 1.0f) {
                mc.field_1705.method_25302(matrixStack, x, y, 27, 0, 9, 9);
                continue;
            }
            if ((double)effectiveSaturationOfBar > 0.5) {
                mc.field_1705.method_25302(matrixStack, x, y, 18, 0, 9, 9);
                continue;
            }
            if ((double)effectiveSaturationOfBar > 0.25) {
                mc.field_1705.method_25302(matrixStack, x, y, 9, 0, 9, 9);
                continue;
            }
            if (!(effectiveSaturationOfBar > 0.0f)) continue;
            mc.field_1705.method_25302(matrixStack, x, y, 0, 0, 9, 9);
        }
        HUDOverlayHandler.disableAlpha(alpha);
        mc.method_1531().method_22813(class_437.field_22737);
    }

    public static void drawHungerOverlay(class_4587 matrixStack, int hungerRestored, int foodLevel, class_310 mc, int left, int top, float alpha, boolean useRottenTextures) {
        if (hungerRestored == 0) {
            return;
        }
        int startBar = foodLevel / 2;
        int endBar = (int)Math.ceil((float)Math.min(20, foodLevel + hungerRestored) / 2.0f);
        int barsNeeded = endBar - startBar;
        mc.method_1531().method_22813(class_437.field_22737);
        HUDOverlayHandler.enableAlpha(alpha);
        for (int i = startBar; i < startBar + barsNeeded; ++i) {
            int idx = i * 2 + 1;
            int x = left - i * 8 - 9;
            int y = top;
            int icon = 16;
            int background = 1;
            if (useRottenTextures) {
                icon += 36;
                background = 13;
            }
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(alpha * 0.1f));
            mc.field_1705.method_25302(matrixStack, x, y, 16 + background * 9, 27, 9, 9);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            if (idx < foodLevel + hungerRestored) {
                mc.field_1705.method_25302(matrixStack, x, y, icon + 36, 27, 9, 9);
                continue;
            }
            if (idx != foodLevel + hungerRestored) continue;
            mc.field_1705.method_25302(matrixStack, x, y, icon + 45, 27, 9, 9);
        }
        HUDOverlayHandler.disableAlpha(alpha);
    }

    public static void drawExhaustionOverlay(class_4587 matrixStack, float exhaustion, class_310 mc, int left, int top, float alpha) {
        mc.method_1531().method_22813(modIcons);
        float maxExhaustion = HungerHelper.getMaxExhaustion((class_1657)mc.field_1724);
        float ratio = Math.min(1.0f, Math.max(0.0f, exhaustion / maxExhaustion));
        int width = (int)(ratio * 81.0f);
        int height = 9;
        HUDOverlayHandler.enableAlpha(0.75f);
        mc.field_1705.method_25302(matrixStack, left - width, top, 81 - width, 18, width, height);
        HUDOverlayHandler.disableAlpha(0.75f);
        mc.method_1531().method_22813(class_437.field_22737);
    }

    private static void enableAlpha(float alpha) {
        RenderSystem.enableBlend();
        if (alpha == 1.0f) {
            return;
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        RenderSystem.blendFunc((class_4493.class_4535)class_4493.class_4535.field_22541, (class_4493.class_4534)class_4493.class_4534.field_22523);
    }

    private static void disableAlpha(float alpha) {
        RenderSystem.disableBlend();
        if (alpha == 1.0f) {
            return;
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void onClientTick() {
        if ((flashAlpha += (float)alphaDir * 0.125f) >= 1.5f) {
            flashAlpha = 1.0f;
            alphaDir = (byte)-1;
        } else if (flashAlpha <= -0.5f) {
            flashAlpha = 0.0f;
            alphaDir = 1;
        }
    }

    static {
        FOOD_BAR_HEIGHT = 39;
        modIcons = new class_2960("appleskin", "textures/icons.png");
    }
}

