/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.json;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.yungnickyoung.minecraft.yungsapi.json.ItemAdapter;
import com.yungnickyoung.minecraft.yungsapi.world.ItemSetSelector;
import java.io.IOException;
import java.util.Map;
import net.minecraft.class_1792;

public class ItemSetSelectorAdapter
extends TypeAdapter<ItemSetSelector> {
    public ItemSetSelector read(JsonReader reader) throws IOException {
        if (reader.peek() == JsonToken.NULL) {
            reader.nextNull();
            return null;
        }
        ItemSetSelector selector = new ItemSetSelector();
        reader.beginObject();
        while (reader.hasNext()) {
            switch (reader.nextName()) {
                case "entries": {
                    class_1792 item;
                    reader.beginObject();
                    while (reader.hasNext()) {
                        item = ItemAdapter.resolveItem(reader.nextName());
                        double probability = reader.nextDouble();
                        selector.addItem(item, (float)probability);
                    }
                    reader.endObject();
                    break;
                }
                case "defaultItem": {
                    class_1792 item = ItemAdapter.resolveItem(reader.nextString());
                    selector.setDefaultItem(item);
                }
            }
        }
        reader.endObject();
        return selector;
    }

    public void write(JsonWriter writer, ItemSetSelector selector) throws IOException {
        if (selector == null) {
            writer.nullValue();
            return;
        }
        writer.beginObject();
        writer.name("entries").beginObject();
        for (Map.Entry<class_1792, Float> entry : selector.getEntries().entrySet()) {
            writer.name(String.valueOf(entry.getKey())).value((Number)entry.getValue());
        }
        writer.endObject();
        String defaultItemString = String.valueOf(selector.getDefaultItem());
        writer.name("defaultItem").value(defaultItemString);
        writer.endObject();
    }
}

