/*
 * Decompiled with CFR 0.152.
 */
package io.github.joaoh1.okzoomer.client.config;

import io.github.fablabsmc.fablabs.api.fiber.v1.annotation.AnnotatedSettings;
import io.github.fablabsmc.fablabs.api.fiber.v1.annotation.SettingNamingConvention;
import io.github.fablabsmc.fablabs.api.fiber.v1.exception.FiberException;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.FiberSerialization;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.JanksonValueSerializer;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.ValueSerializer;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.ConfigTree;
import io.github.joaoh1.okzoomer.client.config.OkZoomerConfigPojo;
import io.github.joaoh1.okzoomer.client.config.OkZoomerLegacyConfigPojo;
import io.github.joaoh1.okzoomer.client.utils.ZoomUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;

public class OkZoomerConfig {
    public static boolean isConfigLoaded = false;
    public static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("okzoomer.json5");
    public static final Path LEGACY_CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("okzoomer-legacy.json5");
    private static final AnnotatedSettings ANNOTATED_SETTINGS = AnnotatedSettings.builder().useNamingConvention(SettingNamingConvention.SNAKE_CASE).build();
    private static final OkZoomerConfigPojo POJO = new OkZoomerConfigPojo();
    public static final ConfigTree TREE = ConfigTree.builder().applyFromPojo((Object)POJO, ANNOTATED_SETTINGS).build();
    private static final AnnotatedSettings LEGACY_ANNOTATED_SETTINGS = AnnotatedSettings.builder().useNamingConvention(SettingNamingConvention.NONE).build();
    private static final OkZoomerLegacyConfigPojo LEGACY_POJO = new OkZoomerLegacyConfigPojo();
    public static final ConfigTree LEGACY_TREE = ConfigTree.builder().applyFromPojo((Object)LEGACY_POJO, LEGACY_ANNOTATED_SETTINGS).build();
    private static JanksonValueSerializer serializer = new JanksonValueSerializer(false);

    public static void loadModConfig() {
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try {
                Files.readAllLines(CONFIG_PATH).forEach(string -> {
                    if (string.contains("\"hideHands\":")) {
                        try {
                            ZoomUtils.modLogger.info("[Ok Zoomer] A config file from the 4.0.0 alphas was found! It will be converted to the new format then used.");
                            LEGACY_ANNOTATED_SETTINGS.applyToNode(LEGACY_TREE, (Object)LEGACY_POJO);
                            FiberSerialization.deserialize((ConfigTree)TREE, (InputStream)Files.newInputStream(CONFIG_PATH, new OpenOption[0]), (ValueSerializer)serializer);
                            Files.copy(CONFIG_PATH, LEGACY_CONFIG_PATH, new CopyOption[0]);
                            OkZoomerConfigPojo.values.zoomDivisor = OkZoomerLegacyConfigPojo.zoomDivisor;
                            OkZoomerConfigPojo.values.minimumZoomDivisor = OkZoomerLegacyConfigPojo.minimumZoomDivisor;
                            OkZoomerConfigPojo.values.maximumZoomDivisor = OkZoomerLegacyConfigPojo.maximumZoomDivisor;
                            OkZoomerConfigPojo.features.cinematicCamera = OkZoomerLegacyConfigPojo.smoothCamera ? OkZoomerConfigPojo.FeaturesGroup.CinematicCameraOptions.VANILLA : OkZoomerConfigPojo.FeaturesGroup.CinematicCameraOptions.OFF;
                            OkZoomerConfigPojo.features.reduceSensitivity = OkZoomerLegacyConfigPojo.reduceSensitivity;
                            OkZoomerConfigPojo.features.zoomTransition = OkZoomerLegacyConfigPojo.smoothTransition ? OkZoomerConfigPojo.FeaturesGroup.ZoomTransitionOptions.SMOOTH : OkZoomerConfigPojo.FeaturesGroup.ZoomTransitionOptions.OFF;
                            OkZoomerConfigPojo.features.zoomMode = OkZoomerLegacyConfigPojo.zoomToggle ? OkZoomerConfigPojo.FeaturesGroup.ZoomModes.TOGGLE : OkZoomerConfigPojo.FeaturesGroup.ZoomModes.HOLD;
                            OkZoomerConfigPojo.features.zoomScrolling = OkZoomerLegacyConfigPojo.zoomScrolling;
                            OkZoomerConfigPojo.features.extraKeybinds = OkZoomerLegacyConfigPojo.zoomScrolling;
                            OkZoomerConfig.saveModConfig();
                        }
                        catch (FiberException | IOException e) {
                            e.printStackTrace();
                        }
                        return;
                    }
                });
                ANNOTATED_SETTINGS.applyToNode(TREE, (Object)POJO);
                FiberSerialization.deserialize((ConfigTree)TREE, (InputStream)Files.newInputStream(CONFIG_PATH, new OpenOption[0]), (ValueSerializer)serializer);
                isConfigLoaded = true;
            }
            catch (FiberException | IOException e) {
                e.printStackTrace();
            }
        } else {
            OkZoomerConfig.saveModConfig();
            isConfigLoaded = true;
        }
    }

    public static void saveModConfig() {
        try {
            ANNOTATED_SETTINGS.applyToNode(TREE, (Object)POJO);
            FiberSerialization.serialize((ConfigTree)TREE, (OutputStream)Files.newOutputStream(CONFIG_PATH, new OpenOption[0]), (ValueSerializer)serializer);
        }
        catch (FiberException | IOException e) {
            e.printStackTrace();
        }
    }
}

