/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.trinkets.api;

import dev.emi.trinkets.api.Trinket;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.class_1799;
import net.minecraft.class_2960;

public class TrinketSlots {
    public static List<SlotGroup> slotGroups = new ArrayList<SlotGroup>();

    public static void addSlotGroup(String name, String defaultSlot) {
        if (name.matches("^[a-zA-Z0-9]+$")) {
            for (SlotGroup group : slotGroups) {
                if (!group.name.equals(name)) continue;
                return;
            }
            SlotGroup group = new SlotGroup(name);
            group.defaultSlot = defaultSlot;
            slotGroups.add(group);
        } else {
            System.err.println("Failed to register slot " + name + ", identifiers must only be alphanumeric characters");
        }
    }

    private static void addSlotGroup(String name, int vanillaSlot) {
        if (name.matches("^[a-zA-Z0-9]+$")) {
            for (SlotGroup group : slotGroups) {
                if (!group.name.equals(name)) continue;
                return;
            }
            SlotGroup group = new SlotGroup(name);
            group.vanillaSlot = vanillaSlot;
            group.onReal = true;
            slotGroups.add(group);
        } else {
            System.err.println("Failed to register slot " + name + ", identifiers must only be alphanumeric characters");
        }
    }

    public static void addSlot(String groupName, String slotName, class_2960 texture) {
        if (slotName.matches("^[a-zA-Z0-9]+$")) {
            for (SlotGroup group : slotGroups) {
                if (!group.name.equals(groupName)) continue;
                for (Slot slot : group.slots) {
                    if (!slot.name.equals(slotName)) continue;
                    return;
                }
                if (!group.onReal && slotName.equals(group.defaultSlot) && group.slots.size() > 0) {
                    Slot s = group.slots.get(0);
                    group.slots.set(0, new Slot(slotName, texture, group));
                    group.slots.add(s);
                    continue;
                }
                group.slots.add(new Slot(slotName, texture, group));
            }
        } else {
            System.err.println("Failed to register slot " + groupName + ":" + slotName + ", identifiers must only be alpha characters");
        }
    }

    public static void addSlot(String groupName, String slotName, class_2960 texture, BiFunction<Slot, class_1799, Boolean> canEquip) {
        if (slotName.matches("^[a-zA-Z0-9]+$")) {
            for (SlotGroup group : slotGroups) {
                if (!group.name.equals(groupName)) continue;
                for (Slot slot : group.slots) {
                    if (!slot.name.equals(slotName)) continue;
                    slot.canEquip = canEquip;
                    return;
                }
                Slot newSlot = new Slot(slotName, texture, group);
                newSlot.canEquip = canEquip;
                if (!group.onReal && slotName.equals(group.defaultSlot) && group.slots.size() > 0) {
                    Slot s = group.slots.get(0);
                    group.slots.set(0, newSlot);
                    group.slots.add(s);
                    continue;
                }
                group.slots.add(newSlot);
            }
        } else {
            System.err.println("Failed to register slot " + groupName + ":" + slotName + ", identifiers must only be alpha characters");
        }
    }

    public static List<String> getAllSlotNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (SlotGroup group : slotGroups) {
            for (Slot slot : group.slots) {
                names.add(group.getName() + ":" + slot.getName());
            }
        }
        return names;
    }

    public static List<Slot> getAllSlots() {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        for (SlotGroup group : slotGroups) {
            for (Slot slot : group.slots) {
                slots.add(slot);
            }
        }
        return slots;
    }

    public static Slot getSlotFromName(String group, String slot) {
        for (SlotGroup g : slotGroups) {
            for (Slot s : g.slots) {
                if (!g.name.equals(group) || !s.name.equals(slot)) continue;
                return s;
            }
        }
        return null;
    }

    public static int getSlotCount() {
        int slotCount = 0;
        for (SlotGroup group : slotGroups) {
            slotCount += group.slots.size();
        }
        return slotCount;
    }

    static {
        TrinketSlots.addSlotGroup("head", 5);
        TrinketSlots.addSlotGroup("chest", 6);
        TrinketSlots.addSlotGroup("legs", 7);
        TrinketSlots.addSlotGroup("feet", 8);
        TrinketSlots.addSlotGroup("offhand", 45);
        TrinketSlots.addSlotGroup("hand", "gloves");
    }

    public static class Slot {
        private SlotGroup group;
        private String name;
        public boolean disableQuickMove = false;
        public class_2960 texture;
        public BiFunction<Slot, class_1799, Boolean> canEquip = (slot, stack) -> {
            if (!(stack.method_7909() instanceof Trinket)) {
                return false;
            }
            return ((Trinket)stack.method_7909()).canWearInSlot(slot.getSlotGroup().getName(), slot.getName());
        };

        public Slot(String name, class_2960 texture, SlotGroup group) {
            this.name = name;
            this.texture = texture;
            this.group = group;
        }

        public SlotGroup getSlotGroup() {
            return this.group;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class SlotGroup {
        private String name;
        public String defaultSlot;
        public List<Slot> slots = new ArrayList<Slot>();
        public boolean onReal = false;
        public int vanillaSlot = -1;

        public SlotGroup(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

