/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randompatches.client;

import com.therandomlabs.randompatches.RPConfig;
import com.therandomlabs.randompatches.RandomPatches;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.text.NumberFormat;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_1074;
import net.minecraft.class_155;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3268;
import net.minecraft.class_4536;
import net.minecraft.class_634;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.text.StrLookup;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.stb.STBImage;
import org.lwjgl.stb.STBImageResize;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

@Environment(value=EnvType.CLIENT)
public final class RPWindowHandler {
    private static final Pattern fabricPattern = Pattern.compile("^fabric-.*(-v\\d+)$");
    private static final StrSubstitutor titleSubstitutor = new StrSubstitutor((StrLookup)TitleLookup.access$200());
    private static int rootNonLibraryMods;
    private static @Nullable String activity;
    private static boolean enabled;

    private RPWindowHandler() {
    }

    public static void enable() {
        if (!enabled) {
            enabled = true;
            RPWindowHandler.getRootNonLibraryMods();
        }
    }

    public static void onConfigReload() {
        if (enabled) {
            class_310.method_1551().execute(RPWindowHandler::applySettings);
        }
    }

    public static String getWindowTitle() {
        if (!enabled) {
            return RPConfig.Window.DEFAULT_TITLE;
        }
        RPConfig.Window config = RandomPatches.config().client.window;
        class_310 mc = class_310.method_1551();
        class_634 handler = mc.method_1562();
        if (handler == null || !handler.method_2872().method_10758()) {
            activity = null;
            return titleSubstitutor.replace(config.title);
        }
        String activityKey = mc.method_1576() != null && !mc.method_1576().method_3860() ? "title.singleplayer" : (mc.method_1589() ? "title.multiplayer.realms" : (mc.method_1576() == null && (mc.method_1558() == null || !mc.method_1558().method_2994()) ? "title.multiplayer.other" : "title.multiplayer.lan"));
        activity = class_1074.method_4662((String)activityKey, (Object[])new Object[0]);
        return titleSubstitutor.replace(config.titleWithActivity);
    }

    public static void updateWindowIcon(@Nullable InputStream vanillaIcon16, @Nullable InputStream vanillaIcon32) {
        if (enabled && RandomPatches.config().client.window.customIcon) {
            RPWindowHandler.updateWindowIcon(vanillaIcon16, vanillaIcon32, class_310.method_1551().method_22683().method_4490());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateWindowIcon(@Nullable InputStream vanillaIcon16, @Nullable InputStream vanillaIcon32, long window) {
        block37: {
            if (FabricLoader.getInstance().getEnvironmentType() != EnvType.CLIENT || !enabled || !RandomPatches.config().client.window.customIcon) {
                return;
            }
            RPConfig.Window config = RandomPatches.config().client.window;
            class_310 mc = class_310.method_1551();
            InputStream stream16 = null;
            InputStream stream32 = null;
            InputStream stream256 = null;
            try {
                try (MemoryStack stack = MemoryStack.stackPush();){
                    boolean image256Resized;
                    if (config.icon16.isEmpty()) {
                        class_3268 vanillaPack = mc.method_1516().method_4633();
                        stream16 = vanillaIcon16 == null ? vanillaPack.method_14405(class_3264.field_14188, new class_2960("icons/icon_16x16.png")) : vanillaIcon16;
                        InputStream inputStream = stream32 = vanillaIcon32 == null ? vanillaPack.method_14405(class_3264.field_14188, new class_2960("icons/icon_32x32.png")) : vanillaIcon32;
                        if (class_310.field_1703) {
                            stream256 = vanillaPack.method_14405(class_3264.field_14188, new class_2960("icons/icon_256x256.png"));
                        }
                    } else {
                        stream16 = new FileInputStream(config.icon16);
                        stream32 = new FileInputStream(config.icon32);
                        if (class_310.field_1703) {
                            stream256 = new FileInputStream(config.icon256);
                        }
                    }
                    IntBuffer x = stack.mallocInt(1);
                    IntBuffer y = stack.mallocInt(1);
                    IntBuffer channels = stack.mallocInt(1);
                    GLFWImage.Buffer imageBuffer = GLFWImage.mallocStack((int)2, (MemoryStack)stack);
                    ByteBuffer image16 = RPWindowHandler.readImageToBuffer(stream16, x, y, channels, 16);
                    if (image16 == null) {
                        throw new IllegalStateException("Failed to load icon: " + STBImage.stbi_failure_reason());
                    }
                    boolean image16Resized = x.get(0) != 16 || y.get(0) != 16;
                    imageBuffer.position(0);
                    imageBuffer.width(16);
                    imageBuffer.height(16);
                    imageBuffer.pixels(image16);
                    ByteBuffer image32 = RPWindowHandler.readImageToBuffer(stream32, x, y, channels, 32);
                    if (image32 == null) {
                        throw new IllegalStateException("Failed to load icon: " + STBImage.stbi_failure_reason());
                    }
                    boolean image32Resized = x.get(0) != 32 || y.get(0) != 32;
                    imageBuffer.position(1);
                    imageBuffer.width(32);
                    imageBuffer.height(32);
                    imageBuffer.pixels(image32);
                    ByteBuffer image256 = null;
                    if (stream256 == null) {
                        image256Resized = false;
                    } else {
                        image256 = RPWindowHandler.readImageToBuffer(stream256, x, y, channels, 256);
                        if (image256 == null) {
                            throw new IllegalStateException("Failed to load icon: " + STBImage.stbi_failure_reason());
                        }
                        image256Resized = x.get(0) != 256 || y.get(0) != 256;
                        imageBuffer.position(2);
                        imageBuffer.width(256);
                        imageBuffer.height(256);
                        imageBuffer.pixels(image256);
                        imageBuffer.position(0);
                    }
                    imageBuffer.position(0);
                    GLFW.glfwSetWindowIcon((long)window, (GLFWImage.Buffer)imageBuffer);
                    if (image16Resized) {
                        MemoryUtil.memFree((Buffer)image16);
                    } else {
                        STBImage.stbi_image_free((ByteBuffer)image16);
                    }
                    if (image32Resized) {
                        MemoryUtil.memFree((Buffer)image32);
                    } else {
                        STBImage.stbi_image_free((ByteBuffer)image32);
                    }
                    if (class_310.field_1703) {
                        if (image256Resized) {
                            MemoryUtil.memFree((Buffer)image256);
                        } else {
                            STBImage.stbi_image_free((ByteBuffer)image256);
                        }
                    }
                }
                IOUtils.closeQuietly((InputStream)stream16);
            }
            catch (IOException ex) {
                RandomPatches.logger.error("Failed to load icon", (Throwable)ex);
                break block37;
            }
            finally {
                IOUtils.closeQuietly(stream16);
                IOUtils.closeQuietly(stream32);
                if (class_310.field_1703) {
                    IOUtils.closeQuietly(stream256);
                }
            }
            IOUtils.closeQuietly((InputStream)stream32);
            if (class_310.field_1703) {
                IOUtils.closeQuietly((InputStream)stream256);
            }
        }
    }

    private static void applySettings() {
        if (RandomPatches.config().client.window.customTitle) {
            class_310.method_1551().method_24288();
        }
        RPWindowHandler.updateWindowIcon(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static @Nullable ByteBuffer readImageToBuffer(InputStream stream, IntBuffer x, IntBuffer y, IntBuffer channels, int size) throws IOException {
        ByteBuffer resource = null;
        try {
            resource = class_4536.method_24962((InputStream)stream);
            resource.rewind();
            ByteBuffer image = STBImage.stbi_load_from_memory((ByteBuffer)resource, (IntBuffer)x, (IntBuffer)y, (IntBuffer)channels, (int)4);
            if (image == null) {
                ByteBuffer byteBuffer = null;
                return byteBuffer;
            }
            int width = x.get(0);
            int height = y.get(0);
            if (width == size && height == size) {
                ByteBuffer byteBuffer = image;
                return byteBuffer;
            }
            ByteBuffer resized = MemoryUtil.memAlloc((int)(size * size * 4));
            STBImageResize.stbir_resize_uint8((ByteBuffer)image, (int)width, (int)height, (int)0, (ByteBuffer)resized, (int)size, (int)size, (int)0, (int)4);
            STBImage.stbi_image_free((ByteBuffer)image);
            ByteBuffer byteBuffer = resized;
            return byteBuffer;
        }
        finally {
            if (resource != null) {
                MemoryUtil.memFree((Buffer)resource);
            }
        }
    }

    private static void getRootNonLibraryMods() {
        for (ModContainer mod : FabricLoader.getInstance().getAllMods()) {
            Matcher matcher;
            CustomValue parent;
            CustomValue generated;
            CustomValue api;
            ModMetadata metadata = mod.getMetadata();
            String id = metadata.getId();
            if ("minecraft".equals(id) || "fabric".equals(id) || "fabricloader".equals(id) || (api = metadata.getCustomValue("modmenu:api")) != null && api.getAsBoolean() || (generated = metadata.getCustomValue("fabric-loom:generated")) != null && generated.getAsBoolean() || (parent = metadata.getCustomValue("modmenu:parent")) != null && FabricLoader.getInstance().isModLoaded(parent.getAsString()) || FabricLoader.getInstance().isModLoaded("fabric") && ((matcher = fabricPattern.matcher(id)).matches() || "fabric-api-base".equals(id) || "fabric-renderer-indigo".equals(id))) continue;
            ++rootNonLibraryMods;
        }
    }

    private static final class TitleLookup
    extends StrLookup<String> {
        private static final TitleLookup INSTANCE = new TitleLookup();

        private TitleLookup() {
        }

        public @Nullable String lookup(String key) {
            if (key.equals("mcversion")) {
                return class_155.method_16673().getName();
            }
            if (key.equals("activity")) {
                return activity;
            }
            if (key.equals("username")) {
                return class_310.method_1551().method_1548().method_1676();
            }
            if (key.equals("modsloaded")) {
                return NumberFormat.getInstance().format(rootNonLibraryMods);
            }
            if (key.startsWith("modversion:")) {
                String modID = key.substring("modversion:".length());
                Optional container = FabricLoader.getInstance().getModContainer(modID);
                return container.map(modContainer -> modContainer.getMetadata().getVersion().getFriendlyString()).orElse(null);
            }
            return null;
        }

        static /* synthetic */ TitleLookup access$200() {
            return INSTANCE;
        }
    }
}

