/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.api.oldimpl;

import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.api.TileAPI;
import hunternif.mc.impl.atlas.client.BiomeTextureMap;
import hunternif.mc.impl.atlas.client.TextureSet;
import hunternif.mc.impl.atlas.client.TextureSetMap;
import hunternif.mc.impl.atlas.client.texture.TileTexture;
import hunternif.mc.impl.atlas.core.AtlasData;
import hunternif.mc.impl.atlas.ext.ExtTileTextureMap;
import hunternif.mc.impl.atlas.ext.TileDataStorage;
import hunternif.mc.impl.atlas.ext.TileIdRegisteredCallback;
import hunternif.mc.impl.atlas.network.packet.c2s.play.PutTileC2SPacket;
import hunternif.mc.impl.atlas.network.packet.s2c.play.CustomTileInfoS2CPacket;
import hunternif.mc.impl.atlas.network.packet.s2c.play.DeleteCustomGlobalTileS2CPacket;
import hunternif.mc.impl.atlas.network.packet.s2c.play.PutTileS2CPacket;
import hunternif.mc.impl.atlas.util.Log;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;

public class TileApiImpl
implements TileAPI {
    private final Map<class_2960, TileData> pendingTiles = new HashMap<class_2960, TileData>();

    public TileApiImpl() {
        TileIdRegisteredCallback.EVENT.register(this::onTileIdRegistered);
    }

    private static TileTexture[] convertToTileTexture(class_2960 ... textures) {
        TileTexture[] iTextures = new TileTexture[textures.length];
        for (int i = 0; i < textures.length; ++i) {
            iTextures[i] = new TileTexture(textures[i]);
        }
        return iTextures;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public TextureSet registerTextureSet(class_2960 name, class_2960 ... textures) {
        TextureSet textureSet = new TextureSet(name, TileApiImpl.convertToTileTexture(textures));
        TextureSetMap.instance().register(textureSet);
        return textureSet;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void setBiomeTexture(class_1959 biome, class_2960 textureSetName, class_2960 ... textures) {
        TextureSet set = new TextureSet(textureSetName, TileApiImpl.convertToTileTexture(textures));
        TextureSetMap.instance().register(set);
        BiomeTextureMap.instance().setTexture(biome, set);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void setBiomeTexture(class_1959 biome, TextureSet textureSet) {
        BiomeTextureMap.instance().setTexture(biome, textureSet);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void setCustomTileTexture(class_2960 uniqueTileName, class_2960 ... textures) {
        TextureSet set = new TextureSet(uniqueTileName, TileApiImpl.convertToTileTexture(textures));
        TextureSetMap.instance().register(set);
        this.setCustomTileTexture(uniqueTileName, set);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void setCustomTileTexture(class_2960 uniqueTileName, TextureSet textureSet) {
        ExtTileTextureMap.instance().setTexture(uniqueTileName, textureSet);
    }

    private void putTile(class_1937 world, int atlasID, class_2960 kind, int chunkX, int chunkZ) {
        class_5321 dimension = world.method_27983();
        if (world.field_9236) {
            new PutTileC2SPacket(atlasID, chunkX, chunkZ, kind).send();
        } else {
            AtlasData data = AntiqueAtlasMod.atlasData.getAtlasData(atlasID, world);
            data.setTile((class_5321<class_1937>)dimension, chunkX, chunkZ, kind);
            for (class_1657 syncedPlayer : data.getSyncedPlayers()) {
                new PutTileS2CPacket(atlasID, (class_5321<class_1937>)dimension, chunkX, chunkZ, kind).send((class_3222)syncedPlayer);
            }
        }
    }

    @Override
    public void putBiomeTile(class_1937 world, int atlasID, class_2960 biomeId, int chunkX, int chunkZ) {
        this.putTile(world, atlasID, biomeId, chunkX, chunkZ);
    }

    @Override
    public void putCustomTile(class_1937 world, int atlasID, class_2960 tileId, int chunkX, int chunkZ) {
        if (tileId == null) {
            Log.error("Attempted to put custom tile with null name", new Object[0]);
            return;
        }
        this.putTile(world, atlasID, tileId, chunkX, chunkZ);
    }

    @Override
    public void putCustomGlobalTile(class_1937 world, class_2960 tileId, int chunkX, int chunkZ) {
        if (tileId == null) {
            Log.error("Attempted to put custom global tile with null name", new Object[0]);
            return;
        }
        if (world.field_9236) {
            Log.warn("Client attempted to put global tile", new Object[0]);
            return;
        }
        TileDataStorage data = AntiqueAtlasMod.tileData.getData(world);
        data.setTile(chunkX, chunkZ, tileId);
        new CustomTileInfoS2CPacket((class_5321<class_1937>)world.method_27983(), chunkX, chunkZ, tileId).send(world.method_8503());
    }

    public void onTileIdRegistered(Collection<class_2960> ids) {
        for (class_2960 id : ids) {
            TileData tile = this.pendingTiles.remove(id);
            if (tile == null) continue;
            this.putBiomeTile(tile.world, tile.atlasID, id, tile.x, tile.z);
        }
    }

    @Override
    public void deleteCustomGlobalTile(class_1937 world, int chunkX, int chunkZ) {
        if (world.field_9236) {
            Log.warn("Client attempted to delete global tile", new Object[0]);
            return;
        }
        TileDataStorage data = AntiqueAtlasMod.tileData.getData(world);
        if (data.getTile(chunkX, chunkZ) != null) {
            data.removeTile(chunkX, chunkZ);
            new DeleteCustomGlobalTileS2CPacket((class_5321<class_1937>)world.method_27983(), chunkX, chunkZ).send(world.method_8503());
        }
    }

    private static class TileData {
        final class_1937 world;
        final int atlasID;
        final int x;
        final int z;

        TileData(class_1937 world, int atlasID, int x, int z) {
            this.world = world;
            this.atlasID = atlasID;
            this.x = x;
            this.z = z;
        }
    }
}

