/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.core;

import hunternif.mc.impl.atlas.core.BiomeDetectorBase;
import hunternif.mc.impl.atlas.core.IBiomeDetector;
import hunternif.mc.impl.atlas.ext.ExtTileIdMap;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2960;
import net.minecraft.class_4548;
import net.minecraft.class_5458;

public class BiomeDetectorNether
extends BiomeDetectorBase
implements IBiomeDetector {
    private static final int airProbeLevel = 50;
    private static final int lavaSeaLevel = 31;
    private static final int priorityLava = 1;

    @Override
    public class_2960 getBiomeID(class_1937 world, class_2791 chunk) {
        class_4548 chunkBiomes = chunk.method_12036();
        if (chunkBiomes == null) {
            return null;
        }
        HashMap<class_2960, Integer> biomeOccurrences = new HashMap<class_2960, Integer>(class_5458.field_25933.method_10235().size());
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                class_1959 biome = chunkBiomes.method_16359(x, 31, z);
                if (biome.method_8688() == class_1959.class_1961.field_9366) {
                    class_2248 netherBlock = chunk.method_8320(new class_2338(x, 31, z)).method_26204();
                    if (netherBlock == class_2246.field_10164) {
                        BiomeDetectorNether.updateOccurrencesMap(biomeOccurrences, ExtTileIdMap.TILE_LAVA, 1);
                        continue;
                    }
                    class_2680 netherBlockState = chunk.method_8320(new class_2338(x, 50, z));
                    if (netherBlockState.method_26215()) {
                        BiomeDetectorNether.updateOccurrencesMap(biomeOccurrences, ExtTileIdMap.TILE_LAVA_SHORE, 1);
                        continue;
                    }
                    BiomeDetectorNether.updateOccurrencesMap(biomeOccurrences, world, biome, 1);
                    continue;
                }
                BiomeDetectorNether.updateOccurrencesMap(biomeOccurrences, world, biome, this.priorityForBiome(biome));
            }
        }
        if (biomeOccurrences.isEmpty()) {
            return null;
        }
        Map.Entry meanBiome = Collections.max(biomeOccurrences.entrySet(), Comparator.comparingInt(Map.Entry::getValue));
        return (class_2960)meanBiome.getKey();
    }
}

