/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.core;

import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.core.AtlasData;
import hunternif.mc.impl.atlas.core.ITileStorage;
import hunternif.mc.impl.atlas.core.TileGroup;
import hunternif.mc.impl.atlas.network.packet.s2c.play.TileGroupsS2CPacket;
import hunternif.mc.impl.atlas.util.Log;
import hunternif.mc.impl.atlas.util.Rect;
import hunternif.mc.impl.atlas.util.ShortVec2;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;

public class WorldData
implements ITileStorage {
    public final AtlasData parent;
    public final class_5321<class_1937> world;
    private int browsingX;
    private int browsingY;
    private double browsingZoom = 0.5;
    private final Map<ShortVec2, TileGroup> tileGroups = new ConcurrentHashMap<ShortVec2, TileGroup>(2, 0.75f, 2);
    private final Rect scope = new Rect();

    public WorldData(AtlasData parent, class_5321<class_1937> world) {
        this.parent = parent;
        this.world = world;
    }

    public Map<ShortVec2, class_2960> getSeenChunks() {
        ConcurrentHashMap<ShortVec2, class_2960> chunks = new ConcurrentHashMap<ShortVec2, class_2960>(2, 0.75f, 2);
        for (Map.Entry<ShortVec2, TileGroup> entry : this.tileGroups.entrySet()) {
            int basex = entry.getValue().getScope().minX;
            int basey = entry.getValue().getScope().minY;
            for (int x = basex; x < basex + 16; ++x) {
                for (int y = basey; y < basey + 16; ++y) {
                    class_2960 t = entry.getValue().getTile(x, y);
                    if (t == null) continue;
                    chunks.put(new ShortVec2(x, y), t);
                }
            }
        }
        return chunks;
    }

    public void setBrowsingPosition(int x, int y, double zoom) {
        this.browsingX = x;
        this.browsingY = y;
        this.browsingZoom = zoom;
        if (this.browsingZoom <= 0.0) {
            Log.warn("Setting map zoom to invalid value of %f", zoom);
            this.browsingZoom = AntiqueAtlasMod.CONFIG.minScale;
        }
        this.parent.method_80();
    }

    public void setBrowsingPositionTo(class_1297 e) {
        this.setBrowsingPosition((int)Math.round(-e.method_23317() * AntiqueAtlasMod.CONFIG.defaultScale), (int)Math.round(-e.method_23321() * AntiqueAtlasMod.CONFIG.defaultScale), AntiqueAtlasMod.CONFIG.defaultScale);
    }

    public int getBrowsingX() {
        return this.browsingX;
    }

    public int getBrowsingY() {
        return this.browsingY;
    }

    public double getBrowsingZoom() {
        return this.browsingZoom;
    }

    @Override
    public void setTile(int x, int y, class_2960 tile) {
        ShortVec2 groupPos = new ShortVec2((int)Math.floor((float)x / 16.0f), (int)Math.floor((float)y / 16.0f));
        TileGroup tg = this.tileGroups.get(groupPos);
        if (tg == null) {
            tg = new TileGroup(groupPos.x * 16, groupPos.y * 16);
            this.tileGroups.put(groupPos, tg);
        }
        tg.setTile(x, y, tile);
        this.scope.extendTo(x, y);
        this.parent.method_80();
    }

    public void putTileGroup(TileGroup t) {
        ShortVec2 key = new ShortVec2(Math.floorDiv(t.scope.minX, 16), Math.floorDiv(t.scope.minY, 16));
        this.tileGroups.put(key, t);
        this.extendToTileGroup(t);
    }

    @Override
    public class_2960 removeTile(int x, int y) {
        return this.getTile(x, y);
    }

    @Override
    public class_2960 getTile(int x, int y) {
        ShortVec2 groupPos = new ShortVec2((int)Math.floor((float)x / 16.0f), (int)Math.floor((float)y / 16.0f));
        TileGroup tg = this.tileGroups.get(groupPos);
        if (tg == null) {
            return null;
        }
        return tg.getTile(x, y);
    }

    @Override
    public boolean hasTileAt(int x, int y) {
        return this.getTile(x, y) != null;
    }

    @Override
    public Rect getScope() {
        return this.scope;
    }

    public WorldData clone() {
        WorldData data = new WorldData(this.parent, this.world);
        data.tileGroups.putAll(this.tileGroups);
        data.scope.set(this.scope);
        return data;
    }

    public void addData(WorldData other) {
        for (Map.Entry<ShortVec2, TileGroup> e : other.tileGroups.entrySet()) {
            TileGroup group = e.getValue();
            Rect s = group.getScope();
            for (int x = s.minX; x <= s.maxX; ++x) {
                for (int y = s.minY; y <= s.maxY; ++y) {
                    class_2960 tile = group.getTile(x, y);
                    if (tile == null) continue;
                    this.setTile(x, y, tile);
                }
            }
        }
    }

    public class_2499 writeToNBT() {
        class_2499 tileGroupList = new class_2499();
        for (Map.Entry<ShortVec2, TileGroup> entry : this.tileGroups.entrySet()) {
            class_2487 newbie = new class_2487();
            entry.getValue().writeToNBT(newbie);
            tileGroupList.add((Object)newbie);
        }
        return tileGroupList;
    }

    private void extendToTileGroup(TileGroup tg) {
        for (int x = tg.scope.minX; x <= tg.scope.maxX; ++x) {
            for (int y = tg.scope.minY; y <= tg.scope.maxY; ++y) {
                if (!tg.hasTileAt(x, y)) continue;
                this.scope.extendTo(x, y);
            }
        }
    }

    public void readFromNBT(class_2499 me) {
        if (me == null) {
            return;
        }
        for (int d = 0; d < me.size(); ++d) {
            class_2487 tgTag = me.method_10602(d);
            TileGroup tg = new TileGroup(0, 0);
            tg.readFromNBT(tgTag);
            this.putTileGroup(tg);
        }
    }

    public void syncOnPlayer(int atlasID, class_1657 player) {
        Log.info("Sending dimension #%s", this.world.toString());
        ArrayList<TileGroup> tileGroups = new ArrayList<TileGroup>(100);
        int count = 0;
        int total = 0;
        for (Map.Entry<ShortVec2, TileGroup> t : this.tileGroups.entrySet()) {
            tileGroups.add(t.getValue());
            ++total;
            if (++count < 100) continue;
            new TileGroupsS2CPacket(atlasID, this.world, tileGroups).send((class_3222)player);
            tileGroups.clear();
            count = 0;
        }
        if (count > 0) {
            new TileGroupsS2CPacket(atlasID, this.world, tileGroups).send((class_3222)player);
        }
        Log.info("Sent dimension #%s (%d tiles)", this.world.toString(), total);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof WorldData)) {
            return false;
        }
        WorldData other = (WorldData)obj;
        if (other.tileGroups.size() != this.tileGroups.size()) {
            return false;
        }
        for (ShortVec2 entry : this.tileGroups.keySet()) {
            if (this.tileGroups.get(entry).equals(other.tileGroups.get(entry))) continue;
            return false;
        }
        return true;
    }
}

