/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.structure;

import com.google.common.collect.HashMultimap;
import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.api.AtlasAPI;
import hunternif.mc.impl.atlas.util.MathUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3449;
import net.minecraft.class_3545;
import net.minecraft.class_3773;
import net.minecraft.class_5321;

public class StructureHandler {
    private static final HashMultimap<class_2960, class_3545<class_2960, Setter>> STRUCTURE_PIECE_TO_TILE_MAP = HashMultimap.create();
    private static final HashMap<class_2960, class_3545<class_2960, class_2561>> STRUCTURE_PIECE_TO_MARKER_MAP = new HashMap();
    private static final HashMap<class_2960, Integer> STRUCTURE_PIECE_TILE_PRIORITY = new HashMap();
    private static final Setter ALWAYS = box -> Collections.singleton(new class_1923(MathUtil.getCenter(box).method_10263() >> 4, MathUtil.getCenter(box).method_10260() >> 4));

    public static void registerTile(class_3773 structurePieceType, int priority, class_2960 textureId, Setter setter) {
        class_2960 id = class_2378.field_16645.method_10221((Object)structurePieceType);
        STRUCTURE_PIECE_TO_TILE_MAP.put((Object)id, (Object)new class_3545((Object)textureId, (Object)setter));
        STRUCTURE_PIECE_TILE_PRIORITY.put(id, priority);
    }

    public static void registerTile(class_3773 structurePieceType, int priority, class_2960 textureId) {
        StructureHandler.registerTile(structurePieceType, priority, textureId, ALWAYS);
    }

    public static void registerMarker(class_3195<?> structureFeature, class_2960 markerType, class_2561 name) {
        STRUCTURE_PIECE_TO_MARKER_MAP.put(class_2378.field_16644.method_10221(structureFeature), (class_3545<class_2960, class_2561>)new class_3545((Object)markerType, (Object)name));
    }

    private static int getPriority(class_2960 structurePieceId) {
        return STRUCTURE_PIECE_TILE_PRIORITY.getOrDefault(structurePieceId, Integer.MAX_VALUE);
    }

    private static void put(class_2960 structurePieceId, class_1937 world, int chunkX, int chunkZ, class_2960 textureId) {
        class_2960 existingTile = AntiqueAtlasMod.tileData.getData((class_5321<class_1937>)world.method_27983()).getTile(chunkX, chunkZ);
        if (StructureHandler.getPriority(structurePieceId) < StructureHandler.getPriority(existingTile)) {
            AtlasAPI.tiles.putCustomGlobalTile(world, textureId, chunkX, chunkZ);
        }
    }

    public static void resolve(class_3443 structurePiece, class_3218 world) {
        class_2960 structurePieceId = class_2378.field_16645.method_10221((Object)structurePiece.method_16653());
        if (STRUCTURE_PIECE_TO_TILE_MAP.containsKey((Object)structurePieceId)) {
            for (class_3545 entry : STRUCTURE_PIECE_TO_TILE_MAP.get((Object)structurePieceId)) {
                Collection<class_1923> matches = ((Setter)entry.method_15441()).matches(structurePiece.method_14935());
                for (class_1923 pos : matches) {
                    StructureHandler.put(structurePieceId, (class_1937)world, pos.field_9181, pos.field_9180, (class_2960)entry.method_15442());
                }
            }
        }
    }

    public static void resolve(class_3449<?> structureStart, class_3218 world) {
        class_2960 structureId = class_2378.field_16644.method_10221((Object)structureStart.method_16656());
        if (STRUCTURE_PIECE_TO_MARKER_MAP.containsKey(structureId)) {
            AtlasAPI.markers.putGlobalMarker((class_1937)world, false, (class_2960)STRUCTURE_PIECE_TO_MARKER_MAP.get(structureId).method_15442(), (class_2561)STRUCTURE_PIECE_TO_MARKER_MAP.get(structureId).method_15441(), structureStart.method_14968().method_22874().method_10263(), structureStart.method_14968().method_22874().method_10260());
        }
    }

    static interface Setter {
        public Collection<class_1923> matches(class_3341 var1);
    }
}

