/*
 * Decompiled with CFR 0.152.
 */
package kenkron.antiqueatlasoverlay;

import com.mojang.blaze3d.systems.RenderSystem;
import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.RegistrarAntiqueAtlas;
import hunternif.mc.impl.atlas.client.BiomeTextureMap;
import hunternif.mc.impl.atlas.client.SubTile;
import hunternif.mc.impl.atlas.client.SubTileQuartet;
import hunternif.mc.impl.atlas.client.Textures;
import hunternif.mc.impl.atlas.client.TileRenderIterator;
import hunternif.mc.impl.atlas.client.gui.GuiAtlas;
import hunternif.mc.impl.atlas.core.WorldData;
import hunternif.mc.impl.atlas.item.AtlasItem;
import hunternif.mc.impl.atlas.marker.DimensionMarkersData;
import hunternif.mc.impl.atlas.marker.Marker;
import hunternif.mc.impl.atlas.marker.MarkersData;
import hunternif.mc.impl.atlas.registry.MarkerRenderInfo;
import hunternif.mc.impl.atlas.registry.MarkerType;
import hunternif.mc.impl.atlas.util.Rect;
import java.util.List;
import kenkron.antiqueatlasoverlay.SetTileRenderer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1158;
import net.minecraft.class_1160;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5321;

@Environment(value=EnvType.CLIENT)
public class OverlayRenderer
extends class_332 {
    private static final int CHUNK_SIZE = 16;
    private static final float INNER_ELEMENTS_SCALE_FACTOR = 1.9f;
    private class_310 client;
    private class_1657 player;
    private class_1937 world;
    private Integer atlasID;

    private Integer getPlayerAtlas(class_1657 player) {
        if (!AntiqueAtlasMod.CONFIG.itemNeeded) {
            return player.method_5667().hashCode();
        }
        class_1799 stack = player.method_6079();
        if (!stack.method_7960() && stack.method_7909() == RegistrarAntiqueAtlas.ATLAS) {
            return AtlasItem.getAtlasID(stack);
        }
        for (int i = 0; i < 9; ++i) {
            stack = player.field_7514.method_5438(i);
            if (stack.method_7960() || stack.method_7909() != RegistrarAntiqueAtlas.ATLAS) continue;
            return AtlasItem.getAtlasID(stack);
        }
        return null;
    }

    public void drawOverlay(class_4587 matrices) {
        if (class_310.method_1551().field_1755 instanceof GuiAtlas) {
            return;
        }
        if (class_310.method_1551().field_1687 == null || class_310.method_1551().field_1724 == null) {
            return;
        }
        this.client = class_310.method_1551();
        this.player = class_310.method_1551().field_1724;
        this.world = class_310.method_1551().field_1687;
        if (AntiqueAtlasMod.CONFIG.requiresHold) {
            class_1799 stack = this.player.method_6047();
            class_1799 stack2 = this.player.method_6079();
            if (!stack.method_7960() && stack.method_7909() == RegistrarAntiqueAtlas.ATLAS) {
                this.atlasID = AtlasItem.getAtlasID(stack);
            } else if (!stack2.method_7960() && stack2.method_7909() == RegistrarAntiqueAtlas.ATLAS) {
                this.atlasID = AtlasItem.getAtlasID(stack2);
            }
        } else {
            this.atlasID = this.getPlayerAtlas(this.player);
        }
        if (this.atlasID != null) {
            this.drawMinimap(matrices);
        }
        this.atlasID = null;
    }

    private void drawMinimap(class_4587 matrices) {
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        Textures.BOOK.draw(matrices, 0, 0, 465, 327);
        matrices.method_22903();
        matrices.method_22905(1.9f, 1.9f, 1.0f);
        this.drawTiles(matrices);
        if (AntiqueAtlasMod.CONFIG.markerSize > 0) {
            this.drawMarkers(matrices);
        }
        matrices.method_22909();
        this.drawPlayer(matrices);
        Textures.BOOK_FRAME.draw(matrices, 0, 0, 465, 327);
        RenderSystem.disableBlend();
        RenderSystem.enableDepthTest();
    }

    private void drawTiles(class_4587 matrices) {
        WorldData biomeData = AntiqueAtlasMod.atlasData.getAtlasData(this.atlasID, this.world).getWorldData((class_5321<class_1937>)this.world.method_27983());
        TileRenderIterator iter = new TileRenderIterator(biomeData);
        Rect iteratorScope = this.getChunkCoverage(this.player.method_19538());
        iter.setScope(iteratorScope);
        iter.setStep(1);
        class_243 chunkPosition = this.player.method_19538().method_18805(0.0625, 0.0625, 0.0625);
        int shapeMiddleX = 122;
        int shapeMiddleY = 86;
        SetTileRenderer renderer = new SetTileRenderer(matrices, AntiqueAtlasMod.CONFIG.tileSize / 2);
        while (iter.hasNext()) {
            SubTileQuartet subtiles = iter.next();
            for (SubTile subtile : subtiles) {
                if (subtile == null || subtile.tile == null) continue;
                float relativeChunkPositionX = (float)((double)subtile.x / 2.0 + (double)iteratorScope.minX - chunkPosition.field_1352);
                float relativeChunkPositionY = (float)((double)subtile.y / 2.0 + (double)iteratorScope.minY - chunkPosition.field_1350);
                renderer.addTileCorner(BiomeTextureMap.instance().getTexture(subtile).getTexture(), shapeMiddleX + (int)Math.floor(relativeChunkPositionX * (float)AntiqueAtlasMod.CONFIG.tileSize), shapeMiddleY + (int)Math.floor(relativeChunkPositionY * (float)AntiqueAtlasMod.CONFIG.tileSize), subtile.getTextureU(), subtile.getTextureV());
            }
        }
        renderer.draw();
    }

    private void drawMarkers(class_4587 matrices) {
        WorldData biomeData = AntiqueAtlasMod.atlasData.getAtlasData(this.atlasID, this.world).getWorldData((class_5321<class_1937>)this.world.method_27983());
        DimensionMarkersData globalMarkersData = AntiqueAtlasMod.globalMarkersData.getData().getMarkersDataInWorld((class_5321<class_1937>)this.world.method_27983());
        this.drawMarkersData(matrices, globalMarkersData, biomeData);
        MarkersData markersData = AntiqueAtlasMod.markersData.getMarkersData(this.atlasID, (class_1937)class_310.method_1551().field_1687);
        DimensionMarkersData localMarkersData = null;
        if (markersData != null) {
            localMarkersData = markersData.getMarkersDataInWorld((class_5321<class_1937>)this.world.method_27983());
        }
        this.drawMarkersData(matrices, localMarkersData, biomeData);
    }

    private void drawPlayer(class_4587 matrices) {
        matrices.method_22903();
        matrices.method_22904(232.0, 163.0, 0.0);
        matrices.method_22907(new class_1158(class_1160.field_20707, this.player.method_5791() + 180.0f, true));
        matrices.method_22904((double)(-AntiqueAtlasMod.CONFIG.playerIconWidth) / 2.0, (double)(-AntiqueAtlasMod.CONFIG.playerIconHeight) / 2.0, 0.0);
        Textures.PLAYER.draw(matrices, 0, 0, AntiqueAtlasMod.CONFIG.playerIconWidth, AntiqueAtlasMod.CONFIG.playerIconHeight);
        matrices.method_22909();
    }

    private void drawMarkersData(class_4587 matrices, DimensionMarkersData markersData, WorldData biomeData) {
        Rect mcchunks = this.getChunkCoverage(this.player.method_19538());
        Rect chunks = new Rect(mcchunks.minX / 8, mcchunks.minY / 8, (int)Math.ceil((float)mcchunks.maxX / 8.0f), (int)Math.ceil((float)mcchunks.maxY / 8.0f));
        int shapeMiddleX = 122;
        int shapeMiddleY = 86;
        class_243 chunkPosition = this.player.method_19538().method_18805(0.0625, 0.0625, 0.0625);
        for (int x = chunks.minX; x <= chunks.maxX; ++x) {
            for (int z = chunks.minY; z <= chunks.maxY; ++z) {
                List<Marker> markers = markersData.getMarkersAtChunk(x, z);
                if (markers == null) continue;
                for (Marker marker : markers) {
                    float relativeChunkPositionX = (float)((double)marker.getChunkX() - chunkPosition.field_1352);
                    float relativeChunkPositionY = (float)((double)marker.getChunkZ() - chunkPosition.field_1350);
                    this.renderMarker(matrices, marker, shapeMiddleX + (int)Math.floor(relativeChunkPositionX * 8.0f), shapeMiddleY + (int)Math.floor(relativeChunkPositionY * 8.0f), biomeData);
                }
            }
        }
    }

    private void renderMarker(class_4587 matrices, Marker marker, int x, int y, WorldData biomeData) {
        int tileHalfSize = 2;
        if (x + tileHalfSize > 240 || x - tileHalfSize < 3 || y + tileHalfSize >= 166 || y - tileHalfSize < 0) {
            return;
        }
        if (!marker.isVisibleAhead() && !biomeData.hasTileAt(marker.getChunkX(), marker.getChunkZ())) {
            return;
        }
        MarkerType type = (MarkerType)MarkerType.REGISTRY.method_10223(marker.getType());
        MarkerRenderInfo info = type.getRenderInfo(1.0, AntiqueAtlasMod.CONFIG.tileSize, 1.0);
        info.tex.draw(matrices, x - 8 + 4, y - 8 + 4, 16, 16);
    }

    private Rect getChunkCoverage(class_243 position) {
        int minChunkX = (int)Math.floor(position.field_1352 / 16.0 - (double)(310.0f / (4.0f * (float)AntiqueAtlasMod.CONFIG.tileSize)));
        int minChunkY = (int)Math.floor(position.field_1350 / 16.0 - (double)(218.0f / (4.0f * (float)AntiqueAtlasMod.CONFIG.tileSize)));
        int maxChunkX = (int)Math.ceil(position.field_1352 / 16.0 + (double)(310.0f / (4.0f * (float)AntiqueAtlasMod.CONFIG.tileSize)));
        int maxChunkY = (int)Math.ceil(position.field_1350 / 16.0 + (double)(218.0f / (4.0f * (float)AntiqueAtlasMod.CONFIG.tileSize)));
        return new Rect(minChunkX -= 4, minChunkY -= 3, maxChunkX += 4, maxChunkY += 2);
    }
}

