/*
 * Decompiled with CFR 0.152.
 */
package com.github.mnesikos.simplycats;

import com.github.mnesikos.simplycats.block.SCBlocks;
import com.github.mnesikos.simplycats.client.render.entity.SimplyCatRenderer;
import com.github.mnesikos.simplycats.configuration.SCConfig;
import com.github.mnesikos.simplycats.entity.SimplyCatEntity;
import com.github.mnesikos.simplycats.item.SCItems;
import com.github.mnesikos.simplycats.worldgen.villages.SCVillagers;
import com.github.mnesikos.simplycats.worldgen.villages.SCWorldGen;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@Mod(value="simplycats")
public class SimplyCats {
    public static final String MOD_ID = "simplycats";
    public static final ItemGroup ITEM_GROUP = new ItemGroup("simplycats.tab"){

        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)SCItems.PET_CARRIER.get());
        }
    };
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"simplycats");
    public static final RegistryObject<EntityType<SimplyCatEntity>> CAT = ENTITIES.register("cat", () -> EntityType.Builder.func_220322_a(SimplyCatEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.6f, 0.8f).setShouldReceiveVelocityUpdates(true).setTrackingRange(80).setUpdateInterval(1).func_206830_a("cat"));

    public SimplyCats() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, SCConfig.SPEC);
        ENTITIES.register(modBus);
        SCItems.REGISTRAR.register(modBus);
        SCBlocks.REGISTRAR.register(modBus);
        SCVillagers.PROFESSIONS.register(modBus);
        SCVillagers.POI_TYPES.register(modBus);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            modBus.addListener(this::setupClient);
        }
        forgeBus.addListener(SimplyCats::setupVillages);
    }

    public static void setupVillages(FMLServerAboutToStartEvent event) {
        SCWorldGen.setupVillageWorldGen(event.getServer().func_244267_aX());
    }

    private void setupClient(FMLClientSetupEvent event) {
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)CAT.get()), SimplyCatRenderer::new);
    }
}

