/*
 * Decompiled with CFR 0.152.
 */
package com.github.mnesikos.simplycats.block;

import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class LitterBoxBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final IntegerProperty LEVEL = BlockStateProperties.field_208130_ae;
    protected static final VoxelShape X_AXIS_AABB = LitterBoxBlock.func_208617_a((double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)4.0, (double)14.0);
    protected static final VoxelShape Z_AXIS_AABB = LitterBoxBlock.func_208617_a((double)2.0, (double)0.0, (double)0.0, (double)14.0, (double)4.0, (double)16.0);

    public LitterBoxBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(0.2f));
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)LEVEL, (Comparable)Integer.valueOf(0)));
    }

    public void setLevel(World world, BlockPos pos, BlockState state, int level) {
        world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)LEVEL, (Comparable)Integer.valueOf(level)), 2);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
        ItemStack itemStack = player.func_184586_b(hand);
        int level = (Integer)state.func_177229_b((Property)LEVEL);
        if (level == 0) {
            if (itemStack.func_77973_b() != Blocks.field_150354_m.func_199767_j()) {
                return ActionResultType.PASS;
            }
            this.setLevel(world, pos, state, 1);
            if (!player.func_184812_l_()) {
                itemStack.func_190918_g(1);
            }
        } else if (level == 1) {
            if (itemStack.func_77973_b() == Items.field_151103_aS) {
                this.setLevel(world, pos, state, 2);
            } else {
                ItemStack returnSand = new ItemStack((IItemProvider)Blocks.field_150354_m);
                if (!player.func_184812_l_()) {
                    if (itemStack.func_190926_b()) {
                        player.func_184611_a(hand, returnSand);
                    } else if (!player.func_191521_c(returnSand)) {
                        player.func_71019_a(returnSand, false);
                    }
                }
                this.setLevel(world, pos, state, 0);
            }
        } else {
            if (itemStack.func_77973_b() != Blocks.field_150354_m.func_199767_j()) {
                return ActionResultType.PASS;
            }
            this.setLevel(world, pos, state, 1);
            if (!player.func_184812_l_()) {
                itemStack.func_190918_g(1);
            }
        }
        return ActionResultType.SUCCESS;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction direction = context.func_195992_f().func_176734_d();
        return (BlockState)super.func_196258_a(context).func_206870_a((Property)FACING, (Comparable)direction);
    }

    public BlockState func_185499_a(BlockState state, Rotation rotation) {
        return state.func_177230_c() != this ? state : (BlockState)state.func_206870_a((Property)FACING, (Comparable)rotation.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> p_206840_1_) {
        p_206840_1_.func_206894_a(new Property[]{FACING, LEVEL});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        Direction direction = (Direction)state.func_177229_b((Property)FACING);
        return direction.func_176740_k() == Direction.Axis.X ? X_AXIS_AABB : Z_AXIS_AABB;
    }
}

